% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance_projection.R
\name{abundance_projection}
\alias{abundance_projection}
\title{Title
Project abundances from population dynamics models}
\usage{
abundance_projection(
  cxr_fit = NULL,
  model_family = NULL,
  alpha_form = NULL,
  lambda_cov_form = NULL,
  alpha_cov_form = NULL,
  lambda = NULL,
  alpha_matrix = NULL,
  lambda_cov = NULL,
  alpha_cov = NULL,
  covariates = NULL,
  timesteps = 2,
  initial_abundances = 0
)
}
\arguments{
\item{cxr_fit}{object of type `cxr_pm_multifit`. If this is not specified,
all parameters below are needed.}

\item{model_family}{acronym for model family. Included by default in `cxr` are
'BH' (Beverton-Holt), 'RK' (Ricker), 'LW' (Law-Watkinson), 'LV' (Lotka-Volterra).}

\item{alpha_form}{character, either "none","global", or "pairwise".}

\item{lambda_cov_form}{character, either "none" or "global".}

\item{alpha_cov_form}{character, either "none","global", or "pairwise".}

\item{lambda}{named vector with lambda values for all taxa to be projected.}

\item{alpha_matrix}{square matrix with taxa names in rows and columns.}

\item{lambda_cov}{optional named matrix with covariates in columns and taxa in rows,
representing the effect of each covariate on the lambda parameter of each taxa.}

\item{alpha_cov}{optional list. Each element of the named list represents the effects of
a covariate over alpha values. Thus, each list element contains a square matrix 
of the same dimensions as `alpha_matrix`, as returned from the function `cxr_pm_fit`.
Note that for alpha_cov_form = "global", all columns in this matrix are the same, as there is 
a single value per species.}

\item{covariates}{matrix or dataframe with covariates in columns and timesteps in rows.}

\item{timesteps}{number of timesteps to project.}

\item{initial_abundances}{named vector of initial abundances for all taxa.}
}
\value{
named matrix with projected abundance values for each taxa at each timestep.
}
\description{
The function projects a number of steps of a time-discrete model, 
with model parameters taken from a `cxr_pm_multifit` object or as
function arguments.
}
