% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalized_log.R
\name{generalized_log}
\alias{generalized_log}
\title{Generalized log transform data.}
\usage{
generalized_log(population, variables, offset = 1)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{variables}{character vector specifying observation variables.}

\item{offset}{optional offset parameter for the transformation.}
}
\value{
transformed data of the same class as \code{population}.
}
\description{
\code{generalized_log} transforms specified observation variables using \eqn{x = log( (x + sqrt(x ^ 2 + offset ^ 2 )) / 2 )}.
}
\examples{
population <- tibble::tibble(
  Metadata_Well = c("A01", "A02", "B01", "B02"),
  Intensity_DNA = c(8, 20, 12, 32)
)
variables <- c("Intensity_DNA")
generalized_log(population, variables)
}
