% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGAselID.R
\name{wholeChromosomeDeletion}
\alias{wholeChromosomeDeletion}
\title{wholeChromosomeDeletion}
\usage{
wholeChromosomeDeletion(individuals, chrConf, mutationChance)
}
\arguments{
\item{individuals}{dataset returned by Individuals().}

\item{chrConf}{Configuration of chromosomes returned by splitChromosomes().}

\item{mutationChance}{Chance for a deletion of a whole chromosome mutation to occur.}
}
\description{
Operator for the deletion of a whole chromosome.
}
\examples{
\dontrun{
library(ALL)
data(ALL)

demoALL<-ALL[1:12,1:8]

set.seed(1357)
population03<-InitialPopulation(demoALL, 4, 10)
individuals03<-Individuals(population03)
chrConf03<-splitChromosomes(demoALL, 2)
chrConf03
individuals03

wholeChromosomeDeletion(individuals03, chrConf03, 20)
 }
}

