% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{unpack_traces}
\alias{unpack_traces}
\alias{unpack_traces.traces_dm}
\alias{unpack_traces.traces_dm_list}
\title{Unpack/Destroy Traces Objects}
\usage{
unpack_traces(object, ...)

\method{unpack_traces}{traces_dm}(object, ..., unpack = TRUE)

\method{unpack_traces}{traces_dm_list}(object, ..., unpack = TRUE, conds = NULL)
}
\arguments{
\item{object}{an object of type \link{drift_dm} or \code{fits_ids_dm} (see
\link{load_fits_ids})}

\item{...}{further arguments passed on to the respective method.}

\item{unpack}{logical, indicating if the \code{traces_dm} objects
shall be unpacked. Default is \code{TRUE}.}

\item{conds}{optional character, indicating specific condition(s). The
default \code{NULL} will lead to \code{conds = conds(object)}. Thus, per default all
conditions are accessed.}
}
\value{
For \code{traces_dm_list}, the returned value is a list, if \code{conds} specifies more
than one condition. For example, if \code{conds = c("foo", "bar")}, then the
returned value is a list with the two (named) entries "foo" and "bar". If
the returned list would only have one entry (either because the
\code{traces_dm_list} has only one condition, see \link{conds}, or because a
user explicitly requested only one condition), then the underlying
array or \code{traces_dm} object is returned directly.

For \code{traces_dm}, \code{unpack_traces()} returns an array with the traces, if
\code{unpack=TRUE}. If \code{unpack=FALSE}, the unmodified object is returned.
}
\description{
\code{\link[=simulate_traces]{simulate_traces()}} provides a list of type \code{traces_dm_list},
containing arrays of type \code{traces_dm}. The respective classes were created
to ensure convenient plotting and printing, but they are not really
necessary. If users want to create their own figures or access the values of
the simulated traces, the data types can even mask the underlying properties.

The goal of \code{unpack_traces()} is to provide a convenient way to strip away
the attributes of \code{traces_dm_list} and \code{traces_dm} objects.
}
\details{
\code{unpack_traces()} is a generic function to strip away the "unnecessary"
information of \code{traces_dm_list} and \code{traces_dm} objects. These objects are
created when calling \code{\link[=simulate_traces]{simulate_traces()}}.

For \code{traces_dm_list}, \code{unpack_traces()} returns the
requested conditions (see the argument \code{conds}). The result contains
objects of type \code{traces_dm} if \code{unpack = FALSE}. For \code{unpack = TRUE},
the result contains the plain arrays with the traces.
}
\examples{
# get a pre-built model to demonstrate the function
my_model <- dmc_dm()
# get some traces ...
some_traces <- simulate_traces(my_model, k = 2, seed = 1)
# and then unpack them to get the underlying arrays
str(unpack_traces(some_traces))

}
