% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_outliers_boxplot.R
\name{outliers_boxplot}
\alias{outliers_boxplot}
\title{outliers_boxplot}
\usage{
outliers_boxplot(alpha = 1.5)
}
\arguments{
\item{alpha}{boxplot outlier threshold (default 1.5, but can be 3.0 to remove extreme values)}
}
\value{
returns an outlier object
}
\description{
The outliers_boxplot class uses box-plot definition for outliers_boxplot.
An outlier is a value that is below than \eqn{Q_1 - 1.5 \cdot IQR} or higher than \eqn{Q_3 + 1.5 \cdot IQR}.
The class remove outliers_boxplot for numeric attributes.
Users can set alpha to 3 to remove extreme values.
}
\examples{
# code for outlier removal
out_obj <- outliers_boxplot() # class for outlier analysis
out_obj <- fit(out_obj, iris) # computing boundaries
iris.clean <- transform(out_obj, iris) # returning cleaned dataset

#inspection of cleaned dataset
nrow(iris.clean)

idx <- attr(iris.clean, "idx")
table(idx)
iris.outliers_boxplot <- iris[idx,]
iris.outliers_boxplot
}
