% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{darchTest}
\alias{darchTest}
\title{Test classification network.}
\usage{
darchTest(darch, newdata = NULL, targets = T)
}
\arguments{
\item{darch}{\code{\linkS4class{DArch}} instance.}

\item{newdata}{New data to use, \code{NULL} to use training data.}

\item{targets}{Labels for the \code{data}, \code{NULL} to use training
labels (only possible when \code{data} is \code{NULL} as well).}
}
\value{
Vector containing error function output, percentage of incorrect
 classifications and absolute number of incorrect classifications.
}
\description{
Forward-propagate given data through the deep neural network and return
classification accuracy using the given labels.
}
\details{
This is primarily a convenience function similar to \link{predict.DArch} with
classification performance measurements instead of network output,
and it returns a list of accuracy indicators (raw network error, percentage
of incorrect classifications and absolute number of incorrect
classifications).
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, retainData = T)
classificationStats <- darchTest(model)
}
}
\seealso{
Other darch interface functions: \code{\link{darchBench}},
  \code{\link{darch}}, \code{\link{plot.DArch}},
  \code{\link{predict.DArch}}, \code{\link{print.DArch}}
}

