% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.recursive.r
\name{gl.collapse.recursive}
\alias{gl.collapse.recursive}
\title{Recursively collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse.recursive(gl, prefix = "collapse", tloc = 0, tpop = 2,
  nlimit = 10, v = 1)
}
\arguments{
\item{gl}{-- name of the genlight object from which the distance matricies are to be calculated [required]}

\item{prefix}{-- a string to be used as a prefix in generating the matricies of fixed differences (stored to disk) and the recode
tables (also stored to disk) [default "collapse"]}

\item{tloc}{-- threshold defining a fixed difference (e.g. 0.05 implies 95:5 vs 5:95 is fixed) [default 0]}

\item{tpop}{-- max number of fixed differences allowed in amalgamating populations [default 0]}

\item{nlimit}{-- number of individuals combined, taking into account missing data, required for a pair of populations to be examined for fixed differences [default 2]}

\item{v}{-- verbosity = 0, silent; 1, brief; 2, verbose [default 1]}
}
\value{
A new genlight object with recoded populations after amalgamations are complete.
}
\description{
This script generates a fixed difference matrix from a genlight object \{adegenet\} and from it generates a population recode
table used to amalgamate populations with a fixed difference count less than or equal to a specified tpop. 
The script then repeats the process until there is no further amalgamation of populations.
}
\details{
The distance matricies are generated by gl.fixed.diff(), a recode table is generated using gl.collapse() and the resultant
recode table is applied to the genlight object using gl.recode.pop(). The process is repeated as many times as necessary to
yield a final table with no fixed differences less than or equal to the specified threshold, tpop. 
The intermediate and final recode tables and distance matricies are stored to disk as csv files for use with other analyses. 
In particular, the recode tables can be edited to replace populaton labels with meaninful names and reapplied in sequence.
}
\examples{
#only used the first 20 individuals due to runtime reasons
fd <- gl.collapse.recursive(testset.gl[1:20,], prefix="testset",tloc=0,tpop=2)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
