% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dcboxplot}
\alias{dcboxplot}
\title{dcboxplot adds a box plot to the dashboard}
\usage{
dcboxplot(x, val, title = paste(x, "boxplot: ", val), spansize = 4,
  width = dashboard.env$outerwidth * spansize/12, height = 250)
}
\arguments{
\item{x}{column name of categorical variable of data frame \code{data} for drawing a box plot. One box is drawed for each distinct value of \code{x}}

\item{val}{column name of a single numerical variable in the data frame \code{data} for computing the size of the box}

\item{title}{character for the title of the generated box plot}

\item{spansize}{integer between 1 to 12 for the width of the element in the row}

\item{width}{integer for the width in pixel of the element in the web page}

\item{height}{integer for the height in pixel of the element in the web page}
}
\description{
\code{dcboxplot} generates a box plot
}
\examples{
dashboard_open(data=iris) # other options: pathoutput=getwd() ...
dcpiechart(x=names(iris)[5])
dcboxplot(x=names(iris)[5], val=names(iris)[3] )
dcbarchart(x=names(iris)[1] , gap=75)
dcpiechart(x=names(iris)[2])
dctable(index=names(iris)[5])
dashboard_launch(browse = FALSE) # Just generates files. Server is not launched
}

