% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata360.R
\name{get_metadata360}
\alias{get_metadata360}
\title{Get TC/Govdata360 metadata from API}
\usage{
get_metadata360(site = "tc", metadata_type = "countries")
}
\arguments{
\item{site}{string pertaining to the data360 site to download data from.
Possible choices: 'tc' for TCdata360, 'gov' for Govdata360}

\item{metadata_type}{string pertaining to the metadata to be downloaded.
Possible choices: 'countries' == Lists metadata for all countries and regions.
'indicators' == Lists metadata for all indicators. Does not return actual data.
'datasets' == Lists metadata for all datasets.}
}
\value{
Data frame (wide) containing requested metadata
}
\description{
Downloads the requested metadata by using the TCdata360 API at \url{https://tcdata360.worldbank.org/docs}
or Govdata360 API at \url{https://govdata360.worldbank.org/docs}.
The function generates a wide dataframe.
}
\details{
Hint: Want to get other data? Helpful functions include:
\itemize{
  \item See \code{\link{search_360}} to get search TC/Govdata360 indicators, countries, categories, and dataset lists.
  \item See \code{\link{get_data360}} to get actual indicator/dataset/country-level data.
  \item See \code{\link{get_resources360}} to get additional resource information.
}
}
\examples{
## Since all functions download data through API, these are wrapped with
## the "donttest" function as advised by CRAN
#get all indicator metadata in Govdata360
\donttest{df_indicators <- get_metadata360(site="gov", metadata_type = "indicators")}

#get all country metadata in TCdata360
\donttest{df_countries <- get_metadata360(metadata_type = 'countries')}

#get all dataset metadata in TCdata360
\donttest{df_datasets <- get_metadata360(metadata_type = 'datasets')}
}
