% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastFunctions.r
\name{fastFilterVariables}
\alias{fastFilterVariables}
\title{Filtering useless variables}
\usage{
fastFilterVariables(dataSet, verbose = TRUE, ...)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{verbose}{Should the algorithm talk (logical, default to TRUE)}

\item{...}{optional parameters to be passed to the function when called from another function}
}
\value{
The same dataSet set but with fewer columns. Columns that are constant, in double, 
or bijection of anotger have been deleted.
}
\description{
Delete columns that are constant or in double in your dataSet set.
}
\examples{
# First let's build a data.frame with 3 columns: a constant column, and a column in double
df <- data.frame(col1 = 1, col2 = rnorm(1e6), col3 = sample(c(1, 2), 1e6, replace = TRUE))
df$col4 <- df$col2
df$col5[df$col3 == 1] = "a"
df$col5[df$col3 == 2] = "b" # Same info than in col1 but with a for 1 and b for 2
head(df)

# Let's filter columns:
df <- fastFilterVariables(df)
head(df)
}
