% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readNWISgwl}
\alias{readNWISgwl}
\title{Reads groundwater level measurements from NWISweb.}
\usage{
readNWISgwl(siteNumbers, startDate = "", endDate = "")
}
\arguments{
\item{siteNumbers}{string USGS site number (or multiple sites).  This is usually an 8 digit number}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}
}
\description{
Reads groundwater level measurements from NWISweb. Mixed date/times come back from the service
depending on the year that the data was collected.
}
\examples{
siteNumber <- "434400121275801"
data <- readNWISgwl(siteNumber, '','')
sites <- c("434400121275801", "375907091432201")
data2 <- readNWISgwl(sites, '','')
}

