% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNWISqw.r
\name{readNWISqw}
\alias{readNWISqw}
\title{Raw Data Import for USGS NWIS QW Data}
\usage{
readNWISqw(siteNumbers, parameterCd, startDate = "", endDate = "",
  expanded = TRUE, reshape = FALSE, tz = "UTC")
}
\arguments{
\item{siteNumbers}{character of USGS site numbers.  This is usually an 8 digit number}

\item{parameterCd}{character that contains the code for a parameter
group, or a character vector of 5-digit parameter codes. See \bold{Details}.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the earliest possible record. Date arguments are always specified in local time.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the latest possible record. Date arguments are always specified in local time.}

\item{expanded}{logical defaults to \code{TRUE}. If \code{TRUE}, retrieves additional information. Expanded data includes
remark_cd (remark code), result_va (result value), val_qual_tx (result value qualifier code), meth_cd (method code),
dqi_cd (data-quality indicator code), rpt_lev_va (reporting level), and rpt_lev_cd (reporting level type). If \code{FALSE},
only returns remark_cd (remark code) and result_va (result value). Expanded = \code{FALSE} will not give
sufficient information for unbiased statistical analysis.}

\item{reshape}{logical, reshape the expanded data. If \code{TRUE}, then return a wide data frame with all water-quality in a single row for each sample. 
If \code{FALSE} (default), then return a long data frame with each water-quality result in a single row. This
argument is only applicable to expanded data. Data requested using \code{expanded=FALSE} is always returned in the wide format.}

\item{tz}{character to set timezone attribute of dateTime. Default is "UTC", and converts the 
date times to UTC, properly accounting for daylight savings times based on the data's provided tz_cd column.
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage", as well as the following which do not use daylight savings time: "America/Honolulu",
"America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla". See also  \code{OlsonNames()} 
for more information on time zones.}
}
\value{
A data frame with at least the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
sample_dt \tab Date \tab The date the sample was collected \cr 
sample_tm \tab character \tab The reported sample collection time \cr
startDateTime \tab POSIXct \tab Combining sample_dt and sample_tm, a date/time column is created, and converted into UTC 
(unless the tz argument specifies a different time zone)\cr
endDateTime \tab POSIXct \tab If any sample_end_dt and sample_end_dt exist, this column is created similar to startDateTime\cr
}

Further columns will be included depending on the requested output format (expanded = TRUE or FALSE).


There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
comment \tab character \tab Header comments from the RDB file \cr
siteInfo \tab data frame \tab A data frame containing information on the requested sites \cr
variableInfo \tab data frame \tab A data frame containing information on the requested parameters \cr
}
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{https://nwis.waterdata.usgs.gov/nwis/qwdata}
A list of parameter codes can be found here: \url{https://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{https://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\details{
Valid parameter code groups are "All," or group codes:
\tabular{ll}{
Code \tab Description\cr
INF \tab Information \cr
PHY \tab Physical \cr
INM \tab Inorganics, Major, Metals (major cations) \cr
INN \tab Inorganics, Major, Non-metals (major anions) \cr
NUT \tab Nutrient \cr
MBI \tab Microbiological \cr
BIO \tab Biological \cr
IMN \tab Inorganics, Minor, Non-metals \cr
IMM \tab Inorganics, Minor, Metals \cr
TOX \tab Toxicity \cr
OPE \tab Organics, pesticide \cr
OPC \tab Organics, PCBs \cr
OOT \tab Organics, other \cr
RAD \tab Radiochemical \cr
SED \tab Sediment \cr
POP \tab Population/community \cr
}
If more than one parameter group is requested, only sites that data for all requested groups are returned.
}
\examples{
site_ids <- c('04024430','04024000')
startDate <- '2010-01-01'
endDate <- ''
parameterCd <- c('34247','30234','32104','34220')
\donttest{
rawNWISqwData <- readNWISqw(site_ids,parameterCd,startDate,endDate)
rawNWISqwDataReshaped <- readNWISqw(site_ids,parameterCd,
          startDate,endDate,reshape=TRUE)
parameterCd <- "all"
rawNWISall <- readNWISqw(site_ids,parameterCd,
          startDate,endDate)
pgroup <- c("NUT")
rawNWISNutrients <- readNWISqw(site_ids,pgroup,
          startDate,endDate)
groups <- c("NUT","OPE")
rawNWISNutOpe <- readNWISqw(site_ids,groups,
          startDate,endDate) 
rawNWISOpe <- readNWISqw(site_ids,"OPE",
          startDate,endDate) 
         } 
}
\seealso{
\code{\link{readWQPdata}}, \code{\link{whatWQPsites}}, 
\code{\link{readWQPqw}}, \code{\link{constructNWISURL}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
