% Generated by roxygen2 (4.0.2): do not edit by hand
\name{csvdata}
\alias{csvdata}
\title{Create CsvData object from data.frame}
\usage{
csvdata(resource, dat, location, name = resource, dset.meta = NULL,
  cols.meta = NULL, update.fct = function(csv) return(data.frame()),
  verbose = TRUE, clss = "CsvData")
}
\arguments{
\item{resource}{the name of the resource. Required.}

\item{dat}{data.frame to convert to CsvData object. Required.}

\item{location}{either a Location object, or a character pointing to a local directory. See details.}

\item{name}{the physical name of the resource. Defaults to resource.}

\item{dset.meta}{A list of metadata on the dataset.}

\item{cols.meta}{A data.frame of metadata on the columns, rows are column names, columns are type, name, format}

\item{update.fct}{function for updating the data. the update method and update interval is specified as meta data.
Default is a function that returns an empty data.frame.}

\item{verbose}{print diagnostic messages (default=TRUE)}

\item{clss}{class to construct. Defaults to CsvData.}
}
\description{
This function takes a data.frame, its metadata and a location. The function writes the data
to the location and returns a CsvData object. The data.frame itself is not stored in this object.
}
\details{
If metadata is missing, it is set with sensible default values. The default values for the dataset metadata are
title=<resource name>, modified=<current timestamp>, encoding='UTF-8', type='csv2', all other entries missing.
The default values for column metadata are name=<column name of the data.frame>, type=<class(column)>,
format='%Y-%m-%d' for Date and '%Y-%m-%d %H:%M:%S' for POSIXt classes (otherwise missing).

No updating takes place here.
}

