% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pinaster}
\alias{pinaster}
\title{Contains tree-level variables for Pinus pinaster in the Baixo-Mino, Galicia, Spain.}
\format{
Contains tree-level variables, as follows:
\describe{
  \item{stand}{stand number from the sample tree was selected.}
\item{si}{Site index of the stand.}
\item{tree.no}{tree number.}
\item{dbh}{Diameter at breast height, in cm.}
\item{htot}{Total height, in m.}
 \item{d4}{Upper-stem diameter at 4 m, in cm.}
\item{vol.wb}{Tree gross volume, in m^{3} with bark.}
\item{vol.wob}{Tree gross volume, in m^{3} without bark.}
 }
}
\source{
The data are provided courtesy of Dr Christian Salas at
the Universidad Mayor (Santiago, Chile).
}
\usage{
data(pinaster)
}
\description{
These are tree-level measurement data of sample trees in the Baixo-Mino region in Galicia, Spain.
}
\examples{
data(pinaster)    
head(pinaster) 
}
\references{
- Salas C, Nieto L, Irisarri A. 2005. Modelos de volumen para Pinus pinaster Ait. en la comarca del Baixo Mino,
  Galicia, Espana. Quebracho 12: 11-22.
}
\keyword{datasets}
