% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{getD1Object}
\alias{getD1Object}
\alias{getD1Object,D1Client-method}
\title{Download a data object from the DataONE Federation.}
\usage{
getD1Object(x, identifier, ...)

\S4method{getD1Object}{D1Client}(x, identifier)
}
\arguments{
\item{x}{A D1Client instance}

\item{identifier}{The identifier of the object to download from DataONE}

\item{...}{(not yet used)}
}
\value{
A datapack:DataObject
}
\description{
An object is download from the DataONE network for the identifier that is provided.
}
\examples{
\dontrun{ 
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
dataObj <- getD1Object(d1c, pid)
data <- getData(dataObj)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
