/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.nio.charset.Charset;
import org.apache.james.mime4j.util.CharsetUtil;

public final class MessageUtils {
    public static final int STRICT_IGNORE = 1;
    public static final int STRICT_ERROR = 2;
    public static final int LENIENT = 3;
    public static final Charset ASCII = CharsetUtil.getCharset("US-ASCII");
    public static final Charset ISO_8859_1 = CharsetUtil.getCharset("ISO-8859-1");
    public static final Charset DEFAULT_CHARSET = ASCII;
    public static final String CRLF = "\r\n";
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SP = 32;
    public static final int HT = 9;

    public static boolean isASCII(char ch) {
        return (0xFF80 & ch) == 0;
    }

    public static boolean isASCII(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (MessageUtils.isASCII(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }
}

