% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_is_numeric_in.R
\name{util_is_numeric_in}
\alias{util_is_numeric_in}
\title{Create a predicate function to check for certain numeric properties}
\usage{
util_is_numeric_in(min = -Inf, max = +Inf, whole_num = FALSE, set = NULL)
}
\arguments{
\item{min}{if given, minimum for numeric values}

\item{max}{if given, maximum for numeric values}

\item{whole_num}{if TRUE, expect a whole number}

\item{set}{if given, a set, the value must be in (see \link{util_match_arg})}
}
\value{
a function that checks an \code{x} for the properties.
}
\description{
useful, e.g., for \link{util_expect_data_frame} and \link{util_expect_scalar}.
}
\examples{
\dontrun{
util_is_numeric_in(min = 0)(42)
util_is_numeric_in(min = 43)(42)
util_is_numeric_in(max = 3)(42)
util_is_numeric_in(whole_num = TRUE)(42)
util_is_numeric_in(whole_num = TRUE)(42.1)
util_is_numeric_in(set = c(1, 3, 5))(1)
util_is_numeric_in(set = c(1, 3, 5))(2)
}
}
