% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingPredictions.R
\name{RequestTrainingPredictions}
\alias{RequestTrainingPredictions}
\title{Request training predictions for a specific model.}
\usage{
RequestTrainingPredictions(model, dataSubset)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{dataSubset}{character. What data subset would you like to predict on?
Possible options are included in \code{DataSubset}. Possible options are:
\itemize{
  \item \code{DataSubset$All} will use all available data.
  \item \code{DataSubset$ValidationAndHoldout} will use all data except the
    training set.
  \item \code{DataSubset$Holdout} will use only holdout data.
}}
}
\value{
job Id
}
\description{
Request training predictions for a specific model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  RequestTrainingPredictions(model, dataSubset = DataSubset$All)
}
}
