% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimeModels.R
\name{ListPrimeModels}
\alias{ListPrimeModels}
\title{Retrieve information about all DataRobot Prime models for a DataRobot project}
\usage{
ListPrimeModels(project)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}
}
\value{
data.frame containing information about each DataRobot Prime model in a project (one row
  per Prime model).
}
\description{
This function requests the DataRobot Prime models information for the DataRobot
project specified by the project argument, described under Arguments.
}
\details{
The function returns data.frame containing information about each DataRobot Prime model in a
project (one row per Prime model)
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListPrimeModels(projectId)
}
}
