% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDeployment.R
\name{GetModelDeployment}
\alias{GetModelDeployment}
\title{Retrieve data on a specific model deployment.}
\usage{
GetModelDeployment(modelDeploymentId)
}
\arguments{
\item{modelDeploymentId}{character. ID of the model deployment to retrieve.}
}
\value{
A dataRobotModelDeployment object containing the following data:
\itemize{
  \item id character. The ID of the model deployment.
  \item model list. Details on the model associated with the model deployment. Contains:
    \itemize{
      \item uid character. The ID of the user who created the model.
      \item id character. The ID of the model.
      \item modelType character. The type of the model.
      \item prevRequestCount integer. The number of requests, within the previous time
         window specified in \code{trendTimeWindow}.
    }
  \item project dataRobotProject. The project object associated with the model. See
    \code{GetProject} for details.
  \item type character. The type of the model deployment. One of "sse", "dedicated", or
    "legacy_dedicated".
  \item status character. The status of the model deployment. One of "active", "inactive",
    or "archived". Statuses can be accessed via \code{ModelDeploymentStatus} enum list.
  \item user list. Details on the user who created the model deployment containing:
  \itemize{
    \item username character. The username of the user initiating deployment.
    \item firstName character. The first name of that user.
    \item lastName character. The last name of that user.
  }
  \item organizationId character. The ID of the organization associated with the model
    deployment.
  \item instance list. Details on the instance associated with the model deployment.
    Contains the following information:
    \itemize{
      \item id character. The ID of the dedicated prediction instance the model is
        deployed to.
      \item datarobotKey character. The key for the prediction instance.
      \item hostName character. The host name of the dedicated prediction instance.
      \item privateIp character. The IP address of the dedicated predicion instance.
      \item ormVersion character. The On-demand resource manager version of the dedicated
        prediction instance.
    }
  \item label character. A short label describing the model deployment.
  \item description character. A longer description describing the model deployment.
  \item predictionEndpoint character. The URL where the model is deployed and available
    for serving predictions.
  \item deployed logical. Whether the model deployment process has finished or not.
  \item createdAt datetime. The timestamp of the creation of the model deployment.
  \item updatedAt datetime. The timestamp of when the model deployment was last updated.
  \item serviceHealth character. The model health status. One of "passing", "warning", or
    "failing". Look at \code{serviceHealthMessages} or use
    \code{GetModelDeploymentServiceStatistics} for more information.
  \item serviceHealthMessages list. List of health messages detailing service health state.
    Contains the following information:
  \itemize{
    \item level character. The error level, one of "passing", "warning", or "failing".
    \item msgId character. The identifier for the message, such as "USER_ERRORS",
      "SERVER_ERRORS", or "NO_GOOD_REQUESTS".
    \item message character. A message describing the error with more detail.
  }
  \item recentRequestCount integer. The number of recent requests, within recent time window
    specified by \code{trendTimeWindow}.
  \item prevRequestCount integer. The number of requests within the previous time window
    specified by \code{trendTimeWindow}.
  \item relativeRequestsTrend numeric. Relative difference, as a percentage, between the
    number of prediction requests performed within the current time window and one time
    window before that. The size of the time window is specified by \code{trendTimeWindow}.
  \item trendTimeWindow character. The time window, speficied in number of days from "now".
  \item requestRates list. A history of request rates per day sorted in chronological order,
    with the last entry being the most recent (i.e., today).
}
}
\description{
ModelDeployments provide an interface for tracking the health and activity of predictions
made against a deployment model. The \code{GetModelDeploymentServiceStatistics} method can
be used to see current and historical trends in requests made and in user and server
error rates.
}
\examples{
\dontrun{
  modelDeploymentId <- "59a5af20c80891534e3c2bde"
  deployment <- GetTrainingPredictions(modelDeploymentId)
}
}
