% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject.R
\name{subject}
\alias{subject}
\alias{subject_create}
\alias{subject<-}
\alias{is.subject}
\title{Create/add/retrieve a subject}
\usage{
subject(x)

subject_create(
  term,
  schemeURI = NULL,
  valueURI = NULL,
  prefix = NULL,
  subjectScheme = NULL,
  classificationCode = NULL
)

subject(x) <- value

is.subject(x)
}
\arguments{
\item{x}{A dataset object created with \code{\link{dataset_df}} or
\code{dataset::\link{as_dataset_df}}.}

\item{term}{A subject term, for example, \code{"Data sets"}.}

\item{schemeURI}{The URI of the subject identifier scheme, for example
\code{"http://id.loc.gov/authorities/subjects"}}

\item{valueURI}{The URI of the subject term.
\code{"https://id.loc.gov/authorities/subjects/sh2018002256"}}

\item{prefix}{An abbreviated prefix of a scheme URI, for example,
\code{"lcch:"} representing \code{"http://id.loc.gov/authorities/subjects"}.
Widely used namespaces (schemes) have conventional abbreviations.}

\item{subjectScheme}{The name of the subject scheme or classification code or
authority if one is used. It is a namespace.}

\item{classificationCode}{The classificationCode subproperty may be used for
subject schemes, like ANZSRC, which do not have valueURIs for each subject term.}

\item{value}{A subject field created by \code{\link{subject}}.
The subject field is overwritten with this value.}
}
\value{
\code{subject(x)} returns the subject attribute of the
\code{\link{dataset_df}} object \code{x}, \code{subject(x)<-value} sets
the same attribute to \code{value} and invisibly returns the
\code{x} object with the changed attributes.

A \code{subject_create} returns a named list with the subject term,
the subject scheme, URIs and prefix.

\code{is.subject} returns a logical value, \code{TRUE} if the subject as a list
is well-formatted by \code{\link{subject_create}} with its necessary key-value pairs.
}
\description{
Create/add/retrieve a subject
}
\details{
The subject class and its function record the subject property of the dataset.
The DataCite definition allows the use of multiple subproperties, however, these
cannot be added to the standard \code{\link[utils:bibentry]{utils::bibentry}}
object. Therefore, if the user sets the value of the subject field to a
character string, it is added to the bibentry of the dataset, and also to
a separate \code{subject} attribute. If the user wants to use the more detailed
subproperties (see examples with \code{subject_create}), then the subject$term
value is added to the bibentry as a text, and the more complex subject object
is added as a separate attribute to the dataset_df object.#'
}
\examples{
# To set the subject of a dataset_df object:
subject(orange_df) <- subject_create(
  term = "Oranges",
  schemeURI = "http://id.loc.gov/authorities/subjects",
  valueURI = "http://id.loc.gov/authorities/subjects/sh85095257",
  subjectScheme = "LCCH",
  prefix = "lcch:"
)

# To retrieve the subject with its subproperties:
subject(orange_df)
}
