% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deter.R
\encoding{UTF-8}
\name{load_deter}
\alias{load_deter}
\title{DETER - Forest Degradation in the Brazilian Amazon}
\usage{
load_deter(dataset = NULL, raw_data, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("deter_amz", "deter_cerrado") with information about both Amazon and Cerrado}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on change in forest cover in the Amazon. Survey is done at state or municipal level. See \url{http://www.obt.inpe.br/OBT/assuntos/programas/amazonia/deter/deter}
}
\examples{
\dontrun{
# download raw data from all years from Amazonia
deter_amz <- load_deter(dataset = 'deter_amz',
                        raw_data = TRUE,
                        time_period = "all")
}
}
