% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cipo.R
\name{load_cipo}
\alias{load_cipo}
\title{Plataforma CIPÓ - Mappings on environmental crimes}
\usage{
load_cipo(dataset = "brazilian_actors", raw_data = FALSE, search = "")
}
\arguments{
\item{dataset}{A dataset name ("brazilian_actors", "international_cooperation", "forest_governance")}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{search}{A \code{string} that filters entries containing it.}
}
\value{
A \code{tibble} of the chosen CIPÓ spreadsheet.
}
\description{
Plataforma CIPÓ - Mappings on environmental crimes
}
\examples{
\dontrun{
# download the spreacdsheet on Brazilian actors involved in fighting environmental crimes
brazilian_actors <- load_cipo(dataset = "brazilian_actors")

# searching only for entries containing IBAMA
actors_ibama <- load_cipo(
  dataset = "brazilian_actors",
  search = "ibama"
)

# entries containing IBAMA or FUNAI
actors_ibama <- load_cipo(
  dataset = "brazilian_actors",
  search = "ibama|funai"
)
}

}
