% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otol_tree.R
\name{get_otol_synthetic_tree}
\alias{get_otol_synthetic_tree}
\title{Get an Open Tree of Life synthetic subtree of a set of given taxon names.}
\usage{
get_otol_synthetic_tree(
  input = NULL,
  ott_ids = NULL,
  otol_version = "v3",
  resolve = FALSE,
  ...
)
}
\arguments{
\item{input}{Optional. A character vector of names or a \code{datelifeQuery} object}

\item{ott_ids}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}}

\item{otol_version}{Version of Open Tree of Life to use}

\item{resolve}{Defaults to \code{TRUE}. Whether to resolve the tree at random or not.}

\item{...}{
  Arguments passed on to \code{\link[=check_ott_input]{check_ott_input}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
A phylo object
}
\description{
Get an Open Tree of Life synthetic subtree of a set of given taxon names.
}
