% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmax_check.R
\name{minmax_check}
\alias{minmax_check}
\title{Mimimum and Maximum Values Check}
\usage{
minmax_check(DD.dict, DS.data, verbose = TRUE, non.NA.missing.codes = NA)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of variables that violate the listed \code{MIN} or \code{MAX}.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (A list of variables that exceed the listed \code{MIN} or \code{MAX} values).
}
\description{
This function flags variables that have values exceeding the \code{MIN} or \code{MAX} listed in the data dictionary.
}
\examples{
# Example 1
# Fail check (incorrectly flagging NA value codes -9999
# and -4444 as outside of the min max range)
data(ExampleA)
minmax_check(DD.dict.A, DS.data.A)
# View out of range values:
details <- minmax_check(DD.dict.A, DS.data.A)$Information
details[[1]]$OutOfRangeValues
# Attempt 2, specifying -9999 and -4444 as missing value
# codes so check works correctly
minmax_check(DD.dict.A, DS.data.A, non.NA.missing.codes=c(-9999, -4444))

# Example 2
data(ExampleI)
minmax_check(DD.dict.I, DS.data.I, non.NA.missing.codes=c(-9999, -4444))
# View out of range values:
details <- minmax_check(DD.dict.I, DS.data.I, non.NA.missing.codes=c(-9999, -4444))$Information
details[[1]]$OutOfRangeValues
}
