% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\docType{class}
\name{dbcsp-class}
\alias{dbcsp-class}
\title{S4 class for representing DB-CSP (Distance-Based Common Spatial Patterns)}
\description{
An object of class dbcsp. 'dbcsp' stands for Distance-Based Common Spatial Patterns.
The object includes the Common Spatial Patterns filter obtained with the input lists and
using the distance method indicated.
}
\details{
The output is a list containing this information (\code{object@out}):
\itemize{
\item \code{vectors} The projection vectors obtained after applying CSP.
\item \code{eig} The eigenvalues obtained after applying CSP.
\item \code{proy} The variance values of the proyected signals obtained after applying CSP.
}

And if \code{training=TRUE} the following values are also saved:
\itemize{
\item \code{acc} The mean accuracy value obtained for training data applying cross validation.
\item \code{used_folds} List of the folds used in the cross validation.
\item \code{folds_acc} Accuracy values for each of the folds of the cross validation.
\item \code{model} The trained LDA classifier.
\item \code{selected_q} The number of vectors used when training.
}
}
\section{Slots}{

\describe{
\item{\code{X1}}{list of matrices for data class 1.}

\item{\code{X2}}{list of matrices for data class 2.}

\item{\code{q}}{integer value indicating the number of vectors used in the projection, by default \code{q=15}.}

\item{\code{labels}}{vector of two strings indicating labels names, by default names of variables X1 and X2.}

\item{\code{type}}{sets the type of distance to be considered, by default \code{type='EUCL'}.The supported distances are these ones
\itemize{
\item Included in TSdist: infnorm, ccor, sts, lb.keogh, edr, erp, lcss, fourier, tquest, dissim, acf, pacf, ar.lpc.ceps, ar.mah,
ar.mah.statistic, ar.mah.pvalue, ar.pic, cdm, cid, cor, cort, int.per, per, mindist.sax, ncd, pred, spec.glk, spec.isd,
spec.llr, pdc, frechet, tam.
\item Included in parallelDist: bhjattacharyya, bray, canberra, chord, divergence, dtw, euclidean, fJaccard, geodesic, hellinger,
kullback, mahalanobis, manhattan, maximum, minkowski, podani, soergel, wave, whittaker.
}}

\item{\code{w}}{weight for the distances mixture D_mixture = w*D_euclidean + (1-w)*D_type, by default \code{w=0.5}.}

\item{\code{mixture}}{logical value indicating whether to use distances mixture or not (EUCL + other), by default \code{mixture=FALSE}.}

\item{\code{training}}{logical value indicating whether to perform the training or not.}

\item{\code{fold}}{integer value, by default \code{fold=10}. It controls the number of partitions when training.
If \code{fold==1} a train/test split is performed, with p=0.2 for test indices.}

\item{\code{seed}}{numeric value, by default \code{seed=NULL}. Set a seed in case the results want to be replicable.}

\item{\code{eig.tol}}{numeric value, by default \code{eig.tol=1e-06}, tolerance to convert distance matrix to be definite positive.}

\item{\code{verbose}}{logical}

\item{\code{out}}{list containing the output.}
}}

\examples{
# To create an instance of a class dbcsp given data from 2 classes
x <- AR.data$come
y <- AR.data$five
dbcsp <- new("dbcsp", X1 = x, X2 = y)
}
\seealso{
\code{\link[=dbcsp-package]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link{train}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
