% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbparser.R
\docType{package}
\name{dbparser}
\alias{dbparser}
\title{dbparser: A package for reading and parsing \strong{DrugBank} xml database.}
\description{
The main purpose of the `dbparser` package is to parse
[DrugBank](https://www.drugbank.ca/) database which is downloadable in XML format
from [this link](https://www.DrugBank.ca/releases/latest).
}
\details{
The parsed data can then be explored and analyzed as desired by the user
 with the ability to save parsed data into desired database as well.


To achieve this purpose, `dbparser`` package provides three main categories
 of functions:

- xml db reader,

- \strong{DrugBank} elements parsers,

- and database related methods.

For more information kindly check the
reference/index (https://docs.ropensci.org/dbparser/reference/index.html)
}
\section{xml db reader functions}{

 Reads \strong{DrugBank} xml database and build drug elements full tree in
 memory
}

\section{parsers functions}{

 Each parser function is responsible of parsing certain drug element and
 returning its tibble with the ability to save it in a predefined database.

 Check this tutorial
 (https://docs.ropensci.org/dbparser/articles/dbparser.html)
}

\section{database functions}{

 To open a connection to given database in order to store parsed
 \strong{DrugBank} elements database.

 Check this tutorial
 (https://docs.ropensci.org/dbparser/articles/Database_Saving.html)
}

