% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{calcAfreq}
\alias{calcAfreq}
\title{Calculate Allele Frequencies}
\usage{
calcAfreq(dsmp, coi, tol = 1e-04, qstart = 0.5)
}
\arguments{
\item{dsmp}{a list with each element corresponding to one sample.}

\item{coi}{a vector containing complexity of infection for each sample.}

\item{tol}{convergence tolerance for frequency estimates.}

\item{qstart}{a starting value for frequencies.}
}
\value{
A list of allele frequencies, where each element is a numeric vector
containing frequencies for a single locus.
}
\description{
Calculates population allele frequencies from data, adjusting for COI.
}
\examples{
coi   <- getCOI(dsmp, lrank = 2)           # estimate COI first
afreq <- calcAfreq(dsmp, coi, tol = 1e-5)
}
