% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{read}
\alias{read}
\alias{readDat}
\alias{readAfreq}
\title{Read and Reformat Data}
\usage{
readDat(sfile, svar, lvar, avar, ...)

readAfreq(afile, lvar, avar, fvar, ...)
}
\arguments{
\item{sfile}{the name of the file containing sample data.}

\item{svar}{the name of the variable for sample ID.}

\item{lvar}{the name of the variable for locus/marker.}

\item{avar}{the name of the variable for allele/haplotype.}

\item{...}{additional arguments for \code{read.csv()}.}

\item{afile}{the name of the file containing population allele frequencies.}

\item{fvar}{the name of the variable for population allele frequiency.}
}
\value{
For \code{readDat}, a list with elements corresponding to samples.
Each element of the list is itself a list of binary vectors, one vector for
each locus. For \code{readAfreq}, a list with elements corresponding to
loci. The frequencies at each locus are normalized and sum to 1. Samples,
loci, and alleles are ordered by their IDs/names.
}
\description{
Reads data from \code{csv} files and reformats these data for further processing. Original data are assumed to be in a long format, with one row per allele.
}
\examples{
sfile <- system.file("extdata", "MozParagon.csv", package = "dcifer")
dsmp  <- readDat(sfile, svar = "sampleID", lvar = "locus", avar = "allele")

afile  <- system.file("extdata", "MozAfreq.csv", package = "dcifer")
afreq2 <- readAfreq(afile, lvar = "locus", avar = "allele", fvar = "freq")
dsmp2  <- matchAfreq(dsmp, afreq2)

}
\seealso{
\code{\link{matchAfreq}} for making sure that the list containing
sample data is conformable to provided population allele frequencies.
}
