% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ScoreDCM}
\alias{ScoreDCM}
\title{Score dichotomous response data using DCM and MCMC}
\usage{
ScoreDCM(observations, qmatrix, parameter.means, parameter.acov= NULL,
parameterization.method = "Mplus", is.kernel.parameters = FALSE, model.type = NULL,
nreps = 1000 , nchains = 1, initial.class = 1,  percent.reps.to.discard = 5)
}
\arguments{
\item{observations}{a data frame or matrix of dichotomous responses in wide format (\code{nobservations X nitems})}

\item{qmatrix}{a data frame or matrix of 1s and 0s indicating relation between items and attributes. This matrix specifies which items are required
for mastery of each attribute (i.e., latent variable). The matrix must be a size of \code{nitems X nattributes}}

\item{parameter.means}{a numerical vector of calibrated item and structural parameters. Values must be in the order of
\code{\link{GetParameterNames}} if parametrization method is Mplus and non-kernel parameters are used. If kernel parameters values
are used must be in order of \code{\link{GetKernelParameterNames}}}

\item{parameter.acov}{optional matrix of covariances of all model parameters. If \code{NULL} (the default) model parameters are not randomized
for each iteration of MCMC}

\item{parameterization.method}{optional character string of parameterization method used to calibrate parameters.
If not specified then the default will be set to \code{Mplus}}

\item{is.kernel.parameters}{If \code{FALSE} (the default), parameter values are of type \code{taus} and \code{nus} else they are of type
kernel parameters, i.e., \code{lambdas} and \code{gammas}}

\item{model.type}{If \code{is.kernel.parameter} is \code{TRUE}, model type must be one of \code{DCM}, \code{DINA}, \code{CRUM}, \code{DINO},
\code{NIDO}, \code{NCRUM}. Kernel parameters are different for each model type}

\item{nreps}{The number of iterations in MCMC per chain. If not specified the default is 1000}

\item{nchains}{The number of chains in MCMC. If not specified the default is 1}

\item{initial.class}{The initial value of the attribute profile for each respondent. If not specified the default is 1}

\item{percent.reps.to.discard}{The percent of iterations to be discarded. If not specifed then the default is 5}
}
\value{
ScoreDCM returns an object of class \code{\link{dcm.scorer.class}}; a list consisting of
\describe{
 \item{inputs}{a list of all input arguments to the funciton like observations, Q-matrix, parameter.means, etc.}
 \item{mcmc.inputs}{a list of all mcmc inputs}
 \item{results}{an object of \code{\link{all.results.class}} class; a list consisting of
   \describe{
     \item{attribute.profile.result}{an object of \code{\link{attribute.profile.class}}}
     \item{attribute.result}{an object of \code{\link{attribute.class}}}
     \item{parameter.result}{an object of \code{\link{parameter.class}}}
   }
 }
 \item{mcmc.outputs}{a list of all mcmc output}
}
The function \code{\link{summary}} is used to obtain and print a summary of
MCMC runs in the form of probabilities of mastering each attribute and attribute profile probabilities.
The function \code{\link{plot}} is used to plot the aggregated mean of both attribute mastery (type = "attr.means")
and attribute profile probabily (type = "attr.profile.means") across all respondents. Other plot options include
attribute mastery (type = "attr.profiles") and attribute profile probabilities (type = "attr.profile.profiles")
of individual respondents.
}
\description{
Given dichotomous response data, a Q-matrix (relation between items and attributes) and calibrated item and structural parameters
\code{ScoreDCM} estimates posterior probabilities of attribute profiles of respondents using a Diagnostic Classification Model (DCM)
and Markov Chain Monte Carlo (MCMC) method. The estimation procedure uses the loglinear cognitive diagnostic modeling (LDCM)
framework that allows for the estimation of a host of DCMs such as DCM, DINA, C-RUM, NIDO, NIDA, NC-RUM etc.
}
\examples{
\dontrun{

data(obervations.test)
data(qmatrix.test)
parameter.names <- GetParameterNames(qmatrix.test, ncol(qmatrix.test))
parameter.names
data(parameter.means.DCM.Mplus.test)
obj <- ScoreDCM(observations = observations.test, qmatrix = qmatrix.test
, parameter.means = parameter.means.DCM.Mplus.test)
summary(obj)
plot(obj)
}
}
\author{
Margi Dubal \email{margidubal@gmail.com} & Diane Losardo \email{dlosardo@amplify.com}
}

