% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_wrappers.R
\name{mdl_ranger}
\alias{mdl_ranger}
\title{Wrapper for \code{\link[ranger:ranger]{ranger::ranger()}}.}
\usage{
mdl_ranger(y, X, ...)
}
\arguments{
\item{y}{The outcome variable.}

\item{X}{The feature matrix.}

\item{...}{Additional arguments passed to \code{ranger}. See
\code{\link[ranger:ranger]{ranger::ranger()}} for a complete list of arguments.}
}
\value{
\code{mdl_ranger} returns an object of S3 class \code{ranger} as a
simple mask of the return object of \code{\link[ranger:ranger]{ranger::ranger()}}.
}
\description{
Simple wrapper for \code{\link[ranger:ranger]{ranger::ranger()}}.
}
\examples{
ranger_fit <- mdl_ranger(rnorm(100), matrix(rnorm(1000), 100, 10))
class(ranger_fit)
}
\references{
Wright M N, Ziegler A (2017). "ranger: A fast implementation of random
forests for high dimensional data in C++ and R." Journal of Statistical
Software 77(1), 1-17.
}
\seealso{
\code{\link[ranger:ranger]{ranger::ranger()}}

Other ml_wrapper: 
\code{\link{mdl_glmnet}()},
\code{\link{mdl_xgboost}()},
\code{\link{ols}()}
}
\concept{ml_wrapper}
