% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_IC}
\alias{compute_IC}
\title{Compute information criteria for the DDT-LCM model}
\usage{
compute_IC(result, burnin = 5000, ncores = 1L)
}
\arguments{
\item{result}{a "ddt_lcm" object}

\item{burnin}{an integer specifying the number of burn-in iterations from MCMC chain}

\item{ncores}{an integer specifying the number of cores to compute marginal posterior log-likelihood
in parallel}
}
\value{
a named list of the following elements
\describe{
\item{\code{WAIC_result}}{a list of WAIC-related results computed using the two methods}
\item{\code{DIC1}}{DIC computed using method 1.}
\item{\code{DIC2}}{DIC computed using method 2.}
}
}
\description{
Compute information criteria for the DDT-LCM model, including the Widely Applicable
Information Criterion (WAIC), and Deviance Information Criterion (DIC). WAIC and DIC are computed
using two different methods described in Gelman, Hwang, and Vehtari (2013), one based on (1) posterior
means and the other based on (2) posterior variances.
}
\examples{
data(result_hchs)
IC_result <- compute_IC(result = result_hchs, burnin = 50, ncores = 1L)
}
