% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_tree_with_barplot}
\alias{plot_tree_with_barplot}
\title{Plot the MAP tree and class profiles (bar plot) of summarized DDT-LCM results}
\usage{
plot_tree_with_barplot(
  tree_with_parameter,
  response_prob,
  item_membership_list,
  item_name_list = NULL,
  class_probability = NULL,
  class_probability_lower = NULL,
  class_probability_higher = NULL,
  color_palette = c("#E69F00", "#56B4E9", "#009E73", "#000000", "#0072B2", "#D55E00",
    "#CC79A7", "#F0E442", "#999999"),
  return_separate_plots = FALSE
)
}
\arguments{
\item{tree_with_parameter}{a "phylo4d" tree with node parameters}

\item{response_prob}{a K by J matrix, where the k,j-th element is the response
probability of item j for individuals in class k}

\item{item_membership_list}{a list of G elements, where the g-th element contains the
column indices of the observed data matrix corresponding to items in major group g}

\item{item_name_list}{a named list of G elements, where the g-th element contains a vector
of item names for items in \code{item_membership_list[[g]]}. The name of the g-th element is
the name of the major item group.}

\item{class_probability}{a length K vector, where the k-th element is the
probability of assigning an individual to class k. It does not have to sum up to 1}

\item{class_probability_lower}{a length K vector, 2.5\% quantile of posterior
the distribution.}

\item{class_probability_higher}{a length K vector, 97.5\% quantile of posterior
the distribution.}

\item{color_palette}{a vector of color names. Default is a color-blinded friendly palette.}

\item{return_separate_plots}{If FALSE (default), print the combined plot of MAP tree and
class profiles. If TRUE, return the tree plot, class profile plot, and data.table
used to create the plots in a list, without printing the combined plot.}
}
\value{
a ggplot2 object. A bar plot of item response probabilities.
}
\description{
Plot the MAP tree and class profiles (bar plot) of summarized DDT-LCM results
}
\examples{
# load the MAP tree structure obtained from the real HCHS/SOL data
data(data_synthetic)
# extract elements into the global environment
list2env(setNames(data_synthetic, names(data_synthetic)), envir = globalenv()) 
plot_tree_with_barplot(tree_with_parameter, response_prob, item_membership_list)
}
