%                               -*- Mode: Rd -*- 
% addrandomarrow.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:24 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Tue Jul 22 12:40:20 2003
% Update Count    : 21
% Status          : Unknown, Use with caution!
% 

\name{addrandomarrow}
\alias{addrandomarrow}
\alias{turnrandomarrow}
\alias{deleterandomarrow}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Adding/Turning/Removing random arrows}

\description{Create network with exactly one arrow added/turned/removed
  randomly chosen.
}

\usage{
addrandomarrow(nw,data,prior,trylist=vector("list",nw$n),nocalc=FALSE,
               timetrace=FALSE)
turnrandomarrow(nw,data,prior,trylist=vector("list",nw$n),nocalc=FALSE,
               timetrace=FALSE)
deleterandomarrow(nw,data,prior,trylist=vector("list"),nw$n),nocalc=FALSE,
               timetrace=timetrace)  }

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}, from which arrows are added/removed/turned.}
  \item{data}{a data frame used for learning the network, see \code{\link{network}}.}
  \item{prior}{a list describing parameter priors, generated by \code{\link{jointprior}}.}
  \item{trylist}{a list, used internally for reusing learning of nodes, see \code{\link{maketrylist}}.}
  \item{nocalc}{a logical. if \code{TRUE}, the learning procedure is not
    called. Used if only a random graph is wanted.}
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing information on the screen.}
}

\details{
  Given the starting network, a network is created with exactly
  one arrow added/turned/removed. The arrow is chosen randomly amongst all
  possibilities. If there are no possibilities, the original network is
  returned.  All networks are
  learned with the data in \code{df} using the prior information in
  \code{prior}. Used by \code{\link{perturb}}.
}

\seealso{\code{\link{perturb}}
  }

\value{A list with two elements
  \item{nw}{an object of class \code{\link{networkfamily}} with all
    created networks. All networks have been learned.} 
  \item{trylist}{an updated list, used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
fit       <- network(rats,specifygraph=FALSE,inspect=FALSE)
fit.prior <- jointprior(fit,12)
fit       <- learn(fit,rats,fit.prior)$nw
set.seed(10)
rats.extra <- addrandomarrow(fit,rats,fit.prior)$nw
rats.extra <- addrandomarrow(rats.extra,rats,fit.prior)$nw
rats.extra <- turnrandomarrow(rats.extra,rats,fit.prior)$nw
rats.extra <- deleterandomarrow(rats.extra,rats,fit.prior)$nw
plot(rats.extra)
}

\keyword{iplot}
