% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWhiteningMatrix.R
\name{getWhiteningMatrix}
\alias{getWhiteningMatrix}
\title{Get whitening matrix}
\usage{
getWhiteningMatrix(ecl, lambda)
}
\arguments{
\item{ecl}{estimate of covariance/correlation matrix from \link{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{lambda}{specify lambda and override value from \code{ecl}}
}
\value{
whitening matrix
}
\description{
Get whitening matrix implied by \link{eclairs} decompostion
}
\examples{
library(Rfast)

n <- 2000
p <- 3

Y <- matrnorm(n, p, seed = 1) * 10

# decorrelate with implicit whitening matrix
# give same result as explicity whitening matrix
ecl <- eclairs(Y, compute = "covariance")

# get explicit whitening matrix
W <- getWhiteningMatrix(ecl)

# apply explicit whitening matrix
Z1 <- tcrossprod(Y, W)

# use implicit whitening matrix
Z2 <- decorrelate(Y, ecl)

range(Z1 - Z2)

}
