% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepboost.R
\name{deepboost.evaluate}
\alias{deepboost.evaluate}
\title{Evaluates and prints statistics for a deepboost model}
\usage{
deepboost.evaluate(object, data)
}
\arguments{
\item{object}{A Deepboost S4 class object}

\item{data}{a \code{data.frame} object to evaluate with the model}
}
\value{
a list with model statistics - error, avg_tree_size, num_trees
}
\description{
Evaluates and prints statistics for a deepboost model
}
\examples{
dpb <- deepboost(y ~ .,
 data.frame(x1=rep(c(0,0,1,1),2),x2=rep(c(0,1,0,1),2),y=factor(rep(c(0,0,0,1),2))),
 num_iter=2,tree_depth=2)
deepboost.evaluate(dpb,data.frame(x1=rep(c(1,1,1,0),2),x2=rep(c(1,1,1,1),2)))
}

