% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomorpho.R
\name{geom_phylomorpho}
\alias{geom_phylomorpho}
\title{Plot a 2-D phylomorphospace in ggplot2}
\usage{
geom_phylomorpho(
  tree,
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  seg_args = list(),
  point_args = list(),
  arrow = NULL,
  arrow.fill = NULL,
  lineend = "butt",
  linejoin = "round",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{tree}{An object of class "phylo".}

\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example, to
use \code{position_jitter()}, give the position as \code{"jitter"}.
}}

\item{...}{Other arguments passed on to both \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} and
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{seg_args}{A list of arguments passed only to \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}.}

\item{point_args}{A list of arguments passed only to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{arrow.fill}{fill colour to use for the arrow head (if closed). \code{NULL}
means use \code{colour} aesthetic.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
This behaves similar to \code{\link[phytools:phylomorphospace]{phytools::phylomorphospace()}}, but is for plotting a
2-D phylomorphospace with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. This function works like any
other \code{ggplot2} geom; it can be combined with other geoms (see the example
below), and the output can be modified using scales, themes, etc.
}
\details{
The ancestral states are estimated using \code{\link[phytools:fastAnc]{phytools::fastAnc()}}. Note that
\code{phytools} is not necessarily installed with \code{deeptime}, but it is required
to use this function. Following the estimation of the ancestral states, the
nodes are connected using \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}, while the tips are
indicated using \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.

The default expectation is that the order of the data is the same order as
the tip labels of the tree (\code{tree$tip.label}). However, if this is not the
case, you can map the optional \code{label} aesthetic to a column in the data that
contains the tip names (see example below).
}
\examples{
library(ggplot2)
\dontshow{if (require(ape)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ape)
tr <- rtree(10)
dat <- data.frame(
  x = runif(10), y = runif(10), label = tr$tip.label,
  row.names = tr$tip.label
)
ggplot(dat, aes(x = x, y = y, label = label)) +
  geom_phylomorpho(tr) +
  geom_label(size = 5)
\dontshow{\}) # examplesIf}
}
