% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonymReport.R
\name{synonymReport}
\alias{synonymReport}
\title{Get summary report of "defrosted" query}
\usage{
synonymReport(defrosted, verbose = F)
}
\arguments{
\item{defrosted}{output of the function defrost()}

\item{verbose}{logical arguments can be turned on to list species which result in conflict. Default=FALSE}
}
\value{
returns either a data frame or list of summary statitics
}
\description{
This function produces a report of an undertaken defrost() query
}
\details{
One logical arguments can be turned on to summarize in terms of numbers of cases, or to provide species names of conflicting issues.
}
\examples{
#check out amphibiaweb taxonomy and extract only Bufonidae
head(amphweb$species)
amphweb.bufonidae<-amphweb[amphweb$family=="Bufonidae",]
#defrost bufonidae and inspect
bufonidae.defrosted<-defrost(query=amphweb.bufonidae$species)
synonymReport(bufonidae.defrosted)
}
