/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mgf;

import ch.fgcz.proteomics.dto.MassSpectrometryMeasurement;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class ReadMGF {
    public static MassSpectrometryMeasurement read(String fileName) {
        String source = ReadMGF.readHeader(fileName);
        if (source == null) {
            source = fileName;
        }
        MassSpectrometryMeasurement massSpectrometryMeasurement = new MassSpectrometryMeasurement(source);
        massSpectrometryMeasurement = ReadMGF.readLocal(fileName, massSpectrometryMeasurement);
        return massSpectrometryMeasurement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readHeader(String fileName) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
            String line = "";
            String[] partEqual = line.split("=");
            do {
                if ((line = bufferedReader.readLine()) == null) return null;
                if (!line.equals("BEGIN IONS")) continue;
                return null;
            } while (!line.contains("COM"));
            String string = partEqual[1];
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static MassSpectrometryMeasurement readLocal(String fileName, MassSpectrometryMeasurement massSpectrometryMeasurement) {
        try (BufferedReader bufferedreader = new BufferedReader(new FileReader(fileName));){
            String line = "";
            int chargeState = 0;
            int id = 0;
            String searchEngine = null;
            String typ = null;
            double peptidMass = 0.0;
            double rt = 0.0;
            ArrayList<Double> mz = new ArrayList<Double>();
            ArrayList<Double> intensity = new ArrayList<Double>();
            while ((line = bufferedreader.readLine()) != null) {
                String[] partEqual = line.split("=");
                String[] partSpace = line.split(" ");
                if (line.equals("BEGIN IONS")) {
                    chargeState = 0;
                    id = massSpectrometryMeasurement.getMSlist().size();
                    searchEngine = null;
                    typ = null;
                    peptidMass = 0.0;
                    rt = 0.0;
                    mz = new ArrayList();
                    intensity = new ArrayList();
                    continue;
                }
                if (line.equals("END IONS")) {
                    massSpectrometryMeasurement.addMS(typ, searchEngine, mz, intensity, peptidMass, rt, chargeState, id);
                    continue;
                }
                if (line.contains("CHARGE")) {
                    chargeState = Integer.parseInt(partEqual[1].substring(0, 1));
                    continue;
                }
                if (line.contains("TITLE")) {
                    typ = partEqual[1];
                    continue;
                }
                if (line.contains("RTINSECONDS")) {
                    rt = Double.parseDouble(partEqual[1]);
                    continue;
                }
                if (line.contains("PEPMASS")) {
                    String[] peptidMassSplit = partEqual[1].split(" ");
                    peptidMass = Double.parseDouble(peptidMassSplit[0]);
                    continue;
                }
                if (!ReadMGF.isDouble(partSpace[0]) || !ReadMGF.isDouble(partSpace[1])) continue;
                mz.add(Double.parseDouble(partSpace[0]));
                intensity.add(Double.parseDouble(partSpace[1]));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return massSpectrometryMeasurement;
    }

    private static boolean isDouble(String string) {
        Scanner scanner = new Scanner(string);
        boolean b = scanner.hasNextDouble();
        scanner.close();
        return b;
    }
}

