% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificDropoutMechanisms.R
\name{ConstantRateDrop}
\alias{ConstantRateDrop}
\title{Create a Dropout Mechanism with constant dropout rate}
\usage{
ConstantRateDrop(rate, var = 0)
}
\arguments{
\item{rate}{\code{C} described in the details}

\item{var}{\code{sigma^2} described in the details section, by default = 0}
}
\value{
A \code{DropoutMechanism} object
}
\description{
Creates an MCAR \code{DropoutMechanism} object where subject \code{i} dropout
is exponentially distributed with rate \code{Ri} where 
\code{Ri = C*exp(Xi)} for constant \code{C} and 
\code{Xi} a random normal variable with mean 0 and standard deviation \code{sigma}
}
\examples{
ConstantRateDrop(rate=0.0025)
ConstantRateDrop(rate=0.0025,var=1)
}
\seealso{
\code{\link{DropoutMechanism.object}}
}
