% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{Simfit}
\alias{Simfit}
\title{S3 generic for fitting models}
\usage{
Simfit(x, family = "negbin", equal.dispersion = TRUE, covar = NULL, ...)
}
\arguments{
\item{x}{The S3 object}

\item{family}{Either "negbin" for fitting a negative binomial model (using \code{MASS::glm.nb}),
"poisson" for fitting a poisson model (\code{glm}) or "quasipoisson" for fitting a quasipoisson model
\code{glm}}

\item{equal.dispersion}{logical, should the arms have the same dispersion parameter when
fitting negative binomial models}

\item{covar}{A formula containing the additional covariates to be used when calling \code{glm.nb} if
no covariates are included in the model this should be NULL, for example \code{~covar1 + covar2}
See vignette for further details}

\item{...}{Additional arguments to be passed to \code{glm} or \code{glm.nb}}
}
\value{
A \code{SingleSimFit} object
}
\description{
S3 generic for fitting models
}
\examples{
 
set.seed(1234)
sim <- SimulateComplete(study.time=1,number.subjects=50,
      event.rates=c(0.1,0.05),dispersions=0.1)
summary(Simfit(sim,equal.dispersion=TRUE))


}
\seealso{
\code{\link{SingleSimFit.object}}
}
