% $Id: timeseries.Rd 2 2010-07-07 13:40:59Z mariotomo $

\name{timeseries}
\alias{timeseries}
\title{creates a data.frame that is a time series set}
\description{
  
  using three of the four \code{from}, \code{to}, \code{by},
  \code{length.out} parameters, creates a data.frame that satisfies the
  requirements for a time series set.  any extra data is considered a
  measurement column and added in the standard R fashion.

  the returned data.frame has at least the column \code{timestamps}.
  the first timestamp is equal to \code{from}, the last is equal or less
  than \code{to}, the distance between two subsequent timestamps is
  \code{by}, there are \code{length.out} elements (\code{length.out - 1}
  steps of distance \code{by}).

  data may be specified as numeric, in which case it is considered
  indicating minutes, or as \code{POSIXct} objects.
  
}
\usage{
timeseries(from, to, by, length.out, ...)
}
\arguments{
  \item{from}{the starting instant of the resulting time series.
    either \code{POSIXct} or \code{double}.}
  \item{to}{the ending instant of the resulting time series.  either
    \code{POSIXct} or \code{double}.}
  \item{by}{the timestep in the timeseries.  either a \code{difftime} or a
    \code{numeric}}
  \item{length.out}{if specified, ensures the resulting timeseries
    contains \code{length.out} elements (\code{length.out - 1} steps).}
  \item{...}{any other named field is added as field in the resulting
    timeseries.  the lenght must match the \code{length.out} parameter.}
}
\examples{
firstminutes <- timeseries(0, 1000, by=50, constant=355/113)
uptomidnight <- timeseries(to=Sys.Date(), by=90, length.out=5, countdown=4:0)
}
