## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo=FALSE, fig.cap = "Timeline of Chad's constitutional events. Data generated by the Comparative Constitution Project's Chronology of Constitutional Events dataset.", fig.width=7, fig.height=5, fig.align='center'----

cce<-data.table::fread("ccpcce_v1_3.txt")
cce<-cce[country=="Chad"]
cce[evnttype=="samendment", evnttype:="amendment"]
cce[, evnttype:=stringr::str_to_title(evnttype)]
cce[evnttype=="Non-Event", evnttype:=NA]

events<-cce[!is.na(evnttype), .N]
positions <- rep_len(c(0.5, -0.5, 1.5, -1.5, 1.0, -1.0, 2, -2), 
                     length.out = events)
directions <- rep_len(c(1.0,-1.0), 
                      length.out = events)
year_buffer<-1
year_range<-seq(min(cce$year)-year_buffer, max(cce$year)+year_buffer)

cce<-cce[!is.na(evnttype)]
cce[, position:=positions][, direction:=directions]
cce[position<0, lab_position:=position-0.3][position>0, lab_position:=position+0.3]
cce[, event_lab:=paste0(evnttype, "\n (", year, ")")]

palette<-c("#003f5c","#58508d","#bc5090","#ff6361","#ffa600")

# Create timeline coordinates with an x and y axis
ggplot2::ggplot(cce, ggplot2::aes(x=year, y= position, col=evnttype, label=event_lab))+
  ggplot2::labs(col="Constitutional Event: ",
                x = "",
                y = "",
                title = "Timeline of Chad's Constitutional Events",
                subtitle = "Data Generated from CCP's Chronology of Constitutional Events")+
  ggplot2::scale_color_manual(values=palette[2:5])+
  ggplot2::geom_hline(yintercept=0, color = palette[1], size=2)+
  ggplot2::geom_segment(data=cce, 
                        ggplot2::aes(y=position,yend=0,xend=year), color=palette[1], size=1, alpha = 0.75)+
  ggplot2::geom_point(ggplot2::aes(y=position, col=evnttype), size=3)+
  ggplot2::geom_text(ggplot2::aes(y=lab_position,label=event_lab), size=3, show.legend = FALSE, color = "#3d3d3d")+
  ggplot2::theme_classic()+
  ggplot2::theme(axis.line.y = ggplot2::element_blank(),
                 axis.text.y = ggplot2::element_blank(),
                 axis.title.x = ggplot2::element_blank(),
                 axis.title.y = ggplot2::element_blank(),
                 axis.ticks.y = ggplot2::element_blank(),
                 axis.text.x = ggplot2::element_blank(),
                 axis.ticks.x = ggplot2::element_blank(),
                 axis.line.x = ggplot2::element_blank(),
                 legend.position = "bottom")

