# DEMIC

<!-- badges: start -->
  [![R-CMD-check](https://github.com/Ulthran/DEMIC/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/Ulthran/DEMIC/actions/workflows/R-CMD-check.yaml)
  [![Codecov test coverage](https://codecov.io/gh/Ulthran/DEMIC/branch/master/graph/badge.svg)](https://app.codecov.io/gh/Ulthran/DEMIC?branch=master)
  [![DOI:10.1038/s41592-018-0182-0](https://badgen.net/badge/Published%20in/Nat%20Methods/blue)](https://doi.org/10.1038/s41592-018-0182-0)
<!-- badges: end -->

## Introduction

DEMIC is an R package for comparing bacterial growth rates between metagenomic samples, based on inferred relative distances of contigs from replication origin according to their coverages. It works with a custom coverage report generated by [PyCov3](https://github.com/Ulthran/pycov3) that provides per-contig and per-sample coverage information for sliding windows over contigs.

## Installation

DEMIC can be installed with:

```r
install.packages("demic")
```

The development version can be installed from GitHub with:

```r
# install.packages("devtools")
devtools::install_github("Ulthran/DEMIC")
library(demic)
```

## Basic Usage

```r
library(demic)
eptrs1 <- est_ptr(ContigCluster1)
eptrs2 <- est_ptr(ContigCluster2)

colnames(eptrs1)
# [1] "sample"      "est_ptr"     "coefficient" "pValue"      "cor"         "correctY"

eptrs1["sample"]
# 1 Sample1
# 2 Sample2
# 3 Sample3

eptrs1["est_ptr"]
# 1 1.588210
# 2 2.296994
# 3 1.840564
```

With a PyCov3 report:

```r
X <- read.csv("cov3.cov3", stringsAsFactors = TRUE)
estptrs <- est_ptr(X)
```

## Docs and Additional Help

This package is designed to be used with the COV3 output files of [PyCov3](https://github.com/Ulthran/pycov3). Its usage can be seen in the context of the sunbeam extension [sbx_demic](https://github.com/Ulthran/sbx_demic). Please cite Gao, Y., Li, H. Quantifying and comparing bacterial growth dynamics in multiple metagenomic samples. Nat Methods 15, 1041–1044 (2018). https://doi.org/10.1038/s41592-018-0182-0.
