% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clim.twd.R
\name{clim.twd}
\alias{clim.twd}
\title{Calculating relative growth change during no-rain periods.}
\usage{
clim.twd(
  df,
  Clim,
  dailyValue = "max",
  thresholdClim = 0,
  thresholdDays = 2,
  norm = F,
  showPlot
)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and the dendrometer data in following columns.}

\item{Clim}{dataframe with the first column containing \code{doy} and second column containing corresponding climate data.}

\item{dailyValue}{either \emph{'max', 'min'}, or \emph{'mean'} for selecting the daily resampled value. Default is \emph{'max'}. See \code{\link[dendRoAnalyst:dendro.resample]{dendro.resample}} for details.}

\item{thresholdClim}{numeric, the theshold for the respective climatic parameter. E.g. if climatic data is precipitation then days, where precipitation is below or equal to this value, are considered as adverse climate. Dafault is 0.}

\item{thresholdDays}{numeric, the minimum number of consecutive adverse days to be considered for analysis. For example, \code{thresholdDays}=2 means the relative radial/circumferential change is calculated for adverse periods lasting for more than 2 days. Default is 2.}

\item{norm}{logical, if \code{TRUE} the function uses normalized data instead of original dataset. Default is \code{FALSE}.}

\item{showPlot}{logical, if \code{TRUE}, generates plots.}
}
\value{
A dataframe containing the respective periods, relative radial/circumference change for each tree, the ID for each period and their beginning and end.
}
\description{
This function calculates the number and the location of climatically adverse periods within a climate time series. The user can define a duration and threshold of these conditions. The function also provides the relative radial/circumferencial change during each adverse period for the original or normalized data. See \href{https://doi.org/10.3389/fpls.2019.00342}{Raffelsbauer et al., (2019)} for more details.
}
\examples{
library(dendRoAnalyst)
data(gf_nepa17)
data(ktm_rain17)
relative_dry_growth<-clim.twd(df=gf_nepa17, Clim=ktm_rain17, dailyValue='max', showPlot=TRUE)
1

head(relative_dry_growth,10)

}
\references{
Raffelsbauer V, Spannl S, Peña K, Pucha-Cofrep D, Steppe K, Bräuning A (2019) Tree Circumference Changes and Species-Specific Growth Recovery After Extreme Dry Events in a Montane Rainforest in Southern Ecuador. Front Plant Sci 10:342. https://doi.org/10.3389/fpls.2019.00342
}
