% Generated by roxygen2 (4.0.1): do not edit by hand
\name{set}
\alias{set}
\alias{set.dendlist}
\alias{set.dendrogram}
\title{Set (/update) features to a dendrogram}
\usage{
set(object, ...)

\method{set}{dendrogram}(object,
   what = c("labels",
            "labels_colors",
            "labels_cex",
            "leaves_pch",
            "leaves_cex",
            "leaves_col",
            "hang_leaves",
            "branches_k_color",
            "branches_col",
            "branches_lwd",
            "branches_lty",
            "by_labels_branches_col",
            "by_labels_branches_lwd",
            "by_labels_branches_lty",
            "clear_branches",
            "clear_leaves"
   ),
   value, ...)

\method{set}{dendlist}(object, ..., which)
}
\arguments{
\item{object}{a tree (\link{dendrogram}, or \link{dendlist})}

\item{what}{a character indicating what is the property of
the tree that should be set/updated. (see the usage and the example section
for the different options)}

\item{value}{an object with the value to set in the tree.
(the type of the value depends on the "what")}

\item{...}{passed to the specific function for more options.}

\item{which}{an integer vector indicating, in the case "object" is
a dendlist, on which of the trees should the modification be performed.
If missing - the change will be performed on all of objects in the dendlist.}
}
\value{
An updated dendrogram (or dendlist), with some change to
the parameters of it
}
\description{
a master function for updating various attributes and
features of dendrogram objects.
}
\details{
This is a wrapper function for many of the main tasks we
might wish to perform on a dendrogram before plotting.

The options of by_labels_branches_col, by_labels_branches_lwd, by_labels_branches_lty
have extra parameters: type, attr, TF_value. You can read more about them here:
\link{branches_attr_by_labels}
}
\examples{
\dontrun{

set.seed(23235)
ss <- sample(1:150, 10 )

# Getting the dend object
dend <- iris[ss,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend \%>\% plot

dend \%>\% labels
dend \%>\% set("labels", 1:10) \%>\% labels
dend \%>\% set("labels", 1:10) \%>\% plot
dend \%>\% set("labels_color") \%>\% plot
dend \%>\% set("labels_col", c(1,2)) \%>\% plot # Works also with partial matching :)
dend \%>\% set("labels_cex", c(1, 1.2)) \%>\% plot
dend \%>\% set("leaves_pch", NA) \%>\% plot
dend \%>\% set("leaves_pch", c(1:5)) \%>\% plot
dend \%>\% set("leaves_pch", c(19,19, NA)) \%>\%
   set("leaves_cex", c(1,2)) \%>\% plot
dend \%>\% set("leaves_pch", c(19,19, NA)) \%>\%
   set("leaves_cex", c(1,2)) \%>\%
   set("leaves_col", c(1,1,2,2)) \%>\%
   plot
dend \%>\% set("hang") \%>\% plot

dend \%>\% set("branches_k_col") \%>\% plot
dend \%>\% set("branches_k_col", c(1,2)) \%>\% plot
dend \%>\% set("branches_k_col", c(1,2,3), k=3) \%>\% plot
dend \%>\% set("branches_k_col", k=3) \%>\% plot

dend \%>\% set("branches_col", c(1,2, 1, 2, NA)) \%>\% plot
dend \%>\% set("branches_lwd", c(2,1,2)) \%>\% plot
dend \%>\% set("branches_lty", c(1,2,1)) \%>\% plot

#    clears all of the things added to the leaves
dend \%>\%
   set("labels_color", c(19,19, NA)) \%>\%
   set("leaves_pch", c(19,19, NA))  \%>\%  # plot
   set("clear_leaves") \%>\% # remove all of what was done until this point
   plot
# Different order
dend \%>\%
   set("leaves_pch", c(19,19, NA)) \%>\%
   set("labels_color", c(19,19, NA)) \%>\%
   set("clear_leaves") \%>\% plot


# doing this without chaining (\%>\%) will NOT be fun:
dend \%>\%
   set("labels", 1:10) \%>\%
   set("labels_color") \%>\%
   set("branches_col", c(1,2, 1, 2, NA)) \%>\%
   set("branches_lwd", c(2,1,2)) \%>\%
   set("branches_lty", c(1,2,1)) \%>\%
   set("hang") \%>\%
   plot

#----------------------------
# Examples for: by_labels_branches_col, by_labels_branches_lwd, by_labels_branches_lty

old_labels <- labels(dend)
dend \%>\%
   set("labels", seq_len(nleaves(dend))) \%>\%
   set("by_labels_branches_col", c(1:4, 7)) \%>\%
   set("by_labels_branches_lwd", c(1:4, 7)) \%>\%
   set("by_labels_branches_lty", c(1:4, 7)) \%>\%
   set("labels", old_labels) \%>\%
   plot

dend \%>\%
   set("labels", seq_len(nleaves(dend))) \%>\%
   set("by_labels_branches_col", c(1:4, 7), type = "any", TF_values = c(4,2)) \%>\%
   set("by_labels_branches_lwd", c(1:4, 7), type = "all", TF_values = c(4,1)) \%>\%
   set("by_labels_branches_lty", c(1:4, 7), TF_values = c(4,1)) \%>\%
   plot





#----------------------------
# A few dendlist examples:
dendlist(dend,dend) \%>\% set("hang") \%>\% plot
dendlist(dend,dend) \%>\% set("branches_k_col", k=3) \%>\% plot
dendlist(dend,dend) \%>\% set("labels_col", c(1,2)) \%>\% plot

dendlist(dend,dend) \%>\%
   set("hang") \%>\%
   set("labels_col", c(1,2), which = 1) \%>\%
   set("branches_k_col", k=3, which = 2) \%>\%
   set("labels_cex", 1.2) \%>\%
   plot


#----------------------------
# example of modifying the dendrogram in a heatmap:

library(gplots)
data(mtcars)
x  <- as.matrix(mtcars)
rc <- rainbow(nrow(x), start=0, end=.3)
cc <- rainbow(ncol(x), start=0, end=.3)

##
##' demonstrate the effect of row and column dendrogram options
##
require(magrittr)
Rowv_dend <- x \%>\% dist \%>\% hclust \%>\%
   as.dendrogram \%>\%
   set("branches_k", k = 3) \%>\%
   set("branches_lwd", 2) \%>\%  rotate_DendSer
Colv_dend <- t(x) \%>\% dist \%>\% hclust \%>\%
   as.dendrogram \%>\%
   set("branches_k", k = 3) \%>\%
   set("branches_lwd", 2) \%>\%  rotate_DendSer
heatmap.2(x, Rowv = Rowv_dend, Colv = Colv_dend)





}
}
\seealso{
\link{labels<-.dendrogram}, \link{labels_colors<-},
\link{hang.dendrogram}, \link{color_branches},
\link{assign_values_to_leaves_nodePar},
\link{assign_values_to_branches_edgePar},
\link{remove_branches_edgePar}, \link{remove_leaves_nodePar},
\link{noded_with_condition}, \link{branches_attr_by_labels},
\link{dendrogram}
}

