% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{ladderize}
\alias{ladderize}
\alias{ladderize.dendrogram}
\alias{ladderize.phylo}
\alias{ladderize.dendlist}
\title{Ladderize a Tree}
\usage{
ladderize(x, right = TRUE, ...)

\method{ladderize}{dendrogram}(x, right = TRUE, ...)

\method{ladderize}{phylo}(x, right = TRUE, phy, ...)

\method{ladderize}{dendlist}(x, right = TRUE, which, ...)
}
\arguments{
\item{x}{a tree object (either a \link{dendrogram}, \link{dendlist}, or \link[ape]{phylo})}

\item{right}{a logical (TRUE) specifying whether the smallest clade is on the right-hand side (when the tree is plotted upwards), or the opposite (if FALSE).}

\item{...}{Currently ignored.}

\item{phy}{a placeholder in case the user uses "phy ="}

\item{which}{an integer (can have any number of elements).
It indicates the elements in the \link{dendlist} to ladderize.
If missing, it will ladderize all the dendrograms in the dendlist.}
}
\value{
A rotated tree object
}
\description{
This function reorganizes the internal structure of the tree to get the ladderized effect when plotted.
}
\examples{

dend <- USArrests[1:8,] \%>\% dist \%>\% hclust \%>\% as.dendrogram \%>\% 
   set("labels_colors") \%>\% set("branches_k_color", k = 5)
set.seed(123)
dend <- shuffle(dend)

par(mfrow = c(1,3))
dend \%>\% plot(main = "Original")
dend \%>\% ladderize(TRUE) \%>\% plot(main = "Right (default)")
dend \%>\% ladderize(FALSE) \%>\% plot(main = "Left (rev of right)")

}
\seealso{
\code{\link[ape]{ladderize}},
\code{\link{rev.dendrogram}}, \code{\link{rotate}} ({dendextend}), \code{\link[ape]{rotate}} ({ape})
}
