# `sim_table(hol_rom)` results in the expected similarity table

    Code
      sim_table(hol_rom)
    Output
              series_a    series_b overlap            r        r_hol            t
      3      HOL_AAHOH   HOL_BDN2H      60  0.188406859  0.445023059  1.473570629
      7      HOL_AAHOH   HOL_BRBRH      87 -0.092025539  0.243008720 -0.857046488
      11     HOL_AAHOH   HOL_GKZBH      77  0.137326483  0.278197844  1.208635328
      13     HOL_AAHOH   HOL_IRRBH     187  0.493596957  0.393506269  7.740412083
      15     HOL_AAHOH   HOL_KBMBH     173  0.295691657  0.414522592  4.059485995
      18     HOL_AAHOH   HOL_KMBQH     122  0.321154212  0.591621699  3.730301947
      20     HOL_AAHOH   HOL_KORHH      85  0.050560394  0.288676503  0.463987099
      22     HOL_AAHOH   HOL_LATEH     103  0.298520123  0.201482556  3.158942695
      23     HOL_AAHOH   HOL_LKBBH      87  0.024049799  0.327189504  0.223093191
      24     HOL_AAHOH   HOL_LKSBH     118  0.302268769  0.498699727  3.429981790
      25     HOL_AAHOH   HOL_LKSHH     134  0.371330048  0.244677604  4.612151513
      29     HOL_AAHOH   HOL_MBRUH      87  0.065309029  0.459845937  0.606946798
      30     HOL_AAHOH   HOL_MBUFH     124  0.449018896  0.491842675  5.573291986
      32     HOL_AAHOH   HOL_MRBRH     138  0.303797212  0.559263260  3.732253762
      34     HOL_AAHOH   HOL_PALZH     158  0.306343579  0.421020482  4.032345115
      35     HOL_AAHOH   HOL_SQUSH     157  0.347714888  0.364675149  4.631992406
      39     HOL_AAHOH  HOL_TMB11H      87  0.441421672  0.414098997  4.562105380
      45     HOL_AAHOH   HOL_TRPBH      68  0.356284712  0.490183811  3.121132771
      46     HOL_AAHOH   HOL_TRRBH     101  0.158422177  0.533836233  1.604484047
      47     HOL_AAHOH   HOL_TRRSH     187  0.332296592  0.458285337  4.804963625
      49     HOL_AAHOH   HOL_UNLUH     187 -0.031712669  0.064022899 -0.432720785
      105    HOL_BDN2H   HOL_AAHOH      60  0.188406859  0.445023059  1.473570629
      117    HOL_BDN2H   HOL_IRRBH      60  0.581057202  0.596238067  5.483953185
      122    HOL_BDN2H   HOL_KMBQH      54  0.138911744  0.213496197  1.021193475
      125    HOL_BDN2H   HOL_LAGEH      58  0.433764001  0.341440542  3.634572700
      126    HOL_BDN2H   HOL_LATEH     326  0.475777446  0.081137615  9.751630705
      130    HOL_BDN2H   HOL_MANCH     226  0.121782161  0.215989030  1.840431010
      138    HOL_BDN2H   HOL_PALZH     146  0.127156008  0.409393249  1.543691654
      139    HOL_BDN2H   HOL_SQUSH      60  0.218914148  0.092752129  1.723311918
      142    HOL_BDN2H   HOL_TITEH      84  0.283233492  0.338320042  2.690555518
      150    HOL_BDN2H   HOL_TRRBH     276  0.252126581  0.518011876  4.320627392
      151    HOL_BDN2H   HOL_TRRSH      60  0.435542796  0.176853289  3.716492486
      153    HOL_BDN2H   HOL_UNLUH      91  0.064324801  0.242647987  0.611505061
      161    HOL_BENGH   HOL_BERLH      59  0.303932199  0.185960846  2.429614840
      164    HOL_BENGH   HOL_BROIH      69  0.489170203  0.271041933  4.624919424
      173    HOL_BENGH   HOL_KKNAH      69  0.282119113  0.225799744  2.424915353
      175    HOL_BENGH   HOL_KORBH      63  0.665527356  0.315735142  7.021106644
      212    HOL_BERLH   HOL_BENGH      59  0.303932199  0.185960846  2.429614840
      216    HOL_BERLH   HOL_BROIH     220  0.719781537  0.176768041 15.343970174
      218    HOL_BERLH   HOL_ERP1H      93  0.450376684  0.050316658  4.838345011
      225    HOL_BERLH   HOL_KKNAH     228  0.648796646  0.304733827 12.845725876
      227    HOL_BERLH   HOL_KORBH      53  0.606828824  0.179090988  5.505442498
      241    HOL_BERLH   HOL_OB2BH     150  0.491688025  0.148084800  6.892528861
      267    HOL_BICKH   HOL_BRBRH      54  0.470995986  0.250731594  3.887048085
      271    HOL_BICKH   HOL_GKZBH      59  0.038772914  0.445440499  0.295507924
      272    HOL_BICKH   HOL_GUSTH      77  0.391801212  0.397332816  3.712454943
      274    HOL_BICKH   HOL_K9SAH      77 -0.079101900  0.095084116 -0.691761992
      275    HOL_BICKH   HOL_KBMBH      77  0.205125340  0.295696702  1.827093086
      283    HOL_BICKH   HOL_LKBBH      77  0.490403004  0.337521326  4.905628195
      284    HOL_BICKH   HOL_LKSBH      70  0.184627117  0.183442546  1.560454341
      285    HOL_BICKH   HOL_LKSHH      66  0.159042134  0.144177426  1.298769679
      287    HOL_BICKH  HOL_MB253H      77  0.367288301  0.303391543  3.442555185
      291    HOL_BICKH   HOL_MIWAH      53  0.026932105  0.104871658  0.194280644
      296    HOL_BICKH   HOL_TATEH      77  0.133636892  0.326688577  1.175563790
      300    HOL_BICKH  HOL_TMB12H      77  0.325425741  0.335678517  3.000309909
      301    HOL_BICKH  HOL_TMB21H      69  0.308309538  0.249050794  2.672577261
      302    HOL_BICKH  HOL_TMB22H      77  0.335960060  0.179517522  3.109571940
      307    HOL_BICKH   HOL_TRRSH      66  0.099903053  0.211226084  0.809493917
      308    HOL_BICKH   HOL_TWMLH      77  0.330742957  0.319830826  3.055299845
      310    HOL_BICKH   HOL_WEDEH      77  0.334837187  0.220952568  3.097864025
      311    HOL_BICKH   HOL_WEDGH      64  0.327289636 -0.116183942  2.749195457
      312    HOL_BICKH   HOL_WEDWH      77  0.308287116  0.173699858  2.825190294
      313    HOL_BRBRH   HOL_AAHOH      87 -0.092025539  0.243008720 -0.857046488
      318    HOL_BRBRH   HOL_BICKH      54  0.470995986  0.250731594  3.887048085
      323    HOL_BRBRH   HOL_GKZBH     143  0.304436243  0.316285251  3.808558446
      324    HOL_BRBRH   HOL_GUSTH      54  0.556559087  0.201123572  4.876952521
      325    HOL_BRBRH   HOL_IRRBH     102  0.123024561  0.115560935  1.245845442
      326    HOL_BRBRH   HOL_K9SAH      89 -0.032851634  0.195837658 -0.308342079
      327    HOL_BRBRH   HOL_KBMBH     153 -0.047533196  0.223174924 -0.586691758
      332    HOL_BRBRH   HOL_KORHH      85  0.392176452  0.198172039  3.907376443
      335    HOL_BRBRH   HOL_LKBBH     153  0.514217918  0.411207086  7.391865616
      336    HOL_BRBRH   HOL_LKSBH     153  0.557418690  0.327587355  8.277593492
      337    HOL_BRBRH   HOL_LKSHH     153  0.540711818  0.230863880  7.924727054
      339    HOL_BRBRH  HOL_MB253H      54  0.324974883  0.109715802  2.501634983
      341    HOL_BRBRH   HOL_MBRUH     100  0.287621312  0.273093775  2.988058682
      342    HOL_BRBRH   HOL_MBUFH      55  0.378409478  0.394466702  3.004122017
      344    HOL_BRBRH   HOL_MRBRH      73  0.299089892  0.276143408  2.659605495
      346    HOL_BRBRH   HOL_PALZH      58  0.381600162  0.076475951  3.116880179
      347    HOL_BRBRH   HOL_SQUSH      57  0.238618861  0.204771374  1.838776227
      348    HOL_BRBRH   HOL_TATEH      60  0.230664609  0.189656344  1.820871338
      351    HOL_BRBRH  HOL_TMB11H      95  0.094108502  0.296739269  0.916483180
      352    HOL_BRBRH  HOL_TMB12H      54  0.127818031  0.254408087  0.938224974
      353    HOL_BRBRH  HOL_TMB21H      54  0.141560682  0.182896209  1.041061243
      354    HOL_BRBRH  HOL_TMB22H      54  0.621466404  0.184390902  5.774965560
      359    HOL_BRBRH   HOL_TRRSH     153 -0.037596570  0.314223987 -0.463849589
      360    HOL_BRBRH   HOL_TWMLH      98  0.488033063  0.189688375  5.506908557
      361    HOL_BRBRH   HOL_UNLUH      90  0.234093805  0.107941312  2.271553900
      362    HOL_BRBRH   HOL_WEDEH      64  0.274358628  0.258833452  2.264550695
      364    HOL_BRBRH   HOL_WEDWH      64  0.225918357  0.241293227  1.840761985
      368    HOL_BROIH   HOL_BENGH      69  0.489170203  0.271041933  4.624919424
      369    HOL_BROIH   HOL_BERLH     220  0.719781537  0.176768041 15.343970174
      374    HOL_BROIH   HOL_ERP1H      93  0.483247297 -0.112654333  5.294380935
      381    HOL_BROIH   HOL_KKNAH     231  0.729106542  0.309125970 16.156406698
      383    HOL_BROIH   HOL_KORBH      70  0.734831416  0.432936730  8.999587148
      397    HOL_BROIH   HOL_OB2BH     103  0.272484254  0.011041913  2.860184764
      430    HOL_DHROH   HOL_K9SAH      93 -0.026333217  0.435453467 -0.252666963
      431    HOL_DHROH   HOL_KBMBH      85  0.370625080  0.493546818  3.657298386
      435    HOL_DHROH   HOL_KORBH      86  0.079789205  0.255727290  0.737972961
      439    HOL_DHROH   HOL_LKBBH      65  0.557982768  0.539011875  5.379102857
      443    HOL_DHROH  HOL_MB253H     116 -0.084985667  0.528471099 -0.914678896
      444    HOL_DHROH  HOL_MB259H      59  0.288547531  0.451881863  2.295134768
      447    HOL_DHROH   HOL_MIWAH     110  0.568889048  0.443083941  7.221878507
      452    HOL_DHROH   HOL_TATEH     116  0.245609153  0.418843672  2.717092141
      456    HOL_DHROH  HOL_TMB12H     116  0.706576038  0.599445863 10.707725167
      460    HOL_DHROH HOL_TRMB32H      52  0.189234193  0.513346278  1.376268897
      464    HOL_DHROH   HOL_TWMLH     113  0.301798507  0.323127643  3.350146719
      466    HOL_DHROH   HOL_WEDEH     116  0.386904490  0.516880163  4.499511282
      467    HOL_DHROH   HOL_WEDGH      75  0.620845102  0.583970783  6.812711955
      468    HOL_DHROH   HOL_WEDWH     116  0.394374162  0.519431179  4.602200268
      473    HOL_ERP1H   HOL_BERLH      93  0.450376684  0.050316658  4.838345011
      476    HOL_ERP1H   HOL_BROIH      93  0.483247297 -0.112654333  5.294380935
      485    HOL_ERP1H   HOL_KKNAH      93  0.153494282 -0.025617359  1.489921700
      501    HOL_ERP1H   HOL_OB2BH      92  0.527554510  0.214297986  5.923983276
      521    HOL_GKZBH   HOL_AAHOH      77  0.137326483  0.278197844  1.208635328
      526    HOL_GKZBH   HOL_BICKH      59  0.038772914  0.445440499  0.295507924
      527    HOL_GKZBH   HOL_BRBRH     143  0.304436243  0.316285251  3.808558446
      532    HOL_GKZBH   HOL_GUSTH      59  0.056879061  0.468344028  0.433880442
      533    HOL_GKZBH   HOL_IRRBH      92  0.045835787  0.316290805  0.437705578
      534    HOL_GKZBH   HOL_K9SAH      94 -0.013513101 -0.037757006 -0.130327531
      535    HOL_GKZBH   HOL_KBMBH     148  0.004404887  0.305523062  0.053406940
      540    HOL_GKZBH   HOL_KORHH      75  0.015126348  0.539912486  0.130136657
      543    HOL_GKZBH   HOL_LKBBH     148  0.592894958  0.385617958  8.926672777
      544    HOL_GKZBH   HOL_LKSBH     148  0.595772324  0.369116446  8.993743674
      545    HOL_GKZBH   HOL_LKSHH     148  0.280937674  0.170810453  3.549125713
      547    HOL_GKZBH  HOL_MB253H      59  0.093307054  0.171147887  0.713719034
      549    HOL_GKZBH   HOL_MBRUH      90  0.307503904  0.507064623  3.048705508
      552    HOL_GKZBH   HOL_MRBRH      63  0.308367588  0.495787214  2.552478026
      556    HOL_GKZBH   HOL_TATEH      65  0.328003333  0.223500616  2.777698486
      559    HOL_GKZBH  HOL_TMB11H      85  0.000173664  0.340106128  0.001591657
      560    HOL_GKZBH  HOL_TMB12H      59  0.206204548  0.164828147  1.604898066
      561    HOL_GKZBH  HOL_TMB21H      59 -0.063652080  0.237617788 -0.485744818
      562    HOL_GKZBH  HOL_TMB22H      59 -0.109329770  0.077309696 -0.837652001
      567    HOL_GKZBH   HOL_TRRSH     148 -0.188090442  0.259036387 -2.321917665
      568    HOL_GKZBH   HOL_TWMLH     103  0.183764564  0.242532939  1.888084658
      569    HOL_GKZBH   HOL_UNLUH      80  0.086962224  0.054221366  0.775876473
      570    HOL_GKZBH   HOL_WEDEH      69  0.156149106  0.240202586  1.303629490
      572    HOL_GKZBH   HOL_WEDWH      69  0.123656717  0.218464883  1.027586074
      578    HOL_GUSTH   HOL_BICKH      77  0.391801212  0.397332816  3.712454943
      579    HOL_GUSTH   HOL_BRBRH      54  0.556559087  0.201123572  4.876952521
      583    HOL_GUSTH   HOL_GKZBH      59  0.056879061  0.468344028  0.433880442
      586    HOL_GUSTH   HOL_K9SAH      88  0.145345889  0.229675843  1.370246981
      587    HOL_GUSTH   HOL_KBMBH      88  0.245883024  0.369449586  2.366084114
      595    HOL_GUSTH   HOL_LKBBH      88  0.421581798  0.396463781  4.336452319
      596    HOL_GUSTH   HOL_LKSBH      70  0.387944916  0.277987333  3.496336630
      597    HOL_GUSTH   HOL_LKSHH      66  0.228060287  0.205141873  1.888447034
      599    HOL_GUSTH  HOL_MB253H      88  0.195674878  0.552690080  1.861111225
      603    HOL_GUSTH   HOL_MIWAH      64  0.486231851  0.211205939  4.416587185
      608    HOL_GUSTH   HOL_TATEH      88  0.310066749  0.305284742  3.042037561
      612    HOL_GUSTH  HOL_TMB12H      88  0.424427059  0.472487999  4.372123277
      613    HOL_GUSTH  HOL_TMB21H      69  0.125643831  0.308952578  1.044361703
      614    HOL_GUSTH  HOL_TMB22H      82  0.679291680  0.287488012  8.330683272
      619    HOL_GUSTH   HOL_TRRSH      66 -0.185446513  0.338579482 -1.521509137
      620    HOL_GUSTH   HOL_TWMLH      88  0.492230094  0.303859893  5.274440684
      622    HOL_GUSTH   HOL_WEDEH      88  0.181442734  0.147711923  1.720950333
      623    HOL_GUSTH   HOL_WEDGH      75  0.114871224  0.251548967  0.994744452
      624    HOL_GUSTH   HOL_WEDWH      88  0.112537983  0.078855364  1.056395260
      625    HOL_IRRBH   HOL_AAHOH     187  0.493596957  0.393506269  7.740412083
      627    HOL_IRRBH   HOL_BDN2H      60  0.581057202  0.596238067  5.483953185
      631    HOL_IRRBH   HOL_BRBRH     102  0.123024561  0.115560935  1.245845442
      635    HOL_IRRBH   HOL_GKZBH      92  0.045835787  0.316290805  0.437705578
      639    HOL_IRRBH   HOL_KBMBH     188  0.494193558  0.311285485  7.773601527
      642    HOL_IRRBH   HOL_KMBQH     122  0.146320981  0.216230639  1.627042373
      644    HOL_IRRBH   HOL_KORHH      85  0.365580108  0.304804599  3.599773806
      646    HOL_IRRBH   HOL_LATEH     103  0.515759161  0.196970711  6.079967095
      647    HOL_IRRBH   HOL_LKBBH     102 -0.169554109  0.246260872 -1.729032576
      648    HOL_IRRBH   HOL_LKSBH     133  0.321052266  0.381384769  3.894794371
      649    HOL_IRRBH   HOL_LKSHH     149  0.229178936  0.196534990  2.864317891
      653    HOL_IRRBH   HOL_MBRUH     100  0.037921169  0.242702611  0.377582455
      654    HOL_IRRBH   HOL_MBUFH     124  0.494744518  0.407919753  6.313854145
      656    HOL_IRRBH   HOL_MRBRH     138  0.245032881  0.351267297  2.958218315
      658    HOL_IRRBH   HOL_PALZH     158  0.589586869  0.408641950  9.146287992
      659    HOL_IRRBH   HOL_SQUSH     157  0.299853050  0.200795430  3.925807862
      663    HOL_IRRBH  HOL_TMB11H      95  0.738107843  0.490500528 10.606794165
      669    HOL_IRRBH   HOL_TRPBH      68  0.331075012  0.425255566  2.871929864
      670    HOL_IRRBH   HOL_TRRBH     101  0.112710306  0.501053287  1.134331145
      671    HOL_IRRBH   HOL_TRRSH     202  0.397034405  0.303430429  6.133047854
      673    HOL_IRRBH   HOL_UNLUH     190  0.141304936  0.152727979  1.962311295
      682    HOL_K9SAH   HOL_BICKH      77 -0.079101900  0.095084116 -0.691761992
      683    HOL_K9SAH   HOL_BRBRH      89 -0.032851634  0.195837658 -0.308342079
      685    HOL_K9SAH   HOL_DHROH      93 -0.026333217  0.435453467 -0.252666963
      687    HOL_K9SAH   HOL_GKZBH      94 -0.013513101 -0.037757006 -0.130327531
      688    HOL_K9SAH   HOL_GUSTH      88  0.145345889  0.229675843  1.370246981
      691    HOL_K9SAH   HOL_KBMBH     163  0.273394303  0.333400041  3.617563123
      695    HOL_K9SAH   HOL_KORBH      63  0.500830859  0.457236393  4.556141312
      699    HOL_K9SAH   HOL_LKBBH     143  0.287785970  0.242627666  3.580854565
      700    HOL_K9SAH   HOL_LKSBH     105  0.147632386  0.345038961  1.522241086
      701    HOL_K9SAH   HOL_LKSHH     101  0.138410746  0.123241013  1.397559087
      703    HOL_K9SAH  HOL_MB253H     136  0.379300156  0.463258821  4.762990275
      707    HOL_K9SAH   HOL_MIWAH     112  0.243103119  0.350195331  2.640462989
      712    HOL_K9SAH   HOL_TATEH     142  0.253814714  0.368958631  3.115920222
      716    HOL_K9SAH  HOL_TMB12H     136  0.195051113  0.532215394  2.310669995
      717    HOL_K9SAH  HOL_TMB21H      69  0.225576266  0.360786854  1.909362385
      718    HOL_K9SAH  HOL_TMB22H      82  0.285254051  0.510479488  2.678576088
      723    HOL_K9SAH   HOL_TRRSH     101  0.353085800  0.463439523  3.773933482
      724    HOL_K9SAH   HOL_TWMLH     171  0.158939070  0.428712893  2.098993510
      726    HOL_K9SAH   HOL_WEDEH     146  0.216597331  0.403352862  2.671598235
      727    HOL_K9SAH   HOL_WEDGH     105  0.002461062  0.347195026  0.025098086
      728    HOL_K9SAH   HOL_WEDWH     146  0.194764476  0.380558863  2.391063634
      729    HOL_KBMBH   HOL_AAHOH     173  0.295691657  0.414522592  4.059485995
      734    HOL_KBMBH   HOL_BICKH      77  0.205125340  0.295696702  1.827093086
      735    HOL_KBMBH   HOL_BRBRH     153 -0.047533196  0.223174924 -0.586691758
      737    HOL_KBMBH   HOL_DHROH      85  0.370625080  0.493546818  3.657298386
      739    HOL_KBMBH   HOL_GKZBH     148  0.004404887  0.305523062  0.053406940
      740    HOL_KBMBH   HOL_GUSTH      88  0.245883024  0.369449586  2.366084114
      741    HOL_KBMBH   HOL_IRRBH     188  0.494193558  0.311285485  7.773601527
      742    HOL_KBMBH   HOL_K9SAH     163  0.273394303  0.333400041  3.617563123
      746    HOL_KBMBH   HOL_KMBQH     114  0.189622283  0.376163878  2.052959125
      747    HOL_KBMBH   HOL_KORBH      55  0.364831685  0.324685610  2.879422987
      748    HOL_KBMBH   HOL_KORHH      85  0.534915200  0.425992683  5.802515582
      750    HOL_KBMBH   HOL_LATEH      89  0.567261269  0.193522570  6.461612115
      751    HOL_KBMBH   HOL_LKBBH     207  0.048507830  0.563968508  0.697038886
      752    HOL_KBMBH   HOL_LKSBH     200  0.205888404  0.515339850  2.968001365
      753    HOL_KBMBH   HOL_LKSHH     212  0.192053825  0.465966207  2.842660812
      755    HOL_KBMBH  HOL_MB253H     128  0.158392623  0.455974350  1.807815698
      757    HOL_KBMBH   HOL_MBRUH     100  0.534248981  0.593245634  6.288346597
      758    HOL_KBMBH   HOL_MBUFH     124  0.723346282  0.636849856 11.618345264
      759    HOL_KBMBH   HOL_MIWAH     104  0.321364232  0.354941977  3.444185260
      760    HOL_KBMBH   HOL_MRBRH     138  0.604376406  0.574695819  8.879194304
      762    HOL_KBMBH   HOL_PALZH     144  0.683684975  0.487853519 11.202984249
      763    HOL_KBMBH   HOL_SQUSH     143  0.482221485  0.406060391  6.559370513
      764    HOL_KBMBH   HOL_TATEH     134  0.263513287  0.416086104  3.150329454
      767    HOL_KBMBH  HOL_TMB11H      95  0.179775977  0.369039404  1.771860672
      768    HOL_KBMBH  HOL_TMB12H     128  0.342397513  0.599927998  4.106862565
      769    HOL_KBMBH  HOL_TMB21H      69  0.472208117  0.657292845  4.417453099
      770    HOL_KBMBH  HOL_TMB22H      82  0.310896703  0.500502472  2.943962182
      773    HOL_KBMBH   HOL_TRPBH      68  0.410963063  0.372995637  3.689870330
      774    HOL_KBMBH   HOL_TRRBH      87  0.107651532  0.669123266  1.004154697
      775    HOL_KBMBH   HOL_TRRSH     251  0.389238024  0.574039069  6.681299456
      776    HOL_KBMBH   HOL_TWMLH     172  0.015844598  0.232887482  0.207221017
      777    HOL_KBMBH   HOL_UNLUH     176  0.360137445  0.271504589  5.106843594
      778    HOL_KBMBH   HOL_WEDEH     138  0.452358388  0.500901295  5.936873740
      779    HOL_KBMBH   HOL_WEDGH     105  0.186686657  0.322246064  1.937907171
      780    HOL_KBMBH   HOL_WEDWH     138  0.430539452  0.438924058  5.583306851
      799    HOL_KDGBH   HOL_KORBH      83  0.215007343  0.478031417  1.993599753
      816    HOL_KDGBH   HOL_TATEH      55  0.354746879  0.492059867  2.788183335
      817    HOL_KDGBH   HOL_TATTH      63 -0.087559381  0.126638336 -0.692101411
      824    HOL_KDGBH HOL_TRMB32H      83  0.174967773  0.450074872  1.609224207
      836    HOL_KKNAH   HOL_BENGH      69  0.282119113  0.225799744  2.424915353
      837    HOL_KKNAH   HOL_BERLH     228  0.648796646  0.304733827 12.845725876
      840    HOL_KKNAH   HOL_BROIH     231  0.729106542  0.309125970 16.156406698
      842    HOL_KKNAH   HOL_ERP1H      93  0.153494282 -0.025617359  1.489921700
      851    HOL_KKNAH   HOL_KORBH      64  0.345782321  0.440776458  2.924990856
      865    HOL_KKNAH   HOL_OB2BH     111  0.306094959  0.042447049  3.372213963
      885    HOL_KMBQH   HOL_AAHOH     122  0.321154212  0.591621699  3.730301947
      887    HOL_KMBQH   HOL_BDN2H      54  0.138911744  0.213496197  1.021193475
      897    HOL_KMBQH   HOL_IRRBH     122  0.146320981  0.216230639  1.627042373
      899    HOL_KMBQH   HOL_KBMBH     114  0.189622283  0.376163878  2.052959125
      906    HOL_KMBQH   HOL_LATEH      97  0.024111124  0.131747119  0.236308507
      908    HOL_KMBQH   HOL_LKSBH      59  0.054764538  0.377749389  0.417701143
      909    HOL_KMBQH   HOL_LKSHH      75  0.441272425  0.429744097  4.230089507
      914    HOL_KMBQH   HOL_MBUFH      97  0.250720480  0.497686600  2.537601166
      916    HOL_KMBQH   HOL_MRBRH      93 -0.033149179  0.435916706 -0.318130597
      918    HOL_KMBQH   HOL_PALZH     122  0.213031530  0.332566165  2.398401357
      919    HOL_KMBQH   HOL_SQUSH     122  0.112188530  0.250932006  1.241914109
      929    HOL_KMBQH   HOL_TRPBH      68 -0.026148714  0.388887146 -0.214109657
      930    HOL_KMBQH   HOL_TRRBH      95  0.269473726  0.309999844  2.713004881
      931    HOL_KMBQH   HOL_TRRSH     122  0.128799278  0.389133386  1.428692088
      933    HOL_KMBQH   HOL_UNLUH     122  0.217656631  0.180615553  2.453033421
      940    HOL_KORBH   HOL_BENGH      63  0.665527356  0.315735142  7.021106644
      941    HOL_KORBH   HOL_BERLH      53  0.606828824  0.179090988  5.505442498
      944    HOL_KORBH   HOL_BROIH      70  0.734831416  0.432936730  8.999587148
      945    HOL_KORBH   HOL_DHROH      86  0.079789205  0.255727290  0.737972961
      950    HOL_KORBH   HOL_K9SAH      63  0.500830859  0.457236393  4.556141312
      951    HOL_KORBH   HOL_KBMBH      55  0.364831685  0.324685610  2.879422987
      952    HOL_KORBH   HOL_KDGBH      83  0.215007343  0.478031417  1.993599753
      953    HOL_KORBH   HOL_KKNAH      64  0.345782321  0.440776458  2.924990856
      963    HOL_KORBH  HOL_MB253H     105  0.592835617  0.610646450  7.507244970
      964    HOL_KORBH  HOL_MB259H      84  0.490329050  0.413909575  5.125552038
      967    HOL_KORBH   HOL_MIWAH      80  0.101212307  0.284768032  0.904238057
      972    HOL_KORBH   HOL_TATEH     138  0.440587868  0.510714524  5.744563064
      973    HOL_KORBH   HOL_TATTH      85  0.046435228  0.042769777  0.426045466
      976    HOL_KORBH  HOL_TMB12H      97  0.060272067  0.476987801  0.591618811
      980    HOL_KORBH HOL_TRMB32H     133  0.454742390  0.496032610  5.866221945
      984    HOL_KORBH   HOL_TWMLH      83  0.171363922  0.387056412  1.575064993
      986    HOL_KORBH   HOL_WEDEH     124  0.253383305  0.405401632  2.904957292
      988    HOL_KORBH   HOL_WEDWH     124  0.225610729  0.415516720  2.568362760
      989    HOL_KORHH   HOL_AAHOH      85  0.050560394  0.288676503  0.463987099
      995    HOL_KORHH   HOL_BRBRH      85  0.392176452  0.198172039  3.907376443
      999    HOL_KORHH   HOL_GKZBH      75  0.015126348  0.539912486  0.130136657
      1001   HOL_KORHH   HOL_IRRBH      85  0.365580108  0.304804599  3.599773806
      1003   HOL_KORHH   HOL_KBMBH      85  0.534915200  0.425992683  5.802515582
      1011   HOL_KORHH   HOL_LKBBH      85  0.176961734  0.577187570  1.647888495
      1012   HOL_KORHH   HOL_LKSBH      85  0.293937953  0.546311524  2.818494220
      1013   HOL_KORHH   HOL_LKSHH      85  0.270758454  0.313355332  2.577831128
      1017   HOL_KORHH   HOL_MBRUH      85  0.310680627  0.536081723  2.995678023
      1018   HOL_KORHH   HOL_MBUFH      55  0.284118102  0.084468501  2.177572438
      1020   HOL_KORHH   HOL_MRBRH      73  0.403900225  0.487490594  3.746387909
      1022   HOL_KORHH   HOL_PALZH      58  0.436837722  0.200495727  3.666375331
      1023   HOL_KORHH   HOL_SQUSH      57  0.477601912  0.331567296  4.067996388
      1027   HOL_KORHH  HOL_TMB11H      85  0.447164075  0.480030045  4.581941423
      1035   HOL_KORHH   HOL_TRRSH      85  0.642772074  0.480783259  7.690158418
      1037   HOL_KORHH   HOL_UNLUH      85  0.120928149 -0.087497523  1.116518626
      1043   HOL_LAGEH   HOL_BDN2H      58  0.433764001  0.341440542  3.634572700
      1062   HOL_LAGEH   HOL_LATEH      58  0.045105122  0.117701098  0.340883142
      1066   HOL_LAGEH   HOL_MANCH      58  0.147704300  0.265611390  1.127510026
      1078   HOL_LAGEH   HOL_TITEH      58  0.181761277  0.392027733  1.395513050
      1086   HOL_LAGEH   HOL_TRRBH      58  0.422119379  0.394990644  3.515488051
      1093   HOL_LATEH   HOL_AAHOH     103  0.298520123  0.201482556  3.158942695
      1095   HOL_LATEH   HOL_BDN2H     326  0.475777446  0.081137615  9.751630705
      1105   HOL_LATEH   HOL_IRRBH     103  0.515759161  0.196970711  6.079967095
      1107   HOL_LATEH   HOL_KBMBH      89  0.567261269  0.193522570  6.461612115
      1110   HOL_LATEH   HOL_KMBQH      97  0.024111124  0.131747119  0.236308507
      1113   HOL_LATEH   HOL_LAGEH      58  0.045105122  0.117701098  0.340883142
      1117   HOL_LATEH   HOL_LKSHH      50 -0.230459549           NA -1.657842814
      1118   HOL_LATEH   HOL_MANCH     226 -0.059788543 -0.002400243 -0.898435381
      1122   HOL_LATEH   HOL_MBUFH      72  0.171757641  0.133946819  1.469087374
      1124   HOL_LATEH   HOL_MRBRH      68  0.441573630  0.083108235  4.028460944
      1126   HOL_LATEH   HOL_PALZH     189  0.431646461  0.033203004  6.561149486
      1127   HOL_LATEH   HOL_SQUSH     103  0.257036312  0.104705526  2.686190824
      1130   HOL_LATEH   HOL_TITEH      84  0.097782027  0.008943228  0.895126238
      1137   HOL_LATEH   HOL_TRPBH      68  0.259949997 -0.011459399  2.203535398
      1138   HOL_LATEH   HOL_TRRBH     317  0.019928936  0.061802157  0.354334887
      1139   HOL_LATEH   HOL_TRRSH     103  0.239689088  0.032238120  2.493425221
      1141   HOL_LATEH   HOL_UNLUH     134 -0.033085444 -0.025515608 -0.381768966
      1145   HOL_LKBBH   HOL_AAHOH      87  0.024049799  0.327189504  0.223093191
      1150   HOL_LKBBH   HOL_BICKH      77  0.490403004  0.337521326  4.905628195
      1151   HOL_LKBBH   HOL_BRBRH     153  0.514217918  0.411207086  7.391865616
      1153   HOL_LKBBH   HOL_DHROH      65  0.557982768  0.539011875  5.379102857
      1155   HOL_LKBBH   HOL_GKZBH     148  0.592894958  0.385617958  8.926672777
      1156   HOL_LKBBH   HOL_GUSTH      88  0.421581798  0.396463781  4.336452319
      1157   HOL_LKBBH   HOL_IRRBH     102 -0.169554109  0.246260872 -1.729032576
      1158   HOL_LKBBH   HOL_K9SAH     143  0.287785970  0.242627666  3.580854565
      1159   HOL_LKBBH   HOL_KBMBH     207  0.048507830  0.563968508  0.697038886
      1164   HOL_LKBBH   HOL_KORHH      85  0.176961734  0.577187570  1.647888495
      1168   HOL_LKBBH   HOL_LKSBH     169  0.653855370  0.658100556 11.201050942
      1169   HOL_LKBBH   HOL_LKSHH     165  0.342351849  0.538476927  4.666213626
      1171   HOL_LKBBH  HOL_MB253H     108  0.154307891  0.428379162  1.615522662
      1173   HOL_LKBBH   HOL_MBRUH     100  0.649670541  0.682432783  8.503032374
      1174   HOL_LKBBH   HOL_MBUFH      55  0.689133115  0.585865836  6.988449497
      1175   HOL_LKBBH   HOL_MIWAH      84  0.427418323  0.423513508  4.307227640
      1176   HOL_LKBBH   HOL_MRBRH      73  0.686515436  0.643945809  8.011490353
      1178   HOL_LKBBH   HOL_PALZH      58  0.334509555  0.362400744  2.679872913
      1179   HOL_LKBBH   HOL_SQUSH      57  0.351425985  0.415145689  2.809001552
      1180   HOL_LKBBH   HOL_TATEH     114  0.403610102  0.461347418  4.689352372
      1183   HOL_LKBBH  HOL_TMB11H      95 -0.126528737  0.456570740 -1.236680898
      1184   HOL_LKBBH  HOL_TMB12H     108  0.544759440  0.603884425  6.719636026
      1185   HOL_LKBBH  HOL_TMB21H      69  0.356994329  0.436806035  3.151514830
      1186   HOL_LKBBH  HOL_TMB22H      82  0.372160586  0.421610342  3.608661344
      1191   HOL_LKBBH   HOL_TRRSH     165 -0.089227628  0.513661005 -1.147247245
      1192   HOL_LKBBH   HOL_TWMLH     152  0.566824381  0.312159966  8.454634421
      1193   HOL_LKBBH   HOL_UNLUH      90  0.114272999  0.144795007  1.085157762
      1194   HOL_LKBBH   HOL_WEDEH     118  0.347653246  0.485822075  4.010614194
      1195   HOL_LKBBH   HOL_WEDGH      95  0.341031432  0.407961750  3.517276474
      1196   HOL_LKBBH   HOL_WEDWH     118  0.265138039  0.467384322  2.974357247
      1197   HOL_LKSBH   HOL_AAHOH     118  0.302268769  0.498699727  3.429981790
      1202   HOL_LKSBH   HOL_BICKH      70  0.184627117  0.183442546  1.560454341
      1203   HOL_LKSBH   HOL_BRBRH     153  0.557418690  0.327587355  8.277593492
      1207   HOL_LKSBH   HOL_GKZBH     148  0.595772324  0.369116446  8.993743674
      1208   HOL_LKSBH   HOL_GUSTH      70  0.387944916  0.277987333  3.496336630
      1209   HOL_LKSBH   HOL_IRRBH     133  0.321052266  0.381384769  3.894794371
      1210   HOL_LKSBH   HOL_K9SAH     105  0.147632386  0.345038961  1.522241086
      1211   HOL_LKSBH   HOL_KBMBH     200  0.205888404  0.515339850  2.968001365
      1214   HOL_LKSBH   HOL_KMBQH      59  0.054764538  0.377749389  0.417701143
      1216   HOL_LKSBH   HOL_KORHH      85  0.293937953  0.546311524  2.818494220
      1219   HOL_LKSBH   HOL_LKBBH     169  0.653855370  0.658100556 11.201050942
      1221   HOL_LKSBH   HOL_LKSHH     196  0.541084026  0.513610375  8.984672928
      1223   HOL_LKSBH  HOL_MB253H      70 -0.141961669  0.387233649 -1.191287359
      1225   HOL_LKSBH   HOL_MBRUH     100  0.319163518  0.547674147  3.350889564
      1226   HOL_LKSBH   HOL_MBUFH      86  0.162226127  0.397582782  1.515728926
      1228   HOL_LKSBH   HOL_MRBRH     104  0.411365673  0.630874957  4.580407245
      1230   HOL_LKSBH   HOL_PALZH      89  0.114105772  0.315740262  1.077444236
      1231   HOL_LKSBH   HOL_SQUSH      88  0.103289823  0.327399632  0.968604101
      1232   HOL_LKSBH   HOL_TATEH      76  0.395525047  0.378277671  3.729465972
      1235   HOL_LKSBH  HOL_TMB11H      95  0.223933278  0.452640907  2.227686956
      1236   HOL_LKSBH  HOL_TMB12H      70  0.225414032  0.489700927  1.921893219
      1237   HOL_LKSBH  HOL_TMB21H      69  0.223427090  0.528989194  1.890210280
      1238   HOL_LKSBH  HOL_TMB22H      70  0.492548432  0.334379418  4.701235105
      1243   HOL_LKSBH   HOL_TRRSH     196 -0.053779651  0.461660810 -0.752080348
      1244   HOL_LKSBH   HOL_TWMLH     114  0.509604090  0.371210304  6.296035594
      1245   HOL_LKSBH   HOL_UNLUH     121  0.114516712  0.150898944  1.262775114
      1246   HOL_LKSBH   HOL_WEDEH      80  0.264211526  0.426866051  2.434887735
      1247   HOL_LKSBH   HOL_WEDGH      57  0.037667612  0.173995168  0.282078779
      1248   HOL_LKSBH   HOL_WEDWH      80  0.168797282  0.389698539  1.522144639
      1249   HOL_LKSHH   HOL_AAHOH     134  0.371330048  0.244677604  4.612151513
      1254   HOL_LKSHH   HOL_BICKH      66  0.159042134  0.144177426  1.298769679
      1255   HOL_LKSHH   HOL_BRBRH     153  0.540711818  0.230863880  7.924727054
      1259   HOL_LKSHH   HOL_GKZBH     148  0.280937674  0.170810453  3.549125713
      1260   HOL_LKSHH   HOL_GUSTH      66  0.228060287  0.205141873  1.888447034
      1261   HOL_LKSHH   HOL_IRRBH     149  0.229178936  0.196534990  2.864317891
      1262   HOL_LKSHH   HOL_K9SAH     101  0.138410746  0.123241013  1.397559087
      1263   HOL_LKSHH   HOL_KBMBH     212  0.192053825  0.465966207  2.842660812
      1266   HOL_LKSHH   HOL_KMBQH      75  0.441272425  0.429744097  4.230089507
      1268   HOL_LKSHH   HOL_KORHH      85  0.270758454  0.313355332  2.577831128
      1270   HOL_LKSHH   HOL_LATEH      50 -0.230459549           NA -1.657842814
      1271   HOL_LKSHH   HOL_LKBBH     165  0.342351849  0.538476927  4.666213626
      1272   HOL_LKSHH   HOL_LKSBH     196  0.541084026  0.513610375  8.984672928
      1275   HOL_LKSHH  HOL_MB253H      66  0.214533319  0.170299957  1.770854299
      1277   HOL_LKSHH   HOL_MBRUH     100 -0.008618018  0.453316447 -0.085751380
      1278   HOL_LKSHH   HOL_MBUFH     102  0.475212621  0.321238812  5.427872685
      1280   HOL_LKSHH   HOL_MRBRH     120  0.003288783  0.407830073  0.035876586
      1282   HOL_LKSHH   HOL_PALZH     105  0.035599017  0.308005630  0.363270418
      1283   HOL_LKSHH   HOL_SQUSH     104  0.260830951  0.258130680  2.742062947
      1284   HOL_LKSHH   HOL_TATEH      72  0.241429031  0.408594403  2.096329799
      1287   HOL_LKSHH  HOL_TMB11H      95  0.345407296  0.281689900  3.568477514
      1288   HOL_LKSHH  HOL_TMB12H      66  0.402407134  0.466653142  3.543909245
      1289   HOL_LKSHH  HOL_TMB21H      66  0.377395037  0.500255379  3.285619874
      1290   HOL_LKSHH  HOL_TMB22H      66  0.366729580  0.295082417  3.178093877
      1295   HOL_LKSHH   HOL_TRRSH     212  0.088249244  0.415316109  1.286915306
      1296   HOL_LKSHH   HOL_TWMLH     110  0.420838212  0.200631160  4.843464834
      1297   HOL_LKSHH   HOL_UNLUH     137  0.320611330  0.141760093  3.947313870
      1298   HOL_LKSHH   HOL_WEDEH      76  0.218206049  0.284314989  1.936381342
      1299   HOL_LKSHH   HOL_WEDGH      53  0.170916909  0.297401147  1.250905881
      1300   HOL_LKSHH   HOL_WEDWH      76  0.196719235  0.282650191  1.737591326
      1303   HOL_MANCH   HOL_BDN2H     226  0.121782161  0.215989030  1.840431010
      1321   HOL_MANCH   HOL_LAGEH      58  0.147704300  0.265611390  1.127510026
      1322   HOL_MANCH   HOL_LATEH     226 -0.059788543 -0.002400243 -0.898435381
      1334   HOL_MANCH   HOL_PALZH      87  0.316267215  0.430411956  3.091634646
      1338   HOL_MANCH   HOL_TITEH      84  0.070299770  0.175630806  0.642049873
      1346   HOL_MANCH   HOL_TRRBH     217  0.191327279  0.336500430  2.864849627
      1358  HOL_MB253H   HOL_BICKH      77  0.367288301  0.303391543  3.442555185
      1359  HOL_MB253H   HOL_BRBRH      54  0.324974883  0.109715802  2.501634983
      1361  HOL_MB253H   HOL_DHROH     116 -0.084985667  0.528471099 -0.914678896
      1363  HOL_MB253H   HOL_GKZBH      59  0.093307054  0.171147887  0.713719034
      1364  HOL_MB253H   HOL_GUSTH      88  0.195674878  0.552690080  1.861111225
      1366  HOL_MB253H   HOL_K9SAH     136  0.379300156  0.463258821  4.762990275
      1367  HOL_MB253H   HOL_KBMBH     128  0.158392623  0.455974350  1.807815698
      1371  HOL_MB253H   HOL_KORBH     105  0.592835617  0.610646450  7.507244970
      1375  HOL_MB253H   HOL_LKBBH     108  0.154307891  0.428379162  1.615522662
      1376  HOL_MB253H   HOL_LKSBH      70 -0.141961669  0.387233649 -1.191287359
      1377  HOL_MB253H   HOL_LKSHH      66  0.214533319  0.170299957  1.770854299
      1380  HOL_MB253H  HOL_MB259H      78  0.159776650  0.469755979  1.420280485
      1383  HOL_MB253H   HOL_MIWAH     129 -0.322827810  0.332488757 -3.858999383
      1388  HOL_MB253H   HOL_TATEH     178  0.106930926  0.551991160  1.430827155
      1392  HOL_MB253H  HOL_TMB12H     170 -0.233782014  0.649386617 -3.125784694
      1393  HOL_MB253H  HOL_TMB21H      69  0.403444986  0.545565464  3.635932666
      1394  HOL_MB253H  HOL_TMB22H      82  0.136354296  0.416613457  1.238758497
      1396  HOL_MB253H HOL_TRMB32H      71  0.517839579  0.675646409  5.064487993
      1399  HOL_MB253H   HOL_TRRSH      66  0.643374022  0.556914738  6.775564788
      1400  HOL_MB253H   HOL_TWMLH     156 -0.146541730  0.365020421 -1.844340427
      1402  HOL_MB253H   HOL_WEDEH     178  0.459390150  0.530474537  6.880826860
      1403  HOL_MB253H   HOL_WEDGH     105  0.270299737  0.374831539  2.863102772
      1404  HOL_MB253H   HOL_WEDWH     178  0.475733073  0.497914415  7.195646867
      1413  HOL_MB259H   HOL_DHROH      59  0.288547531  0.451881863  2.295134768
      1423  HOL_MB259H   HOL_KORBH      84  0.490329050  0.413909575  5.125552038
      1431  HOL_MB259H  HOL_MB253H      78  0.159776650  0.469755979  1.420280485
      1435  HOL_MB259H   HOL_MIWAH      53  0.590943015  0.509241731  5.282360742
      1440  HOL_MB259H   HOL_TATEH      84  0.183574774  0.397481879  1.701359114
      1441  HOL_MB259H   HOL_TATTH      50  0.263201374           NA  1.909745491
      1444  HOL_MB259H  HOL_TMB12H      70  0.270162719  0.572080219  2.330812081
      1448  HOL_MB259H HOL_TRMB32H      77  0.529496800  0.459110314  5.441448946
      1452  HOL_MB259H   HOL_TWMLH      56  0.024214611  0.517503480  0.179633036
      1454  HOL_MB259H   HOL_WEDEH      84  0.151884006  0.569579263  1.399971159
      1456  HOL_MB259H   HOL_WEDWH      84  0.162768833  0.557212425  1.502937465
      1457   HOL_MBRUH   HOL_AAHOH      87  0.065309029  0.459845937  0.606946798
      1463   HOL_MBRUH   HOL_BRBRH     100  0.287621312  0.273093775  2.988058682
      1467   HOL_MBRUH   HOL_GKZBH      90  0.307503904  0.507064623  3.048705508
      1469   HOL_MBRUH   HOL_IRRBH     100  0.037921169  0.242702611  0.377582455
      1471   HOL_MBRUH   HOL_KBMBH     100  0.534248981  0.593245634  6.288346597
      1476   HOL_MBRUH   HOL_KORHH      85  0.310680627  0.536081723  2.995678023
      1479   HOL_MBRUH   HOL_LKBBH     100  0.649670541  0.682432783  8.503032374
      1480   HOL_MBRUH   HOL_LKSBH     100  0.319163518  0.547674147  3.350889564
      1481   HOL_MBRUH   HOL_LKSHH     100 -0.008618018  0.453316447 -0.085751380
      1486   HOL_MBRUH   HOL_MBUFH      55  0.640299285  0.567773194  6.125586808
      1488   HOL_MBRUH   HOL_MRBRH      73  0.775861707  0.801452796 10.434892136
      1490   HOL_MBRUH   HOL_PALZH      58  0.506117270  0.368504172  4.430444186
      1491   HOL_MBRUH   HOL_SQUSH      57  0.391808284  0.458484738  3.186820992
      1495   HOL_MBRUH  HOL_TMB11H      95  0.124080604  0.528106736  1.212375148
      1503   HOL_MBRUH   HOL_TRRSH     100  0.460348649  0.584573346  5.159641879
      1505   HOL_MBRUH   HOL_UNLUH      90  0.176705007  0.138971604  1.693683748
      1509   HOL_MBUFH   HOL_AAHOH     124  0.449018896  0.491842675  5.573291986
      1515   HOL_MBUFH   HOL_BRBRH      55  0.378409478  0.394466702  3.004122017
      1521   HOL_MBUFH   HOL_IRRBH     124  0.494744518  0.407919753  6.313854145
      1523   HOL_MBUFH   HOL_KBMBH     124  0.723346282  0.636849856 11.618345264
      1526   HOL_MBUFH   HOL_KMBQH      97  0.250720480  0.497686600  2.537601166
      1528   HOL_MBUFH   HOL_KORHH      55  0.284118102  0.084468501  2.177572438
      1530   HOL_MBUFH   HOL_LATEH      72  0.171757641  0.133946819  1.469087374
      1531   HOL_MBUFH   HOL_LKBBH      55  0.689133115  0.585865836  6.988449497
      1532   HOL_MBUFH   HOL_LKSBH      86  0.162226127  0.397582782  1.515728926
      1533   HOL_MBUFH   HOL_LKSHH     102  0.475212621  0.321238812  5.427872685
      1537   HOL_MBUFH   HOL_MBRUH      55  0.640299285  0.567773194  6.125586808
      1540   HOL_MBUFH   HOL_MRBRH     120  0.646291133  0.624179143  9.239008882
      1542   HOL_MBUFH   HOL_PALZH     124  0.608691700  0.714996995  8.508519426
      1543   HOL_MBUFH   HOL_SQUSH     124  0.451006541  0.510205405  5.604245163
      1547   HOL_MBUFH  HOL_TMB11H      55  0.097614000  0.260539250  0.720755553
      1553   HOL_MBUFH   HOL_TRPBH      64  0.616201031  0.552756931  6.210021493
      1554   HOL_MBUFH   HOL_TRRBH      70  0.383379749  0.716668333  3.448054449
      1555   HOL_MBUFH   HOL_TRRSH     124  0.446763833  0.670593303  5.538299791
      1557   HOL_MBUFH   HOL_UNLUH     124  0.305811681  0.240252770  3.562277112
      1566   HOL_MIWAH   HOL_BICKH      53  0.026932105  0.104871658  0.194280644
      1569   HOL_MIWAH   HOL_DHROH     110  0.568889048  0.443083941  7.221878507
      1572   HOL_MIWAH   HOL_GUSTH      64  0.486231851  0.211205939  4.416587185
      1574   HOL_MIWAH   HOL_K9SAH     112  0.243103119  0.350195331  2.640462989
      1575   HOL_MIWAH   HOL_KBMBH     104  0.321364232  0.354941977  3.444185260
      1579   HOL_MIWAH   HOL_KORBH      80  0.101212307  0.284768032  0.904238057
      1583   HOL_MIWAH   HOL_LKBBH      84  0.427418323  0.423513508  4.307227640
      1587   HOL_MIWAH  HOL_MB253H     129 -0.322827810  0.332488757 -3.858999383
      1588   HOL_MIWAH  HOL_MB259H      53  0.590943015  0.509241731  5.282360742
      1596   HOL_MIWAH   HOL_TATEH     129  0.412145116  0.320113481  5.117765865
      1600   HOL_MIWAH  HOL_TMB12H     129  0.708490105  0.429404283 11.358105284
      1602   HOL_MIWAH  HOL_TMB22H      58  0.378996713  0.229551518  3.092034329
      1608   HOL_MIWAH   HOL_TWMLH     129  0.281844726  0.221487629  3.323441277
      1610   HOL_MIWAH   HOL_WEDEH     129  0.070142752  0.495090767  0.795534074
      1611   HOL_MIWAH   HOL_WEDGH      94  0.016502954  0.460010471  0.159170400
      1612   HOL_MIWAH   HOL_WEDWH     129  0.030091643  0.477594560  0.340602321
      1613   HOL_MRBRH   HOL_AAHOH     138  0.303797212  0.559263260  3.732253762
      1619   HOL_MRBRH   HOL_BRBRH      73  0.299089892  0.276143408  2.659605495
      1623   HOL_MRBRH   HOL_GKZBH      63  0.308367588  0.495787214  2.552478026
      1625   HOL_MRBRH   HOL_IRRBH     138  0.245032881  0.351267297  2.958218315
      1627   HOL_MRBRH   HOL_KBMBH     138  0.604376406  0.574695819  8.879194304
      1630   HOL_MRBRH   HOL_KMBQH      93 -0.033149179  0.435916706 -0.318130597
      1632   HOL_MRBRH   HOL_KORHH      73  0.403900225  0.487490594  3.746387909
      1634   HOL_MRBRH   HOL_LATEH      68  0.441573630  0.083108235  4.028460944
      1635   HOL_MRBRH   HOL_LKBBH      73  0.686515436  0.643945809  8.011490353
      1636   HOL_MRBRH   HOL_LKSBH     104  0.411365673  0.630874957  4.580407245
      1637   HOL_MRBRH   HOL_LKSHH     120  0.003288783  0.407830073  0.035876586
      1641   HOL_MRBRH   HOL_MBRUH      73  0.775861707  0.801452796 10.434892136
      1642   HOL_MRBRH   HOL_MBUFH     120  0.646291133  0.624179143  9.239008882
      1646   HOL_MRBRH   HOL_PALZH     123  0.539047700  0.536001850  7.068920215
      1647   HOL_MRBRH   HOL_SQUSH     122  0.406418426  0.443851725  4.892925405
      1651   HOL_MRBRH  HOL_TMB11H      73  0.095326145  0.547150742  0.812569529
      1657   HOL_MRBRH   HOL_TRPBH      60  0.694007691  0.544136181  7.404186431
      1658   HOL_MRBRH   HOL_TRRBH      66  0.153066164  0.733701800  1.248774495
      1659   HOL_MRBRH   HOL_TRRSH     138  0.377208429  0.624626688  4.767277942
      1661   HOL_MRBRH   HOL_UNLUH     138 -0.110182054  0.109825237 -1.297548098
      1669   HOL_OB2BH   HOL_BERLH     150  0.491688025  0.148084800  6.892528861
      1672   HOL_OB2BH   HOL_BROIH     103  0.272484254  0.011041913  2.860184764
      1674   HOL_OB2BH   HOL_ERP1H      92  0.527554510  0.214297986  5.923983276
      1681   HOL_OB2BH   HOL_KKNAH     111  0.306094959  0.042447049  3.372213963
      1717   HOL_PALZH   HOL_AAHOH     158  0.306343579  0.421020482  4.032345115
      1719   HOL_PALZH   HOL_BDN2H     146  0.127156008  0.409393249  1.543691654
      1723   HOL_PALZH   HOL_BRBRH      58  0.381600162  0.076475951  3.116880179
      1729   HOL_PALZH   HOL_IRRBH     158  0.589586869  0.408641950  9.146287992
      1731   HOL_PALZH   HOL_KBMBH     144  0.683684975  0.487853519 11.202984249
      1734   HOL_PALZH   HOL_KMBQH     122  0.213031530  0.332566165  2.398401357
      1736   HOL_PALZH   HOL_KORHH      58  0.436837722  0.200495727  3.666375331
      1738   HOL_PALZH   HOL_LATEH     189  0.431646461  0.033203004  6.561149486
      1739   HOL_PALZH   HOL_LKBBH      58  0.334509555  0.362400744  2.679872913
      1740   HOL_PALZH   HOL_LKSBH      89  0.114105772  0.315740262  1.077444236
      1741   HOL_PALZH   HOL_LKSHH     105  0.035599017  0.308005630  0.363270418
      1742   HOL_PALZH   HOL_MANCH      87  0.316267215  0.430411956  3.091634646
      1745   HOL_PALZH   HOL_MBRUH      58  0.506117270  0.368504172  4.430444186
      1746   HOL_PALZH   HOL_MBUFH     124  0.608691700  0.714996995  8.508519426
      1748   HOL_PALZH   HOL_MRBRH     123  0.539047700  0.536001850  7.068920215
      1751   HOL_PALZH   HOL_SQUSH     157  0.396758872  0.432349683  5.398619953
      1754   HOL_PALZH   HOL_TITEH      70  0.365011577  0.429235533  3.256717692
      1755   HOL_PALZH  HOL_TMB11H      58  0.036518273  0.216776370  0.275890939
      1761   HOL_PALZH   HOL_TRPBH      68  0.372446788  0.529021190  3.284948749
      1762   HOL_PALZH   HOL_TRRBH     187  0.195043502  0.768677386  2.712126203
      1763   HOL_PALZH   HOL_TRRSH     158  0.416785660  0.624806906  5.745084501
      1765   HOL_PALZH   HOL_UNLUH     189  0.256579127  0.216520771  3.639887423
      1769   HOL_SQUSH   HOL_AAHOH     157  0.347714888  0.364675149  4.631992406
      1771   HOL_SQUSH   HOL_BDN2H      60  0.218914148  0.092752129  1.723311918
      1775   HOL_SQUSH   HOL_BRBRH      57  0.238618861  0.204771374  1.838776227
      1781   HOL_SQUSH   HOL_IRRBH     157  0.299853050  0.200795430  3.925807862
      1783   HOL_SQUSH   HOL_KBMBH     143  0.482221485  0.406060391  6.559370513
      1786   HOL_SQUSH   HOL_KMBQH     122  0.112188530  0.250932006  1.241914109
      1788   HOL_SQUSH   HOL_KORHH      57  0.477601912  0.331567296  4.067996388
      1790   HOL_SQUSH   HOL_LATEH     103  0.257036312  0.104705526  2.686190824
      1791   HOL_SQUSH   HOL_LKBBH      57  0.351425985  0.415145689  2.809001552
      1792   HOL_SQUSH   HOL_LKSBH      88  0.103289823  0.327399632  0.968604101
      1793   HOL_SQUSH   HOL_LKSHH     104  0.260830951  0.258130680  2.742062947
      1797   HOL_SQUSH   HOL_MBRUH      57  0.391808284  0.458484738  3.186820992
      1798   HOL_SQUSH   HOL_MBUFH     124  0.451006541  0.510205405  5.604245163
      1800   HOL_SQUSH   HOL_MRBRH     122  0.406418426  0.443851725  4.892925405
      1802   HOL_SQUSH   HOL_PALZH     157  0.396758872  0.432349683  5.398619953
      1807   HOL_SQUSH  HOL_TMB11H      57  0.034766025  0.251901720  0.260322477
      1813   HOL_SQUSH   HOL_TRPBH      68  0.417077201  0.301546782  3.756224803
      1814   HOL_SQUSH   HOL_TRRBH     101  0.131502723  0.444094893  1.326547219
      1815   HOL_SQUSH   HOL_TRRSH     157  0.494324809  0.529997977  7.102584007
      1817   HOL_SQUSH   HOL_UNLUH     157  0.135298979  0.030077818  1.705566702
      1826   HOL_TATEH   HOL_BICKH      77  0.133636892  0.326688577  1.175563790
      1827   HOL_TATEH   HOL_BRBRH      60  0.230664609  0.189656344  1.820871338
      1829   HOL_TATEH   HOL_DHROH     116  0.245609153  0.418843672  2.717092141
      1831   HOL_TATEH   HOL_GKZBH      65  0.328003333  0.223500616  2.777698486
      1832   HOL_TATEH   HOL_GUSTH      88  0.310066749  0.305284742  3.042037561
      1834   HOL_TATEH   HOL_K9SAH     142  0.253814714  0.368958631  3.115920222
      1835   HOL_TATEH   HOL_KBMBH     134  0.263513287  0.416086104  3.150329454
      1836   HOL_TATEH   HOL_KDGBH      55  0.354746879  0.492059867  2.788183335
      1839   HOL_TATEH   HOL_KORBH     138  0.440587868  0.510714524  5.744563064
      1843   HOL_TATEH   HOL_LKBBH     114  0.403610102  0.461347418  4.689352372
      1844   HOL_TATEH   HOL_LKSBH      76  0.395525047  0.378277671  3.729465972
      1845   HOL_TATEH   HOL_LKSHH      72  0.241429031  0.408594403  2.096329799
      1847   HOL_TATEH  HOL_MB253H     178  0.106930926  0.551991160  1.430827155
      1848   HOL_TATEH  HOL_MB259H      84  0.183574774  0.397481879  1.701359114
      1851   HOL_TATEH   HOL_MIWAH     129  0.412145116  0.320113481  5.117765865
      1857   HOL_TATEH   HOL_TATTH      77  0.179829565  0.081321651  1.593698624
      1860   HOL_TATEH  HOL_TMB12H     170  0.619914326  0.703885253 10.270421139
      1861   HOL_TATEH  HOL_TMB21H      69  0.128988583  0.640045352  1.072627749
      1862   HOL_TATEH  HOL_TMB22H      82  0.439051629  0.542447674  4.398032845
      1864   HOL_TATEH HOL_TRMB32H     104  0.131743114  0.419491509  1.348802895
      1867   HOL_TATEH   HOL_TRRSH      72  0.158143461  0.432379215  1.349522681
      1868   HOL_TATEH   HOL_TWMLH     162  0.407060207  0.361545478  5.654704931
      1870   HOL_TATEH   HOL_WEDEH     203  0.167580256  0.488892214  2.415927937
      1871   HOL_TATEH   HOL_WEDGH     105  0.136123890  0.346128904  1.401239729
      1872   HOL_TATEH   HOL_WEDWH     203  0.077051683  0.479001680  1.098375539
      1888   HOL_TATTH   HOL_KDGBH      63 -0.087559381  0.126638336 -0.692101411
      1891   HOL_TATTH   HOL_KORBH      85  0.046435228  0.042769777  0.426045466
      1900   HOL_TATTH  HOL_MB259H      50  0.263201374           NA  1.909745491
      1908   HOL_TATTH   HOL_TATEH      77  0.179829565  0.081321651  1.593698624
      1916   HOL_TATTH HOL_TRMB32H      85  0.199403579  0.115082789  1.865018306
      1922   HOL_TATTH   HOL_WEDEH      63 -0.146651421  0.187191262 -1.167355621
      1924   HOL_TATTH   HOL_WEDWH      63 -0.184679599  0.145794377 -1.479619881
      1927   HOL_TITEH   HOL_BDN2H      84  0.283233492  0.338320042  2.690555518
      1945   HOL_TITEH   HOL_LAGEH      58  0.181761277  0.392027733  1.395513050
      1946   HOL_TITEH   HOL_LATEH      84  0.097782027  0.008943228  0.895126238
      1950   HOL_TITEH   HOL_MANCH      84  0.070299770  0.175630806  0.642049873
      1958   HOL_TITEH   HOL_PALZH      70  0.365011577  0.429235533  3.256717692
      1970   HOL_TITEH   HOL_TRRBH      84  0.492660184  0.478859809  5.157705774
      1977  HOL_TMB11H   HOL_AAHOH      87  0.441421672  0.414098997  4.562105380
      1983  HOL_TMB11H   HOL_BRBRH      95  0.094108502  0.296739269  0.916483180
      1987  HOL_TMB11H   HOL_GKZBH      85  0.000173664  0.340106128  0.001591657
      1989  HOL_TMB11H   HOL_IRRBH      95  0.738107843  0.490500528 10.606794165
      1991  HOL_TMB11H   HOL_KBMBH      95  0.179775977  0.369039404  1.771860672
      1996  HOL_TMB11H   HOL_KORHH      85  0.447164075  0.480030045  4.581941423
      1999  HOL_TMB11H   HOL_LKBBH      95 -0.126528737  0.456570740 -1.236680898
      2000  HOL_TMB11H   HOL_LKSBH      95  0.223933278  0.452640907  2.227686956
      2001  HOL_TMB11H   HOL_LKSHH      95  0.345407296  0.281689900  3.568477514
      2005  HOL_TMB11H   HOL_MBRUH      95  0.124080604  0.528106736  1.212375148
      2006  HOL_TMB11H   HOL_MBUFH      55  0.097614000  0.260539250  0.720755553
      2008  HOL_TMB11H   HOL_MRBRH      73  0.095326145  0.547150742  0.812569529
      2010  HOL_TMB11H   HOL_PALZH      58  0.036518273  0.216776370  0.275890939
      2011  HOL_TMB11H   HOL_SQUSH      57  0.034766025  0.251901720  0.260322477
      2023  HOL_TMB11H   HOL_TRRSH      95  0.292290683  0.528807145  2.963270756
      2025  HOL_TMB11H   HOL_UNLUH      90  0.183344788  0.089926560  1.759497087
      2034  HOL_TMB12H   HOL_BICKH      77  0.325425741  0.335678517  3.000309909
      2035  HOL_TMB12H   HOL_BRBRH      54  0.127818031  0.254408087  0.938224974
      2037  HOL_TMB12H   HOL_DHROH     116  0.706576038  0.599445863 10.707725167
      2039  HOL_TMB12H   HOL_GKZBH      59  0.206204548  0.164828147  1.604898066
      2040  HOL_TMB12H   HOL_GUSTH      88  0.424427059  0.472487999  4.372123277
      2042  HOL_TMB12H   HOL_K9SAH     136  0.195051113  0.532215394  2.310669995
      2043  HOL_TMB12H   HOL_KBMBH     128  0.342397513  0.599927998  4.106862565
      2047  HOL_TMB12H   HOL_KORBH      97  0.060272067  0.476987801  0.591618811
      2051  HOL_TMB12H   HOL_LKBBH     108  0.544759440  0.603884425  6.719636026
      2052  HOL_TMB12H   HOL_LKSBH      70  0.225414032  0.489700927  1.921893219
      2053  HOL_TMB12H   HOL_LKSHH      66  0.402407134  0.466653142  3.543909245
      2055  HOL_TMB12H  HOL_MB253H     170 -0.233782014  0.649386617 -3.125784694
      2056  HOL_TMB12H  HOL_MB259H      70  0.270162719  0.572080219  2.330812081
      2059  HOL_TMB12H   HOL_MIWAH     129  0.708490105  0.429404283 11.358105284
      2064  HOL_TMB12H   HOL_TATEH     170  0.619914326  0.703885253 10.270421139
      2069  HOL_TMB12H  HOL_TMB21H      69  0.588313679  0.715455439  5.999458397
      2070  HOL_TMB12H  HOL_TMB22H      82  0.604236100  0.711063906  6.824910285
      2072  HOL_TMB12H HOL_TRMB32H      63  0.209259651  0.513574696  1.685018256
      2075  HOL_TMB12H   HOL_TRRSH      66  0.527584405  0.665662485  5.007072815
      2076  HOL_TMB12H   HOL_TWMLH     156  0.568477076  0.490006450  8.602759502
      2078  HOL_TMB12H   HOL_WEDEH     170  0.194899198  0.655967645  2.583227404
      2079  HOL_TMB12H   HOL_WEDGH     105  0.202818770  0.466712045  2.112254204
      2080  HOL_TMB12H   HOL_WEDWH     170  0.131540176  0.624961700  1.725011191
      2086  HOL_TMB21H   HOL_BICKH      69  0.308309538  0.249050794  2.672577261
      2087  HOL_TMB21H   HOL_BRBRH      54  0.141560682  0.182896209  1.041061243
      2091  HOL_TMB21H   HOL_GKZBH      59 -0.063652080  0.237617788 -0.485744818
      2092  HOL_TMB21H   HOL_GUSTH      69  0.125643831  0.308952578  1.044361703
      2094  HOL_TMB21H   HOL_K9SAH      69  0.225576266  0.360786854  1.909362385
      2095  HOL_TMB21H   HOL_KBMBH      69  0.472208117  0.657292845  4.417453099
      2103  HOL_TMB21H   HOL_LKBBH      69  0.356994329  0.436806035  3.151514830
      2104  HOL_TMB21H   HOL_LKSBH      69  0.223427090  0.528989194  1.890210280
      2105  HOL_TMB21H   HOL_LKSHH      66  0.377395037  0.500255379  3.285619874
      2107  HOL_TMB21H  HOL_MB253H      69  0.403444986  0.545565464  3.635932666
      2116  HOL_TMB21H   HOL_TATEH      69  0.128988583  0.640045352  1.072627749
      2120  HOL_TMB21H  HOL_TMB12H      69  0.588313679  0.715455439  5.999458397
      2122  HOL_TMB21H  HOL_TMB22H      69  0.243994066  0.343968275  2.074731802
      2127  HOL_TMB21H   HOL_TRRSH      66  0.352614484  0.407635316  3.038003847
      2128  HOL_TMB21H   HOL_TWMLH      69  0.368805637  0.381544691  3.271896507
      2130  HOL_TMB21H   HOL_WEDEH      69  0.539984432  0.506665865  5.290433575
      2131  HOL_TMB21H   HOL_WEDGH      56  0.344013864  0.275313942  2.717115409
      2132  HOL_TMB21H   HOL_WEDWH      69  0.523178137  0.438412294  5.062331889
      2138  HOL_TMB22H   HOL_BICKH      77  0.335960060  0.179517522  3.109571940
      2139  HOL_TMB22H   HOL_BRBRH      54  0.621466404  0.184390902  5.774965560
      2143  HOL_TMB22H   HOL_GKZBH      59 -0.109329770  0.077309696 -0.837652001
      2144  HOL_TMB22H   HOL_GUSTH      82  0.679291680  0.287488012  8.330683272
      2146  HOL_TMB22H   HOL_K9SAH      82  0.285254051  0.510479488  2.678576088
      2147  HOL_TMB22H   HOL_KBMBH      82  0.310896703  0.500502472  2.943962182
      2155  HOL_TMB22H   HOL_LKBBH      82  0.372160586  0.421610342  3.608661344
      2156  HOL_TMB22H   HOL_LKSBH      70  0.492548432  0.334379418  4.701235105
      2157  HOL_TMB22H   HOL_LKSHH      66  0.366729580  0.295082417  3.178093877
      2159  HOL_TMB22H  HOL_MB253H      82  0.136354296  0.416613457  1.238758497
      2163  HOL_TMB22H   HOL_MIWAH      58  0.378996713  0.229551518  3.092034329
      2168  HOL_TMB22H   HOL_TATEH      82  0.439051629  0.542447674  4.398032845
      2172  HOL_TMB22H  HOL_TMB12H      82  0.604236100  0.711063906  6.824910285
      2173  HOL_TMB22H  HOL_TMB21H      69  0.243994066  0.343968275  2.074731802
      2179  HOL_TMB22H   HOL_TRRSH      66 -0.140631520  0.640876355 -1.145188434
      2180  HOL_TMB22H   HOL_TWMLH      82  0.578858208  0.333909100  6.388942361
      2182  HOL_TMB22H   HOL_WEDEH      82  0.401701601  0.611292452  3.947838401
      2183  HOL_TMB22H   HOL_WEDGH      69  0.235451889  0.288916576  1.997750767
      2184  HOL_TMB22H   HOL_WEDWH      82  0.332048025  0.553712120  3.168187313
      2245 HOL_TRMB32H   HOL_DHROH      52  0.189234193  0.513346278  1.376268897
      2252 HOL_TRMB32H   HOL_KDGBH      83  0.174967773  0.450074872  1.609224207
      2255 HOL_TRMB32H   HOL_KORBH     133  0.454742390  0.496032610  5.866221945
      2263 HOL_TRMB32H  HOL_MB253H      71  0.517839579  0.675646409  5.064487993
      2264 HOL_TRMB32H  HOL_MB259H      77  0.529496800  0.459110314  5.441448946
      2272 HOL_TRMB32H   HOL_TATEH     104  0.131743114  0.419491509  1.348802895
      2273 HOL_TRMB32H   HOL_TATTH      85  0.199403579  0.115082789  1.865018306
      2276 HOL_TRMB32H  HOL_TMB12H      63  0.209259651  0.513574696  1.685018256
      2286 HOL_TRMB32H   HOL_WEDEH      90  0.131217727  0.568821850  1.248702376
      2288 HOL_TRMB32H   HOL_WEDWH      90  0.129635676  0.560523192  1.233388233
      2289   HOL_TRPBH   HOL_AAHOH      68  0.356284712  0.490183811  3.121132771
      2301   HOL_TRPBH   HOL_IRRBH      68  0.331075012  0.425255566  2.871929864
      2303   HOL_TRPBH   HOL_KBMBH      68  0.410963063  0.372995637  3.689870330
      2306   HOL_TRPBH   HOL_KMBQH      68 -0.026148714  0.388887146 -0.214109657
      2310   HOL_TRPBH   HOL_LATEH      68  0.259949997 -0.011459399  2.203535398
      2318   HOL_TRPBH   HOL_MBUFH      64  0.616201031  0.552756931  6.210021493
      2320   HOL_TRPBH   HOL_MRBRH      60  0.694007691  0.544136181  7.404186431
      2322   HOL_TRPBH   HOL_PALZH      68  0.372446788  0.529021190  3.284948749
      2323   HOL_TRPBH   HOL_SQUSH      68  0.417077201  0.301546782  3.756224803
      2334   HOL_TRPBH   HOL_TRRBH      68  0.079866946  0.506071379  0.655834172
      2335   HOL_TRPBH   HOL_TRRSH      68  0.233784624  0.462847802  1.968150197
      2337   HOL_TRPBH   HOL_UNLUH      68 -0.287785101  0.044421369 -2.459679277
      2341   HOL_TRRBH   HOL_AAHOH     101  0.158422177  0.533836233  1.604484047
      2343   HOL_TRRBH   HOL_BDN2H     276  0.252126581  0.518011876  4.320627392
      2353   HOL_TRRBH   HOL_IRRBH     101  0.112710306  0.501053287  1.134331145
      2355   HOL_TRRBH   HOL_KBMBH      87  0.107651532  0.669123266  1.004154697
      2358   HOL_TRRBH   HOL_KMBQH      95  0.269473726  0.309999844  2.713004881
      2361   HOL_TRRBH   HOL_LAGEH      58  0.422119379  0.394990644  3.515488051
      2362   HOL_TRRBH   HOL_LATEH     317  0.019928936  0.061802157  0.354334887
      2366   HOL_TRRBH   HOL_MANCH     217  0.191327279  0.336500430  2.864849627
      2370   HOL_TRRBH   HOL_MBUFH      70  0.383379749  0.716668333  3.448054449
      2372   HOL_TRRBH   HOL_MRBRH      66  0.153066164  0.733701800  1.248774495
      2374   HOL_TRRBH   HOL_PALZH     187  0.195043502  0.768677386  2.712126203
      2375   HOL_TRRBH   HOL_SQUSH     101  0.131502723  0.444094893  1.326547219
      2378   HOL_TRRBH   HOL_TITEH      84  0.492660184  0.478859809  5.157705774
      2385   HOL_TRRBH   HOL_TRPBH      68  0.079866946  0.506071379  0.655834172
      2387   HOL_TRRBH   HOL_TRRSH     101  0.147773875  0.638429609  1.494142682
      2389   HOL_TRRBH   HOL_UNLUH     132  0.148901656  0.168033940  1.723470580
      2393   HOL_TRRSH   HOL_AAHOH     187  0.332296592  0.458285337  4.804963625
      2395   HOL_TRRSH   HOL_BDN2H      60  0.435542796  0.176853289  3.716492486
      2398   HOL_TRRSH   HOL_BICKH      66  0.099903053  0.211226084  0.809493917
      2399   HOL_TRRSH   HOL_BRBRH     153 -0.037596570  0.314223987 -0.463849589
      2403   HOL_TRRSH   HOL_GKZBH     148 -0.188090442  0.259036387 -2.321917665
      2404   HOL_TRRSH   HOL_GUSTH      66 -0.185446513  0.338579482 -1.521509137
      2405   HOL_TRRSH   HOL_IRRBH     202  0.397034405  0.303430429  6.133047854
      2406   HOL_TRRSH   HOL_K9SAH     101  0.353085800  0.463439523  3.773933482
      2407   HOL_TRRSH   HOL_KBMBH     251  0.389238024  0.574039069  6.681299456
      2410   HOL_TRRSH   HOL_KMBQH     122  0.128799278  0.389133386  1.428692088
      2412   HOL_TRRSH   HOL_KORHH      85  0.642772074  0.480783259  7.690158418
      2414   HOL_TRRSH   HOL_LATEH     103  0.239689088  0.032238120  2.493425221
      2415   HOL_TRRSH   HOL_LKBBH     165 -0.089227628  0.513661005 -1.147247245
      2416   HOL_TRRSH   HOL_LKSBH     196 -0.053779651  0.461660810 -0.752080348
      2417   HOL_TRRSH   HOL_LKSHH     212  0.088249244  0.415316109  1.286915306
      2419   HOL_TRRSH  HOL_MB253H      66  0.643374022  0.556914738  6.775564788
      2421   HOL_TRRSH   HOL_MBRUH     100  0.460348649  0.584573346  5.159641879
      2422   HOL_TRRSH   HOL_MBUFH     124  0.446763833  0.670593303  5.538299791
      2424   HOL_TRRSH   HOL_MRBRH     138  0.377208429  0.624626688  4.767277942
      2426   HOL_TRRSH   HOL_PALZH     158  0.416785660  0.624806906  5.745084501
      2427   HOL_TRRSH   HOL_SQUSH     157  0.494324809  0.529997977  7.102584007
      2428   HOL_TRRSH   HOL_TATEH      72  0.158143461  0.432379215  1.349522681
      2431   HOL_TRRSH  HOL_TMB11H      95  0.292290683  0.528807145  2.963270756
      2432   HOL_TRRSH  HOL_TMB12H      66  0.527584405  0.665662485  5.007072815
      2433   HOL_TRRSH  HOL_TMB21H      66  0.352614484  0.407635316  3.038003847
      2434   HOL_TRRSH  HOL_TMB22H      66 -0.140631520  0.640876355 -1.145188434
      2437   HOL_TRRSH   HOL_TRPBH      68  0.233784624  0.462847802  1.968150197
      2438   HOL_TRRSH   HOL_TRRBH     101  0.147773875  0.638429609  1.494142682
      2440   HOL_TRRSH   HOL_TWMLH     110 -0.105790202  0.444866315 -1.110714945
      2441   HOL_TRRSH   HOL_UNLUH     190  0.188200834  0.214330284  2.634409102
      2442   HOL_TRRSH   HOL_WEDEH      76  0.402791132  0.435415383  3.811104891
      2443   HOL_TRRSH   HOL_WEDGH      53  0.474964442  0.258843606  3.892043052
      2444   HOL_TRRSH   HOL_WEDWH      76  0.427268723  0.359800846  4.092638732
      2450   HOL_TWMLH   HOL_BICKH      77  0.330742957  0.319830826  3.055299845
      2451   HOL_TWMLH   HOL_BRBRH      98  0.488033063  0.189688375  5.506908557
      2453   HOL_TWMLH   HOL_DHROH     113  0.301798507  0.323127643  3.350146719
      2455   HOL_TWMLH   HOL_GKZBH     103  0.183764564  0.242532939  1.888084658
      2456   HOL_TWMLH   HOL_GUSTH      88  0.492230094  0.303859893  5.274440684
      2458   HOL_TWMLH   HOL_K9SAH     171  0.158939070  0.428712893  2.098993510
      2459   HOL_TWMLH   HOL_KBMBH     172  0.015844598  0.232887482  0.207221017
      2463   HOL_TWMLH   HOL_KORBH      83  0.171363922  0.387056412  1.575064993
      2467   HOL_TWMLH   HOL_LKBBH     152  0.566824381  0.312159966  8.454634421
      2468   HOL_TWMLH   HOL_LKSBH     114  0.509604090  0.371210304  6.296035594
      2469   HOL_TWMLH   HOL_LKSHH     110  0.420838212  0.200631160  4.843464834
      2471   HOL_TWMLH  HOL_MB253H     156 -0.146541730  0.365020421 -1.844340427
      2472   HOL_TWMLH  HOL_MB259H      56  0.024214611  0.517503480  0.179633036
      2475   HOL_TWMLH   HOL_MIWAH     129  0.281844726  0.221487629  3.323441277
      2480   HOL_TWMLH   HOL_TATEH     162  0.407060207  0.361545478  5.654704931
      2484   HOL_TWMLH  HOL_TMB12H     156  0.568477076  0.490006450  8.602759502
      2485   HOL_TWMLH  HOL_TMB21H      69  0.368805637  0.381544691  3.271896507
      2486   HOL_TWMLH  HOL_TMB22H      82  0.578858208  0.333909100  6.388942361
      2491   HOL_TWMLH   HOL_TRRSH     110 -0.105790202  0.444866315 -1.110714945
      2494   HOL_TWMLH   HOL_WEDEH     166  0.197003573  0.334921921  2.581139912
      2495   HOL_TWMLH   HOL_WEDGH     105  0.226324375  0.131401013  2.369549920
      2496   HOL_TWMLH   HOL_WEDWH     166  0.113962643  0.284310730  1.473476302
      2497   HOL_UNLUH   HOL_AAHOH     187 -0.031712669  0.064022899 -0.432720785
      2499   HOL_UNLUH   HOL_BDN2H      91  0.064324801  0.242647987  0.611505061
      2503   HOL_UNLUH   HOL_BRBRH      90  0.234093805  0.107941312  2.271553900
      2507   HOL_UNLUH   HOL_GKZBH      80  0.086962224  0.054221366  0.775876473
      2509   HOL_UNLUH   HOL_IRRBH     190  0.141304936  0.152727979  1.962311295
      2511   HOL_UNLUH   HOL_KBMBH     176  0.360137445  0.271504589  5.106843594
      2514   HOL_UNLUH   HOL_KMBQH     122  0.217656631  0.180615553  2.453033421
      2516   HOL_UNLUH   HOL_KORHH      85  0.120928149 -0.087497523  1.116518626
      2518   HOL_UNLUH   HOL_LATEH     134 -0.033085444 -0.025515608 -0.381768966
      2519   HOL_UNLUH   HOL_LKBBH      90  0.114272999  0.144795007  1.085157762
      2520   HOL_UNLUH   HOL_LKSBH     121  0.114516712  0.150898944  1.262775114
      2521   HOL_UNLUH   HOL_LKSHH     137  0.320611330  0.141760093  3.947313870
      2525   HOL_UNLUH   HOL_MBRUH      90  0.176705007  0.138971604  1.693683748
      2526   HOL_UNLUH   HOL_MBUFH     124  0.305811681  0.240252770  3.562277112
      2528   HOL_UNLUH   HOL_MRBRH     138 -0.110182054  0.109825237 -1.297548098
      2530   HOL_UNLUH   HOL_PALZH     189  0.256579127  0.216520771  3.639887423
      2531   HOL_UNLUH   HOL_SQUSH     157  0.135298979  0.030077818  1.705566702
      2535   HOL_UNLUH  HOL_TMB11H      90  0.183344788  0.089926560  1.759497087
      2541   HOL_UNLUH   HOL_TRPBH      68 -0.287785101  0.044421369 -2.459679277
      2542   HOL_UNLUH   HOL_TRRBH     132  0.148901656  0.168033940  1.723470580
      2543   HOL_UNLUH   HOL_TRRSH     190  0.188200834  0.214330284  2.634409102
      2554   HOL_WEDEH   HOL_BICKH      77  0.334837187  0.220952568  3.097864025
      2555   HOL_WEDEH   HOL_BRBRH      64  0.274358628  0.258833452  2.264550695
      2557   HOL_WEDEH   HOL_DHROH     116  0.386904490  0.516880163  4.499511282
      2559   HOL_WEDEH   HOL_GKZBH      69  0.156149106  0.240202586  1.303629490
      2560   HOL_WEDEH   HOL_GUSTH      88  0.181442734  0.147711923  1.720950333
      2562   HOL_WEDEH   HOL_K9SAH     146  0.216597331  0.403352862  2.671598235
      2563   HOL_WEDEH   HOL_KBMBH     138  0.452358388  0.500901295  5.936873740
      2567   HOL_WEDEH   HOL_KORBH     124  0.253383305  0.405401632  2.904957292
      2571   HOL_WEDEH   HOL_LKBBH     118  0.347653246  0.485822075  4.010614194
      2572   HOL_WEDEH   HOL_LKSBH      80  0.264211526  0.426866051  2.434887735
      2573   HOL_WEDEH   HOL_LKSHH      76  0.218206049  0.284314989  1.936381342
      2575   HOL_WEDEH  HOL_MB253H     178  0.459390150  0.530474537  6.880826860
      2576   HOL_WEDEH  HOL_MB259H      84  0.151884006  0.569579263  1.399971159
      2579   HOL_WEDEH   HOL_MIWAH     129  0.070142752  0.495090767  0.795534074
      2584   HOL_WEDEH   HOL_TATEH     203  0.167580256  0.488892214  2.415927937
      2585   HOL_WEDEH   HOL_TATTH      63 -0.146651421  0.187191262 -1.167355621
      2588   HOL_WEDEH  HOL_TMB12H     170  0.194899198  0.655967645  2.583227404
      2589   HOL_WEDEH  HOL_TMB21H      69  0.539984432  0.506665865  5.290433575
      2590   HOL_WEDEH  HOL_TMB22H      82  0.401701601  0.611292452  3.947838401
      2592   HOL_WEDEH HOL_TRMB32H      90  0.131217727  0.568821850  1.248702376
      2595   HOL_WEDEH   HOL_TRRSH      76  0.402791132  0.435415383  3.811104891
      2596   HOL_WEDEH   HOL_TWMLH     166  0.197003573  0.334921921  2.581139912
      2599   HOL_WEDEH   HOL_WEDGH     105  0.523920912  0.440305026  6.272802818
      2600   HOL_WEDEH   HOL_WEDWH     207  0.978905719  0.968930120 68.766917325
      2606   HOL_WEDGH   HOL_BICKH      64  0.327289636 -0.116183942  2.749195457
      2609   HOL_WEDGH   HOL_DHROH      75  0.620845102  0.583970783  6.812711955
      2612   HOL_WEDGH   HOL_GUSTH      75  0.114871224  0.251548967  0.994744452
      2614   HOL_WEDGH   HOL_K9SAH     105  0.002461062  0.347195026  0.025098086
      2615   HOL_WEDGH   HOL_KBMBH     105  0.186686657  0.322246064  1.937907171
      2623   HOL_WEDGH   HOL_LKBBH      95  0.341031432  0.407961750  3.517276474
      2624   HOL_WEDGH   HOL_LKSBH      57  0.037667612  0.173995168  0.282078779
      2625   HOL_WEDGH   HOL_LKSHH      53  0.170916909  0.297401147  1.250905881
      2627   HOL_WEDGH  HOL_MB253H     105  0.270299737  0.374831539  2.863102772
      2631   HOL_WEDGH   HOL_MIWAH      94  0.016502954  0.460010471  0.159170400
      2636   HOL_WEDGH   HOL_TATEH     105  0.136123890  0.346128904  1.401239729
      2640   HOL_WEDGH  HOL_TMB12H     105  0.202818770  0.466712045  2.112254204
      2641   HOL_WEDGH  HOL_TMB21H      56  0.344013864  0.275313942  2.717115409
      2642   HOL_WEDGH  HOL_TMB22H      69  0.235451889  0.288916576  1.997750767
      2647   HOL_WEDGH   HOL_TRRSH      53  0.474964442  0.258843606  3.892043052
      2648   HOL_WEDGH   HOL_TWMLH     105  0.226324375  0.131401013  2.369549920
      2650   HOL_WEDGH   HOL_WEDEH     105  0.523920912  0.440305026  6.272802818
      2652   HOL_WEDGH   HOL_WEDWH     105  0.534250550  0.458507159  6.445213809
      2658   HOL_WEDWH   HOL_BICKH      77  0.308287116  0.173699858  2.825190294
      2659   HOL_WEDWH   HOL_BRBRH      64  0.225918357  0.241293227  1.840761985
      2661   HOL_WEDWH   HOL_DHROH     116  0.394374162  0.519431179  4.602200268
      2663   HOL_WEDWH   HOL_GKZBH      69  0.123656717  0.218464883  1.027586074
      2664   HOL_WEDWH   HOL_GUSTH      88  0.112537983  0.078855364  1.056395260
      2666   HOL_WEDWH   HOL_K9SAH     146  0.194764476  0.380558863  2.391063634
      2667   HOL_WEDWH   HOL_KBMBH     138  0.430539452  0.438924058  5.583306851
      2671   HOL_WEDWH   HOL_KORBH     124  0.225610729  0.415516720  2.568362760
      2675   HOL_WEDWH   HOL_LKBBH     118  0.265138039  0.467384322  2.974357247
      2676   HOL_WEDWH   HOL_LKSBH      80  0.168797282  0.389698539  1.522144639
      2677   HOL_WEDWH   HOL_LKSHH      76  0.196719235  0.282650191  1.737591326
      2679   HOL_WEDWH  HOL_MB253H     178  0.475733073  0.497914415  7.195646867
      2680   HOL_WEDWH  HOL_MB259H      84  0.162768833  0.557212425  1.502937465
      2683   HOL_WEDWH   HOL_MIWAH     129  0.030091643  0.477594560  0.340602321
      2688   HOL_WEDWH   HOL_TATEH     203  0.077051683  0.479001680  1.098375539
      2689   HOL_WEDWH   HOL_TATTH      63 -0.184679599  0.145794377 -1.479619881
      2692   HOL_WEDWH  HOL_TMB12H     170  0.131540176  0.624961700  1.725011191
      2693   HOL_WEDWH  HOL_TMB21H      69  0.523178137  0.438412294  5.062331889
      2694   HOL_WEDWH  HOL_TMB22H      82  0.332048025  0.553712120  3.168187313
      2696   HOL_WEDWH HOL_TRMB32H      90  0.129635676  0.560523192  1.233388233
      2699   HOL_WEDWH   HOL_TRRSH      76  0.427268723  0.359800846  4.092638732
      2700   HOL_WEDWH   HOL_TWMLH     166  0.113962643  0.284310730  1.473476302
      2702   HOL_WEDWH   HOL_WEDEH     207  0.978905719  0.968930120 68.766917325
      2703   HOL_WEDWH   HOL_WEDGH     105  0.534250550  0.458507159  6.445213809
                 t_hol       sgc       ssgc            p
      3     3.78461454 0.6610169 0.03389831 1.337634e-02
      7     2.30966394 0.5697674 0.04651163 1.956677e-01
      11    2.50828143 0.5657895 0.05263158 2.513491e-01
      13    5.82196912 0.5913978 0.04838710 1.266685e-02
      15    5.95643279 0.6046512 0.04651163 6.051564e-03
      18    8.03865634 0.7520661 0.06611570 2.931915e-08
      20    2.74691328 0.5476190 0.03571429 3.827331e-01
      22    2.06726998 0.5392157 0.03921569 4.282919e-01
      23    3.19224325 0.5581395 0.03488372 2.808875e-01
      24    6.19671953 0.6239316 0.03418803 7.339134e-03
      25    2.89925600 0.5338346 0.03759398 4.351561e-01
      29    4.77429753 0.6162791 0.05813953 3.103252e-02
      30    6.23943859 0.7073171 0.03252033 4.255128e-06
      32    7.86749352 0.6642336 0.05839416 1.207446e-04
      34    5.79740652 0.6369427 0.03184713 5.996479e-04
      35    4.87595238 0.6089744 0.05128205 6.485308e-03
      39    4.19432051 0.6279070 0.04651163 1.767673e-02
      45    4.56882160 0.6417910 0.04477612 2.027500e-02
      46    6.28155102 0.7000000 0.04000000 6.334248e-05
      47    7.01318469 0.6559140 0.05376344 2.111459e-05
      49    0.87259576 0.5322581 0.04301075 3.789229e-01
      105   3.78461454 0.6610169 0.03389831 1.337634e-02
      117   5.65616643 0.6949153 0.01694915 2.750348e-03
      122   1.57587655 0.6226415 0.01886792 7.414990e-02
      125   2.71847842 0.6491228 0.05263158 2.434092e-02
      126   1.46530832 0.4830769 0.03692308 1.458251e+00
      130   3.31077605 0.5377778 0.02666667 2.570743e-01
      138   5.38463941 0.6275862 0.01379310 2.121439e-03
      139   0.70943739 0.5084746 0.05084746 8.964170e-01
      142   3.25559723 0.5542169 0.02409639 3.232122e-01
      150  10.02441978 0.6327273 0.05090909 1.072251e-05
      151   1.36844501 0.5254237 0.03389831 6.961175e-01
      153   2.35965627 0.6000000 0.00000000 5.777957e-02
      161   1.42889764 0.6379310 0.01724138 3.564949e-02
      164   2.30485004 0.5441176 0.08823529 4.668543e-01
      173   1.89724941 0.6911765 0.02941176 1.616222e-03
      175   2.59891146 0.6451613 0.00000000 2.225412e-02
      212   1.42889764 0.6379310 0.01724138 3.564949e-02
      216   2.65170649 0.5388128 0.08219178 2.506576e-01
      218   0.48059910 0.4456522 0.08695652 1.702853e+00
      225   4.80992577 0.6255507 0.06167401 1.548107e-04
      227   1.29998293 0.5192308 0.00000000 7.815113e-01
      241   1.82161324 0.4765101 0.10067114 1.433668e+00
      267   1.86771223 0.4716981 0.05660377 1.319720e+00
      271   3.75623663 0.6034483 0.10344828 1.151002e-01
      272   3.74969864 0.6052632 0.01315789 6.645742e-02
      274   0.82720045 0.6052632 0.01315789 6.645742e-02
      275   2.68068371 0.6315789 0.00000000 2.178146e-02
      283   3.10524264 0.6052632 0.02631579 6.645742e-02
      284   1.53881908 0.5072464 0.04347826 9.041775e-01
      285   1.16559774 0.5384615 0.00000000 5.351435e-01
      287   2.75741594 0.6447368 0.02631579 1.161689e-02
      291   0.75308613 0.5769231 0.00000000 2.672575e-01
      296   2.99345060 0.5921053 0.01315789 1.082937e-01
      300   3.08612890 0.5921053 0.02631579 1.082937e-01
      301   2.10489289 0.5441176 0.02941176 4.668543e-01
      302   1.58034033 0.5921053 0.02631579 1.082937e-01
      307   1.72881554 0.6000000 0.00000000 1.068637e-01
      308   2.92336703 0.6842105 0.02631579 1.318969e-03
      310   1.96199700 0.5789474 0.00000000 1.686686e-01
      311  -0.92107103 0.5396825 0.03174603 5.287333e-01
      312   1.52750505 0.5657895 0.00000000 2.513491e-01
      313   2.30966394 0.5697674 0.04651163 1.956677e-01
      318   1.86771223 0.4716981 0.05660377 1.319720e+00
      323   3.95891351 0.5492958 0.07042254 2.400532e-01
      324   1.48057699 0.4339623 0.07547170 1.663711e+00
      325   1.16340370 0.5148515 0.02970297 7.653131e-01
      326   1.86272118 0.5681818 0.04545455 2.008251e-01
      327   2.81337721 0.5460526 0.04605263 2.561450e-01
      332   1.84196442 0.5833333 0.01190476 1.266305e-01
      335   5.54335130 0.6118421 0.03289474 5.819817e-03
      336   4.26055439 0.6250000 0.04605263 2.054719e-03
      337   2.91566650 0.5723684 0.04605263 7.435291e-02
      339   0.79597722 0.4905660 0.07547170 1.109254e+00
      341   2.81031788 0.5757576 0.03030303 1.316680e-01
      342   3.12518114 0.5740741 0.03703704 2.763029e-01
      344   2.42096130 0.5694444 0.04166667 2.385928e-01
      346   0.57397454 0.4912281 0.01754386 1.105374e+00
      347   1.55150174 0.6250000 0.01785714 6.136883e-02
      348   1.47107898 0.5254237 0.06779661 6.961175e-01
      351   2.99662212 0.6063830 0.03191489 3.912760e-02
      352   1.89697919 0.5660377 0.03773585 3.362888e-01
      353   1.34151163 0.4716981 0.07547170 1.319720e+00
      354   1.35285919 0.4905660 0.09433962 1.109254e+00
      359   4.06726031 0.6118421 0.04605263 5.819817e-03
      360   1.89292623 0.6288660 0.06185567 1.113716e-02
      361   1.01853026 0.4382022 0.03370787 1.756385e+00
      362   2.10995993 0.6190476 0.04761905 5.878172e-02
      364   1.95779314 0.6031746 0.04761905 1.014538e-01
      368   2.30485004 0.5441176 0.08823529 4.668543e-01
      369   2.65170649 0.5388128 0.08219178 2.506576e-01
      374  -1.08153866 0.4130435 0.04347826 1.904707e+00
      381   4.91884435 0.5826087 0.06086957 1.222280e-02
      383   3.96049640 0.5797101 0.07246377 1.854219e-01
      397   0.11097661 0.5098039 0.04901961 8.430220e-01
      430   4.61442952 0.6630435 0.03260870 1.761702e-03
      431   5.16997366 0.6547619 0.04761905 4.556350e-03
      435   2.42439291 0.5647059 0.03529412 2.328234e-01
      439   5.07928700 0.5468750 0.07812500 4.532547e-01
      443   6.64646762 0.6000000 0.05217391 3.197196e-02
      444   3.82436744 0.6896552 0.05172414 3.867869e-03
      447   5.13638087 0.5963303 0.06422018 4.427951e-02
      452   4.92482298 0.5565217 0.03478261 2.254143e-01
      456   7.99626189 0.5565217 0.09565217 2.254143e-01
      460   4.22976500 0.6666667 0.05882353 1.729028e-02
      464   3.59733880 0.6339286 0.06250000 4.586392e-03
      466   6.44672611 0.6521739 0.04347826 1.099416e-03
      467   6.14634665 0.5945946 0.04054054 1.036380e-01
      468   6.49026050 0.6434783 0.04347826 2.089089e-03
      473   0.48059910 0.4456522 0.08695652 1.702853e+00
      476  -1.08153866 0.4130435 0.04347826 1.904707e+00
      485  -0.24445426 0.4673913 0.05434783 1.468385e+00
      501   2.08136273 0.4725275 0.05494505 1.399821e+00
      521   2.50828143 0.5657895 0.05263158 2.513491e-01
      526   3.75623663 0.6034483 0.10344828 1.151002e-01
      527   3.95891351 0.5492958 0.07042254 2.400532e-01
      532   4.00196380 0.5344828 0.12068966 5.994263e-01
      533   3.16297812 0.6593407 0.02197802 2.365577e-03
      534  -0.36241090 0.4946237 0.05376344 1.082589e+00
      535   3.87703068 0.5918367 0.06802721 2.595246e-02
      540   5.48045426 0.7567568 0.01351351 9.989052e-06
      543   5.05001502 0.6054422 0.05442177 1.056287e-02
      544   4.79893676 0.6190476 0.06802721 3.892417e-03
      545   2.09469438 0.5102041 0.06802721 8.045709e-01
      547   1.31148877 0.5344828 0.12068966 5.994263e-01
      549   5.51878806 0.6516854 0.03370787 4.209845e-03
      552   4.45880423 0.6612903 0.06451613 1.108517e-02
      556   1.82002078 0.5312500 0.10937500 6.170751e-01
      559   3.29493506 0.5595238 0.03571429 2.752335e-01
      560   1.26168213 0.5862069 0.12068966 1.891613e-01
      561   1.84687170 0.5689655 0.13793103 2.935106e-01
      562   0.58542752 0.5000000 0.13793103 1.000000e+00
      567   3.24055667 0.5986395 0.06802721 1.676234e-02
      568   2.51243934 0.6274510 0.07843137 1.004189e-02
      569   0.47957563 0.4683544 0.03797468 1.426255e+00
      570   2.02544221 0.6029412 0.08823529 8.955507e-02
      572   1.83247594 0.5882353 0.08823529 1.456101e-01
      578   3.74969864 0.6052632 0.01315789 6.645742e-02
      579   1.48057699 0.4339623 0.07547170 1.663711e+00
      583   4.00196380 0.5344828 0.12068966 5.994263e-01
      586   2.18842902 0.5287356 0.03448276 5.919197e-01
      587   3.68698591 0.5862069 0.02298851 1.077982e-01
      595   4.00484984 0.5517241 0.04597701 3.345943e-01
      596   2.38640296 0.5362319 0.05797101 5.472212e-01
      597   1.67679668 0.4461538 0.01538462 1.614739e+00
      599   6.15012923 0.6781609 0.05747126 8.887985e-04
      603   1.70141854 0.5555556 0.03174603 3.778216e-01
      608   2.97302305 0.5287356 0.03448276 5.919197e-01
      612   4.97162031 0.5287356 0.05747126 5.919197e-01
      613   2.65896942 0.5000000 0.04411765 1.000000e+00
      614   2.68470795 0.5925926 0.03703704 9.558070e-02
      619   2.87865561 0.5384615 0.01538462 5.351435e-01
      620   2.95773197 0.5057471 0.04597701 9.146214e-01
      622   1.38501707 0.5057471 0.02298851 9.146214e-01
      623   2.22064098 0.5675676 0.05405405 2.450420e-01
      624   0.73355882 0.5172414 0.02298851 7.477302e-01
      625   5.82196912 0.5913978 0.04838710 1.266685e-02
      627   5.65616643 0.6949153 0.01694915 2.750348e-03
      631   1.16340370 0.5148515 0.02970297 7.653131e-01
      635   3.16297812 0.6593407 0.02197802 2.365577e-03
      639   4.46732036 0.6042781 0.04278075 4.345023e-03
      642   2.42608350 0.6198347 0.06611570 8.379987e-03
      644   2.91564321 0.6428571 0.02380952 8.828761e-03
      646   2.01908631 0.5490196 0.04901961 3.221020e-01
      647   2.54085805 0.6633663 0.01980198 1.024820e-03
      648   4.72205843 0.6590909 0.03787879 2.565504e-04
      649   2.43025790 0.5405405 0.04054054 3.239398e-01
      653   2.47668430 0.6060606 0.04040404 3.480848e-02
      654   4.93486656 0.6422764 0.04065041 1.600346e-03
      656   4.37525776 0.6569343 0.06569343 2.390279e-04
      658   5.59216119 0.6114650 0.03184713 5.217262e-03
      659   2.55185611 0.5384615 0.05128205 3.366684e-01
      663   5.42803973 0.7127660 0.04255319 3.696329e-05
      669   3.81714110 0.6119403 0.04477612 6.687076e-02
      670   5.76071481 0.6700000 0.06000000 6.738585e-04
      671   4.50347702 0.6169154 0.04477612 9.160235e-04
      673   2.11895961 0.5343915 0.03703704 3.443471e-01
      682   0.82720045 0.6052632 0.01315789 6.645742e-02
      683   1.86272118 0.5681818 0.04545455 2.008251e-01
      685   4.61442952 0.6630435 0.03260870 1.761702e-03
      687  -0.36241090 0.4946237 0.05376344 1.082589e+00
      688   2.18842902 0.5287356 0.03448276 5.919197e-01
      691   4.48709964 0.5740741 0.03086420 5.934644e-02
      695   4.01546036 0.6612903 0.03225806 1.108517e-02
      699   2.96978254 0.5915493 0.04225352 2.911902e-02
      700   3.73088261 0.6057692 0.04807692 3.098405e-02
      701   1.23565226 0.5400000 0.03000000 4.237108e-01
      703   6.05108234 0.6222222 0.03703704 4.508698e-03
      707   3.92118181 0.5945946 0.04504505 4.623607e-02
      712   4.69696814 0.6028369 0.02127660 1.459642e-02
      716   7.27707678 0.6074074 0.06666667 1.256300e-02
      717   3.16643228 0.5441176 0.04411765 4.668543e-01
      718   5.30982767 0.7160494 0.03703704 1.007042e-04
      723   5.20372019 0.6200000 0.01000000 1.639507e-02
      724   6.16893514 0.6411765 0.03529412 2.319277e-04
      726   5.28961625 0.6413793 0.02068966 6.619685e-04
      727   3.75738021 0.5769231 0.03846154 1.166645e-01
      728   4.93827875 0.6275862 0.02068966 2.121439e-03
      729   5.95643279 0.6046512 0.04651163 6.051564e-03
      734   2.68068371 0.6315789 0.00000000 2.178146e-02
      735   2.81337721 0.5460526 0.04605263 2.561450e-01
      737   5.16997366 0.6547619 0.04761905 4.556350e-03
      739   3.87703068 0.5918367 0.06802721 2.595246e-02
      740   3.68698591 0.5862069 0.02298851 1.077982e-01
      741   4.46732036 0.6042781 0.04278075 4.345023e-03
      742   4.48709964 0.5740741 0.03086420 5.934644e-02
      746   4.29650938 0.6017699 0.05309735 3.049061e-02
      747   2.49914563 0.5925926 0.03703704 1.735682e-01
      748   4.28966940 0.6071429 0.02380952 4.953461e-02
      750   1.83983900 0.5340909 0.02272727 5.224313e-01
      751   9.77819860 0.6796117 0.03398058 2.525176e-07
      752   8.46160296 0.6582915 0.03015075 7.971363e-06
      753   7.63163726 0.6303318 0.02843602 1.528725e-04
      755   5.75094395 0.6614173 0.03149606 2.745910e-04
      757   7.29524881 0.6767677 0.05050505 4.354152e-04
      758   9.12366726 0.7235772 0.02439024 7.079026e-07
      759   3.83440260 0.6310680 0.03883495 7.805044e-03
      760   8.18953660 0.6861314 0.05109489 1.317224e-05
      762   6.65972704 0.6293706 0.02797203 1.974140e-03
      763   5.27627051 0.6267606 0.04225352 2.518974e-03
      764   5.25715694 0.6090226 0.01503759 1.191611e-02
      767   3.82917418 0.5851064 0.05319149 9.888691e-02
      768   8.41715072 0.6535433 0.06299213 5.387921e-04
      769   7.13896237 0.6029412 0.02941176 8.955507e-02
      770   5.17090062 0.6419753 0.02469136 1.060184e-02
      773   3.26592239 0.6268657 0.01492537 3.781258e-02
      774   8.30115022 0.7674419 0.04651163 7.038165e-07
      775  11.06237782 0.6720000 0.03200000 5.354511e-08
      776   3.12233393 0.5438596 0.04093567 2.513491e-01
      777   3.72116924 0.6228571 0.04000000 1.152045e-03
      778   6.74920035 0.7153285 0.01459854 4.638074e-07
      779   3.45472966 0.6730769 0.01923077 4.154176e-04
      780   5.69677517 0.7153285 0.01459854 4.638074e-07
      799   4.89818219 0.6341463 0.01219512 1.511993e-02
      816   4.11487352 0.6666667 0.00000000 1.430588e-02
      817   0.99710476 0.5161290 0.06451613 7.994954e-01
      824   4.53607556 0.6219512 0.03658537 2.720035e-02
      836   1.89724941 0.6911765 0.02941176 1.616222e-03
      837   4.80992577 0.6255507 0.06167401 1.548107e-04
      840   4.91884435 0.5826087 0.06086957 1.222280e-02
      842  -0.24445426 0.4673913 0.05434783 1.468385e+00
      851   3.86654627 0.6190476 0.01587302 5.878172e-02
      865   0.44355997 0.4909091 0.04545455 1.151233e+00
      885   8.03865634 0.7520661 0.06611570 2.931915e-08
      887   1.57587655 0.6226415 0.01886792 7.414990e-02
      897   2.42608350 0.6198347 0.06611570 8.379987e-03
      899   4.29650938 0.6017699 0.05309735 3.049061e-02
      906   1.29540364 0.5104167 0.04166667 8.382565e-01
      908   3.08016101 0.5689655 0.08620690 2.935106e-01
      909   4.06637381 0.6216216 0.05405405 3.639761e-02
      914   5.59267905 0.6770833 0.05208333 5.202443e-04
      916   4.62048927 0.6195652 0.07608696 2.181012e-02
      918   3.86295977 0.5537190 0.04958678 2.372779e-01
      919   2.83967873 0.5702479 0.07438017 1.222364e-01
      929   3.42926753 0.5522388 0.04477612 3.924481e-01
      930   3.14443581 0.6276596 0.06382979 1.330829e-02
      931   4.62747357 0.6611570 0.04958678 3.919366e-04
      933   2.01162795 0.5123967 0.04958678 7.850629e-01
      940   2.59891146 0.6451613 0.00000000 2.225412e-02
      941   1.29998293 0.5192308 0.00000000 7.815113e-01
      944   3.96049640 0.5797101 0.07246377 1.854219e-01
      945   2.42439291 0.5647059 0.03529412 2.328234e-01
      950   4.01546036 0.6612903 0.03225806 1.108517e-02
      951   2.49914563 0.5925926 0.03703704 1.735682e-01
      952   4.89818219 0.6341463 0.01219512 1.511993e-02
      953   3.86654627 0.6190476 0.01587302 5.878172e-02
      963   7.82593561 0.7019231 0.02884615 3.814478e-05
      964   4.11736405 0.6867470 0.02409639 6.672544e-04
      967   2.62363077 0.5949367 0.05063291 9.148192e-02
      972   6.92748028 0.6861314 0.00729927 1.317224e-05
      973   0.39000809 0.5595238 0.05952381 2.752335e-01
      976   5.28962289 0.6354167 0.07291667 7.963489e-03
      980   6.53843979 0.7045455 0.02272727 2.600383e-06
      984   3.77797831 0.6585366 0.04878049 4.088913e-03
      986   4.89838960 0.5934959 0.02439024 3.809416e-02
      988   5.04574004 0.6016260 0.01626016 2.418522e-02
      989   2.74691328 0.5476190 0.03571429 3.827331e-01
      995   1.84196442 0.5833333 0.01190476 1.266305e-01
      999   5.48045426 0.7567568 0.01351351 9.989052e-06
      1001  2.91564321 0.6428571 0.02380952 8.828761e-03
      1003  4.28966940 0.6071429 0.02380952 4.953461e-02
      1011  6.43932685 0.7142857 0.00000000 8.568298e-05
      1012  5.94226530 0.6785714 0.01190476 1.063115e-03
      1013  3.00620774 0.5476190 0.02380952 3.827331e-01
      1017  5.78551661 0.6190476 0.02380952 2.909633e-02
      1018  0.61714555 0.5740741 0.03703704 2.763029e-01
      1020  4.70454233 0.6111111 0.05555556 5.934644e-02
      1022  1.53146978 0.5438596 0.01754386 5.078006e-01
      1023  2.60640936 0.5357143 0.01785714 5.929801e-01
      1027  4.98520562 0.6547619 0.01190476 4.556350e-03
      1035  4.99537725 0.6666667 0.03571429 2.250227e-03
      1037 -0.80020938 0.4880952 0.02380952 1.172741e+00
      1043  2.71847842 0.6491228 0.05263158 2.434092e-02
      1062  0.88695956 0.4912281 0.08771930 1.105374e+00
      1066  2.06170989 0.5789474 0.05263158 2.332302e-01
      1078  3.18892993 0.6140351 0.07017544 8.508907e-02
      1086  3.21746721 0.7017544 0.07017544 2.315807e-03
      1093  2.06726998 0.5392157 0.03921569 4.282919e-01
      1095  1.46530832 0.4830769 0.03692308 1.458251e+00
      1105  2.01908631 0.5490196 0.04901961 3.221020e-01
      1107  1.83983900 0.5340909 0.02272727 5.224313e-01
      1110  1.29540364 0.5104167 0.04166667 8.382565e-01
      1113  0.88695956 0.4912281 0.08771930 1.105374e+00
      1117          NA        NA         NA           NA
      1118 -0.03592364 0.4666667 0.02666667 1.682689e+00
      1122  1.13087030 0.4788732 0.01408451 1.278185e+00
      1124  0.67751835 0.5223881 0.02985075 7.139858e-01
      1126  0.45429473 0.4680851 0.02127660 1.618529e+00
      1127  1.05809357 0.4705882 0.05882353 1.447547e+00
      1130  0.08098762 0.5180723 0.03614458 7.419344e-01
      1137 -0.09310271 0.4925373 0.02985075 1.097235e+00
      1138  1.09898027 0.5000000 0.05379747 1.000000e+00
      1139  0.32415759 0.5098039 0.03921569 8.430220e-01
      1141 -0.29324749 0.4436090 0.02255639 1.806627e+00
      1145  3.19224325 0.5581395 0.03488372 2.808875e-01
      1150  3.10524264 0.6052632 0.02631579 6.645742e-02
      1151  5.54335130 0.6118421 0.03289474 5.819817e-03
      1153  5.07928700 0.5468750 0.07812500 4.532547e-01
      1155  5.05001502 0.6054422 0.05442177 1.056287e-02
      1156  4.00484984 0.5517241 0.04597701 3.345943e-01
      1157  2.54085805 0.6633663 0.01980198 1.024820e-03
      1158  2.96978254 0.5915493 0.04225352 2.911902e-02
      1159  9.77819860 0.6796117 0.03398058 2.525176e-07
      1164  6.43932685 0.7142857 0.00000000 8.568298e-05
      1168 11.29525042 0.6785714 0.04166667 3.672575e-06
      1169  8.15865744 0.6402439 0.03048780 3.281542e-04
      1171  4.88096273 0.5514019 0.04672897 2.875960e-01
      1173  9.24243121 0.7272727 0.02020202 6.106436e-06
      1174  5.26298772 0.7592593 0.03703704 1.387885e-04
      1175  4.23349284 0.6144578 0.04819277 3.702204e-02
      1176  7.09213013 0.7361111 0.05555556 6.151089e-05
      1178  2.90975724 0.5614035 0.01754386 3.538369e-01
      1179  3.38421116 0.6785714 0.01785714 7.526315e-03
      1180  5.50308212 0.6283186 0.04424779 6.370212e-03
      1183  4.94894070 0.6914894 0.02127660 2.047226e-04
      1184  7.80026337 0.6448598 0.07476636 2.727553e-03
      1185  3.97464150 0.5441176 0.05882353 4.668543e-01
      1186  4.15868191 0.5925926 0.06172840 9.558070e-02
      1191  7.64339918 0.6463415 0.03048780 1.781293e-04
      1192  4.02425708 0.5894040 0.05298013 2.800411e-02
      1193  1.37276420 0.4606742 0.02247191 1.541912e+00
      1194  5.98640539 0.6666667 0.04273504 3.114910e-04
      1195  4.30914005 0.6489362 0.05319149 3.877252e-03
      1196  5.69408865 0.6666667 0.03418803 3.114910e-04
      1197  6.19671953 0.6239316 0.03418803 7.339134e-03
      1202  1.53881908 0.5072464 0.04347826 9.041775e-01
      1203  4.26055439 0.6250000 0.04605263 2.054719e-03
      1207  4.79893676 0.6190476 0.06802721 3.892417e-03
      1208  2.38640296 0.5362319 0.05797101 5.472212e-01
      1209  4.72205843 0.6590909 0.03787879 2.565504e-04
      1210  3.73088261 0.6057692 0.04807692 3.098405e-02
      1211  8.46160296 0.6582915 0.03015075 7.971363e-06
      1214  3.08016101 0.5689655 0.08620690 2.935106e-01
      1216  5.94226530 0.6785714 0.01190476 1.063115e-03
      1219 11.29525042 0.6785714 0.04166667 3.672575e-06
      1221  8.33749245 0.6358974 0.03589744 1.474004e-04
      1223  3.46342098 0.5652174 0.02898551 2.785987e-01
      1225  6.47992246 0.6262626 0.04040404 1.198470e-02
      1226  3.97127308 0.6588235 0.03529412 3.405348e-03
      1228  8.21194982 0.7378641 0.05825243 1.378326e-06
      1230  3.10380205 0.5454545 0.02272727 3.937686e-01
      1231  3.21327589 0.5517241 0.02298851 3.345943e-01
      1232  3.51528040 0.5600000 0.05333333 2.986976e-01
      1235  4.89530743 0.6382979 0.04255319 7.325016e-03
      1236  4.63151898 0.5362319 0.05797101 5.472212e-01
      1237  5.10230667 0.6029412 0.07352941 8.955507e-02
      1238  2.92577521 0.5797101 0.07246377 1.854219e-01
      1243  7.24890778 0.6153846 0.03589744 1.270697e-03
      1244  4.23081749 0.5486726 0.05309735 3.007656e-01
      1245  1.66518080 0.5250000 0.04166667 5.838824e-01
      1246  4.16887860 0.5949367 0.03797468 9.148192e-02
      1247  1.31037043 0.5000000 0.07142857 1.000000e+00
      1248  3.73717619 0.5822785 0.03797468 1.435730e-01
      1249  2.89925600 0.5338346 0.03759398 4.351561e-01
      1254  1.16559774 0.5384615 0.00000000 5.351435e-01
      1255  2.91566650 0.5723684 0.04605263 7.435291e-02
      1259  2.09469438 0.5102041 0.06802721 8.045709e-01
      1260  1.67679668 0.4461538 0.01538462 1.614739e+00
      1261  2.43025790 0.5405405 0.04054054 3.239398e-01
      1262  1.23565226 0.5400000 0.03000000 4.237108e-01
      1263  7.63163726 0.6303318 0.02843602 1.528725e-04
      1266  4.06637381 0.6216216 0.05405405 3.639761e-02
      1268  3.00620774 0.5476190 0.02380952 3.827331e-01
      1270          NA        NA         NA           NA
      1271  8.15865744 0.6402439 0.03048780 3.281542e-04
      1272  8.33749245 0.6358974 0.03589744 1.474004e-04
      1275  1.38259625 0.5076923 0.01538462 9.012878e-01
      1277  5.03461674 0.5959596 0.05050505 5.618836e-02
      1278  3.39217969 0.5247525 0.02970297 6.188234e-01
      1280  4.85201302 0.5714286 0.05042017 1.191414e-01
      1282  3.28564910 0.5576923 0.01923077 2.393165e-01
      1283  2.69844225 0.5631068 0.02912621 2.002189e-01
      1284  3.74546497 0.6197183 0.02816901 4.364036e-02
      1287  2.83116566 0.5319149 0.04255319 5.360134e-01
      1288  4.22100243 0.6923077 0.01538462 1.929540e-03
      1289  4.62194842 0.7230769 0.03076923 3.218994e-04
      1290  2.47067399 0.5384615 0.03076923 5.351435e-01
      1295  6.61608590 0.5734597 0.02843602 3.283230e-02
      1296  2.12829512 0.5321101 0.03669725 5.025529e-01
      1297  1.66390716 0.4705882 0.03676471 1.507283e+00
      1298  2.55104947 0.5333333 0.01333333 5.637029e-01
      1299  2.22452285 0.6923077 0.03846154 5.545667e-03
      1300  2.53481071 0.5200000 0.01333333 7.290345e-01
      1303  3.31077605 0.5377778 0.02666667 2.570743e-01
      1321  2.06170989 0.5789474 0.05263158 2.332302e-01
      1322 -0.03592364 0.4666667 0.02666667 1.682689e+00
      1334  4.39625415 0.7093023 0.00000000 1.036095e-04
      1338  1.61551600 0.5180723 0.01204819 7.419344e-01
      1346  5.23962227 0.5972222 0.03240741 4.266725e-03
      1358  2.75741594 0.6447368 0.02631579 1.161689e-02
      1359  0.79597722 0.4905660 0.07547170 1.109254e+00
      1361  6.64646762 0.6000000 0.05217391 3.197196e-02
      1363  1.31148877 0.5344828 0.12068966 5.994263e-01
      1364  6.15012923 0.6781609 0.05747126 8.887985e-04
      1366  6.05108234 0.6222222 0.03703704 4.508698e-03
      1367  5.75094395 0.6614173 0.03149606 2.745910e-04
      1371  7.82593561 0.7019231 0.02884615 3.814478e-05
      1375  4.88096273 0.5514019 0.04672897 2.875960e-01
      1376  3.46342098 0.5652174 0.02898551 2.785987e-01
      1377  1.38259625 0.5076923 0.01538462 9.012878e-01
      1380  4.63893840 0.6363636 0.02597403 1.670340e-02
      1383  3.97299259 0.5937500 0.03906250 3.389485e-02
      1388  8.78214379 0.6723164 0.02259887 4.538979e-06
      1392 11.06834015 0.6627219 0.06508876 2.328935e-05
      1393  5.32849920 0.5588235 0.04411765 3.319755e-01
      1394  4.09896682 0.5802469 0.06172840 1.486140e-01
      1396  7.61278339 0.8000000 0.01428571 5.168220e-07
      1399  5.36417120 0.6153846 0.01538462 6.281185e-02
      1400  4.86550662 0.6516129 0.05161290 1.599237e-04
      1402  8.30191432 0.6666667 0.02824859 9.219564e-06
      1403  4.10328295 0.5576923 0.03846154 2.393165e-01
      1404  7.61690707 0.6779661 0.02259887 2.186559e-06
      1413  3.82436744 0.6896552 0.05172414 3.867869e-03
      1423  4.11736405 0.6867470 0.02409639 6.672544e-04
      1431  4.63893840 0.6363636 0.02597403 1.670340e-02
      1435  4.22567273 0.7115385 0.05769231 2.281937e-03
      1440  3.92252853 0.6265060 0.02409639 2.116380e-02
      1441          NA        NA         NA           NA
      1444  5.75165536 0.5507246 0.08695652 3.993957e-01
      1448  4.47557941 0.7105263 0.03947368 2.419328e-04
      1452  4.44424726 0.7454545 0.01818182 2.719197e-04
      1454  6.27513214 0.6867470 0.04819277 6.672544e-04
      1456  6.07653600 0.6867470 0.03614458 6.672544e-04
      1457  4.77429753 0.6162791 0.05813953 3.103252e-02
      1463  2.81031788 0.5757576 0.03030303 1.316680e-01
      1467  5.51878806 0.6516854 0.03370787 4.209845e-03
      1469  2.47668430 0.6060606 0.04040404 3.480848e-02
      1471  7.29524881 0.6767677 0.05050505 4.354152e-04
      1476  5.78551661 0.6190476 0.02380952 2.909633e-02
      1479  9.24243121 0.7272727 0.02020202 6.106436e-06
      1480  6.47992246 0.6262626 0.04040404 1.198470e-02
      1481  5.03461674 0.5959596 0.05050505 5.618836e-02
      1486  5.02129057 0.7037037 0.05555556 2.755077e-03
      1488 11.29181596 0.7638889 0.08333333 7.522468e-06
      1490  2.96638910 0.6315789 0.05263158 4.694473e-02
      1491  3.82604376 0.6964286 0.05357143 3.283461e-03
      1495  5.99741977 0.6382979 0.04255319 7.325016e-03
      1503  7.13261357 0.7070707 0.05050505 3.777967e-05
      1505  1.31644349 0.4831461 0.04494382 1.249515e+00
      1509  6.23943859 0.7073171 0.03252033 4.255128e-06
      1515  3.12518114 0.5740741 0.03703704 2.763029e-01
      1521  4.93486656 0.6422764 0.04065041 1.600346e-03
      1523  9.12366726 0.7235772 0.02439024 7.079026e-07
      1526  5.59267905 0.6770833 0.05208333 5.202443e-04
      1528  0.61714555 0.5740741 0.03703704 2.763029e-01
      1530  1.13087030 0.4788732 0.01408451 1.278185e+00
      1531  5.26298772 0.7592593 0.03703704 1.387885e-04
      1532  3.97127308 0.6588235 0.03529412 3.405348e-03
      1533  3.39217969 0.5247525 0.02970297 6.188234e-01
      1537  5.02129057 0.7037037 0.05555556 2.755077e-03
      1540  8.67846371 0.7647059 0.02521008 7.686149e-09
      1542 11.29607925 0.7479675 0.02439024 3.793935e-08
      1543  6.55239344 0.6829268 0.03252033 4.959798e-05
      1547  1.96460545 0.5925926 0.03703704 1.735682e-01
      1553  5.22283727 0.6984127 0.01587302 1.634360e-03
      1554  8.47387230 0.7246377 0.01449275 1.899946e-04
      1555  9.98475809 0.7154472 0.03252033 1.763015e-06
      1557  2.73374910 0.5365854 0.02439024 4.170771e-01
      1566  0.75308613 0.5769231 0.00000000 2.672575e-01
      1569  5.13638087 0.5963303 0.06422018 4.427951e-02
      1572  1.70141854 0.5555556 0.03174603 3.778216e-01
      1574  3.92118181 0.5945946 0.04504505 4.623607e-02
      1575  3.83440260 0.6310680 0.03883495 7.805044e-03
      1579  2.62363077 0.5949367 0.05063291 9.148192e-02
      1583  4.23349284 0.6144578 0.04819277 3.702204e-02
      1587  3.97299259 0.5937500 0.03906250 3.389485e-02
      1588  4.22567273 0.7115385 0.05769231 2.281937e-03
      1596  3.80786881 0.5781250 0.03125000 7.709987e-02
      1600  5.35829278 0.6015625 0.07812500 2.155627e-02
      1602  1.76493622 0.5789474 0.00000000 2.332302e-01
      1608  2.55961142 0.5625000 0.04687500 1.572992e-01
      1610  6.42164439 0.6328125 0.03125000 2.654029e-03
      1611  4.96925150 0.6666667 0.03225806 1.306490e-03
      1612  6.12603882 0.6250000 0.03125000 4.677735e-03
      1613  7.86749352 0.6642336 0.05839416 1.207446e-04
      1619  2.42096130 0.5694444 0.04166667 2.385928e-01
      1623  4.45880423 0.6612903 0.06451613 1.108517e-02
      1625  4.37525776 0.6569343 0.06569343 2.390279e-04
      1627  8.18953660 0.6861314 0.05109489 1.317224e-05
      1630  4.62048927 0.6195652 0.07608696 2.181012e-02
      1632  4.70454233 0.6111111 0.05555556 5.934644e-02
      1634  0.67751835 0.5223881 0.02985075 7.139858e-01
      1635  7.09213013 0.7361111 0.05555556 6.151089e-05
      1636  8.21194982 0.7378641 0.05825243 1.378326e-06
      1637  4.85201302 0.5714286 0.05042017 1.191414e-01
      1641 11.29181596 0.7638889 0.08333333 7.522468e-06
      1642  8.67846371 0.7647059 0.02521008 7.686149e-09
      1646  6.98401205 0.6803279 0.03278689 6.788685e-05
      1647  5.42590193 0.6363636 0.04132231 2.699796e-03
      1651  5.50798846 0.6666667 0.06944444 4.677735e-03
      1657  4.93925262 0.7457627 0.03389831 1.597009e-04
      1658  8.63849837 0.8307692 0.03076923 9.634097e-08
      1659  9.32784891 0.7080292 0.05839416 1.116894e-06
      1661  1.28856599 0.5182482 0.05839416 6.692491e-01
      1669  1.82161324 0.4765101 0.10067114 1.433668e+00
      1672  0.11097661 0.5098039 0.04901961 8.430220e-01
      1674  2.08136273 0.4725275 0.05494505 1.399821e+00
      1681  0.44355997 0.4909091 0.04545455 1.151233e+00
      1717  5.79740652 0.6369427 0.03184713 5.996479e-04
      1719  5.38463941 0.6275862 0.01379310 2.121439e-03
      1723  0.57397454 0.4912281 0.01754386 1.105374e+00
      1729  5.59216119 0.6114650 0.03184713 5.217262e-03
      1731  6.65972704 0.6293706 0.02797203 1.974140e-03
      1734  3.86295977 0.5537190 0.04958678 2.372779e-01
      1736  1.53146978 0.5438596 0.01754386 5.078006e-01
      1738  0.45429473 0.4680851 0.02127660 1.618529e+00
      1739  2.90975724 0.5614035 0.01754386 3.538369e-01
      1740  3.10380205 0.5454545 0.02272727 3.937686e-01
      1741  3.28564910 0.5576923 0.01923077 2.393165e-01
      1742  4.39625415 0.7093023 0.00000000 1.036095e-04
      1745  2.96638910 0.6315789 0.05263158 4.694473e-02
      1746 11.29607925 0.7479675 0.02439024 3.793935e-08
      1748  6.98401205 0.6803279 0.03278689 6.788685e-05
      1751  5.96947343 0.6217949 0.04487179 2.346726e-03
      1754  3.91895031 0.5797101 0.01449275 1.854219e-01
      1755  1.66171936 0.5087719 0.03508772 8.946258e-01
      1761  5.06451195 0.7313433 0.01492537 1.523221e-04
      1762 16.34543987 0.7526882 0.03225806 5.485390e-12
      1763  9.99493156 0.6942675 0.03821656 1.125453e-06
      1765  3.03282157 0.5585106 0.02659574 1.086006e-01
      1769  4.87595238 0.6089744 0.05128205 6.485308e-03
      1771  0.70943739 0.5084746 0.05084746 8.964170e-01
      1775  1.55150174 0.6250000 0.01785714 6.136883e-02
      1781  2.55185611 0.5384615 0.05128205 3.366684e-01
      1783  5.27627051 0.6267606 0.04225352 2.518974e-03
      1786  2.83967873 0.5702479 0.07438017 1.222364e-01
      1788  2.60640936 0.5357143 0.01785714 5.929801e-01
      1790  1.05809357 0.4705882 0.05882353 1.447547e+00
      1791  3.38421116 0.6785714 0.01785714 7.526315e-03
      1792  3.21327589 0.5517241 0.02298851 3.345943e-01
      1793  2.69844225 0.5631068 0.02912621 2.002189e-01
      1797  3.82604376 0.6964286 0.05357143 3.283461e-03
      1798  6.55239344 0.6829268 0.03252033 4.959798e-05
      1800  5.42590193 0.6363636 0.04132231 2.699796e-03
      1802  5.96947343 0.6217949 0.04487179 2.346726e-03
      1807  1.93040321 0.5535714 0.01785714 4.226781e-01
      1813  2.56937867 0.5970149 0.02985075 1.122405e-01
      1814  4.93168329 0.5800000 0.08000000 1.095986e-01
      1815  7.78116759 0.6987179 0.04487179 6.906563e-07
      1817  0.37463531 0.4807692 0.05128205 1.369046e+00
      1826  2.99345060 0.5921053 0.01315789 1.082937e-01
      1827  1.47107898 0.5254237 0.06779661 6.961175e-01
      1829  4.92482298 0.5565217 0.03478261 2.254143e-01
      1831  1.82002078 0.5312500 0.10937500 6.170751e-01
      1832  2.97302305 0.5287356 0.03448276 5.919197e-01
      1834  4.69696814 0.6028369 0.02127660 1.459642e-02
      1835  5.25715694 0.6090226 0.01503759 1.191611e-02
      1836  4.11487352 0.6666667 0.00000000 1.430588e-02
      1839  6.92748028 0.6861314 0.00729927 1.317224e-05
      1843  5.50308212 0.6283186 0.04424779 6.370212e-03
      1844  3.51528040 0.5600000 0.05333333 2.986976e-01
      1845  3.74546497 0.6197183 0.02816901 4.364036e-02
      1847  8.78214379 0.6723164 0.02259887 4.538979e-06
      1848  3.92252853 0.6265060 0.02409639 2.116380e-02
      1851  3.80786881 0.5781250 0.03125000 7.709987e-02
      1857  0.70660650 0.4605263 0.06578947 1.508703e+00
      1860 12.84417804 0.6627219 0.05325444 2.328935e-05
      1861  6.81861747 0.6470588 0.04411765 1.529337e-02
      1862  5.77533580 0.6543210 0.03703704 5.473204e-03
      1864  4.66715875 0.6213592 0.01941748 1.376558e-02
      1867  4.01195155 0.6197183 0.01408451 4.364036e-02
      1868  4.90503223 0.5714286 0.03726708 6.988521e-02
      1870  7.94553731 0.6435644 0.01485149 4.486826e-05
      1871  3.74426937 0.5480769 0.02884615 3.267996e-01
      1872  7.73628696 0.6485149 0.00990099 2.425902e-05
      1888  0.99710476 0.5161290 0.06451613 7.994954e-01
      1891  0.39000809 0.5595238 0.05952381 2.752335e-01
      1900          NA        NA         NA           NA
      1908  0.70660650 0.4605263 0.06578947 1.508703e+00
      1916  1.05546673 0.5714286 0.08333333 1.904303e-01
      1922  1.48831878 0.5483871 0.08064516 4.460595e-01
      1924  1.15098890 0.5483871 0.06451613 4.460595e-01
      1927  3.25559723 0.5542169 0.02409639 3.232122e-01
      1945  3.18892993 0.6140351 0.07017544 8.508907e-02
      1946  0.08098762 0.5180723 0.03614458 7.419344e-01
      1950  1.61551600 0.5180723 0.01204819 7.419344e-01
      1958  3.91895031 0.5797101 0.01449275 1.854219e-01
      1970  4.93940375 0.6867470 0.02409639 6.672544e-04
      1977  4.19432051 0.6279070 0.04651163 1.767673e-02
      1983  2.99662212 0.6063830 0.03191489 3.912760e-02
      1987  3.29493506 0.5595238 0.03571429 2.752335e-01
      1989  5.42803973 0.7127660 0.04255319 3.696329e-05
      1991  3.82917418 0.5851064 0.05319149 9.888691e-02
      1996  4.98520562 0.6547619 0.01190476 4.556350e-03
      1999  4.94894070 0.6914894 0.02127660 2.047226e-04
      2000  4.89530743 0.6382979 0.04255319 7.325016e-03
      2001  2.83116566 0.5319149 0.04255319 5.360134e-01
      2005  5.99741977 0.6382979 0.04255319 7.325016e-03
      2006  1.96460545 0.5925926 0.03703704 1.735682e-01
      2008  5.50798846 0.6666667 0.06944444 4.677735e-03
      2010  1.66171936 0.5087719 0.03508772 8.946258e-01
      2011  1.93040321 0.5535714 0.01785714 4.226781e-01
      2023  6.00845882 0.7127660 0.05319149 3.696329e-05
      2025  0.84701769 0.5280899 0.03370787 5.961127e-01
      2034  3.08612890 0.5921053 0.02631579 1.082937e-01
      2035  1.89697919 0.5660377 0.03773585 3.362888e-01
      2037  7.99626189 0.5565217 0.09565217 2.254143e-01
      2039  1.26168213 0.5862069 0.12068966 1.891613e-01
      2040  4.97162031 0.5287356 0.05747126 5.919197e-01
      2042  7.27707678 0.6074074 0.06666667 1.256300e-02
      2043  8.41715072 0.6535433 0.06299213 5.387921e-04
      2047  5.28962289 0.6354167 0.07291667 7.963489e-03
      2051  7.80026337 0.6448598 0.07476636 2.727553e-03
      2052  4.63151898 0.5362319 0.05797101 5.472212e-01
      2053  4.22100243 0.6923077 0.01538462 1.929540e-03
      2055 11.06834015 0.6627219 0.06508876 2.328935e-05
      2056  5.75165536 0.5507246 0.08695652 3.993957e-01
      2059  5.35829278 0.6015625 0.07812500 2.155627e-02
      2064 12.84417804 0.6627219 0.05325444 2.328935e-05
      2069  8.38214417 0.7058824 0.04411765 6.850369e-04
      2070  9.04522998 0.7037037 0.04938272 2.457328e-04
      2072  4.67475147 0.6129032 0.08064516 7.540356e-02
      2075  7.13605209 0.6307692 0.01538462 3.497994e-02
      2076  6.97566701 0.6258065 0.08387097 1.732917e-03
      2078 11.26448891 0.6745562 0.05325444 5.666613e-06
      2079  5.35567611 0.6250000 0.07692308 1.078745e-02
      2080 10.37644692 0.6686391 0.05325444 1.161909e-05
      2086  2.10489289 0.5441176 0.02941176 4.668543e-01
      2087  1.34151163 0.4716981 0.07547170 1.319720e+00
      2091  1.84687170 0.5689655 0.13793103 2.935106e-01
      2092  2.65896942 0.5000000 0.04411765 1.000000e+00
      2094  3.16643228 0.5441176 0.04411765 4.668543e-01
      2095  7.13896237 0.6029412 0.02941176 8.955507e-02
      2103  3.97464150 0.5441176 0.05882353 4.668543e-01
      2104  5.10230667 0.6029412 0.07352941 8.955507e-02
      2105  4.62194842 0.7230769 0.03076923 3.218994e-04
      2107  5.32849920 0.5588235 0.04411765 3.319755e-01
      2116  6.81861747 0.6470588 0.04411765 1.529337e-02
      2120  8.38214417 0.7058824 0.04411765 6.850369e-04
      2122  2.99846415 0.5735294 0.05882353 2.252529e-01
      2127  3.57126546 0.6307692 0.03076923 3.497994e-02
      2128  3.37867319 0.5441176 0.05882353 4.668543e-01
      2130  4.81038669 0.5735294 0.02941176 2.252529e-01
      2131  2.10446437 0.5818182 0.07272727 2.249159e-01
      2132  3.99272718 0.5588235 0.02941176 3.319755e-01
      2138  1.58034033 0.5921053 0.02631579 1.082937e-01
      2139  1.35285919 0.4905660 0.09433962 1.109254e+00
      2143  0.58542752 0.5000000 0.13793103 1.000000e+00
      2144  2.68470795 0.5925926 0.03703704 9.558070e-02
      2146  5.30982767 0.7160494 0.03703704 1.007042e-04
      2147  5.17090062 0.6419753 0.02469136 1.060184e-02
      2155  4.15868191 0.5925926 0.06172840 9.558070e-02
      2156  2.92577521 0.5797101 0.07246377 1.854219e-01
      2157  2.47067399 0.5384615 0.03076923 5.351435e-01
      2159  4.09896682 0.5802469 0.06172840 1.486140e-01
      2163  1.76493622 0.5789474 0.00000000 2.332302e-01
      2168  5.77533580 0.6543210 0.03703704 5.473204e-03
      2172  9.04522998 0.7037037 0.04938272 2.457328e-04
      2173  2.99846415 0.5735294 0.05882353 2.252529e-01
      2179  6.67889026 0.6153846 0.03076923 6.281185e-02
      2180  3.16842463 0.5802469 0.02469136 1.486140e-01
      2182  6.90868439 0.6790123 0.02469136 1.272004e-03
      2183  2.47022878 0.5588235 0.02941176 3.319755e-01
      2184  5.94752395 0.6666667 0.02469136 2.699796e-03
      2245  4.22976500 0.6666667 0.05882353 1.729028e-02
      2252  4.53607556 0.6219512 0.03658537 2.720035e-02
      2255  6.53843979 0.7045455 0.02272727 2.600383e-06
      2263  7.61278339 0.8000000 0.01428571 5.168220e-07
      2264  4.47557941 0.7105263 0.03947368 2.419328e-04
      2272  4.66715875 0.6213592 0.01941748 1.376558e-02
      2273  1.05546673 0.5714286 0.08333333 1.904303e-01
      2276  4.67475147 0.6129032 0.08064516 7.540356e-02
      2286  6.48787418 0.7303371 0.02247191 1.386481e-05
      2288  6.34938743 0.7303371 0.02247191 1.386481e-05
      2289  4.56882160 0.6417910 0.04477612 2.027500e-02
      2301  3.81714110 0.6119403 0.04477612 6.687076e-02
      2303  3.26592239 0.6268657 0.01492537 3.781258e-02
      2306  3.42926753 0.5522388 0.04477612 3.924481e-01
      2310 -0.09310271 0.4925373 0.02985075 1.097235e+00
      2318  5.22283727 0.6984127 0.01587302 1.634360e-03
      2320  4.93925262 0.7457627 0.03389831 1.597009e-04
      2322  5.06451195 0.7313433 0.01492537 1.523221e-04
      2323  2.56937867 0.5970149 0.02985075 1.122405e-01
      2334  4.76682129 0.6567164 0.04477612 1.030099e-02
      2335  4.24191462 0.6417910 0.01492537 2.027500e-02
      2337  0.36123749 0.5522388 0.02985075 3.924481e-01
      2341  6.28155102 0.7000000 0.04000000 6.334248e-05
      2343 10.02441978 0.6327273 0.05090909 1.072251e-05
      2353  5.76071481 0.6700000 0.06000000 6.738585e-04
      2355  8.30115022 0.7674419 0.04651163 7.038165e-07
      2358  3.14443581 0.6276596 0.06382979 1.330829e-02
      2361  3.21746721 0.7017544 0.07017544 2.315807e-03
      2362  1.09898027 0.5000000 0.05379747 1.000000e+00
      2366  5.23962227 0.5972222 0.03240741 4.266725e-03
      2370  8.47387230 0.7246377 0.01449275 1.899946e-04
      2372  8.63849837 0.8307692 0.03076923 9.634097e-08
      2374 16.34543987 0.7526882 0.03225806 5.485390e-12
      2375  4.93168329 0.5800000 0.08000000 1.095986e-01
      2378  4.93940375 0.6867470 0.02409639 6.672544e-04
      2385  4.76682129 0.6567164 0.04477612 1.030099e-02
      2387  8.25316057 0.7300000 0.06000000 4.224909e-06
      2389  1.94351614 0.5572519 0.03816794 1.900078e-01
      2393  7.01318469 0.6559140 0.05376344 2.111459e-05
      2395  1.36844501 0.5254237 0.03389831 6.961175e-01
      2398  1.72881554 0.6000000 0.00000000 1.068637e-01
      2399  4.06726031 0.6118421 0.04605263 5.819817e-03
      2403  3.24055667 0.5986395 0.06802721 1.676234e-02
      2404  2.87865561 0.5384615 0.01538462 5.351435e-01
      2405  4.50347702 0.6169154 0.04477612 9.160235e-04
      2406  5.20372019 0.6200000 0.01000000 1.639507e-02
      2407 11.06237782 0.6720000 0.03200000 5.354511e-08
      2410  4.62747357 0.6611570 0.04958678 3.919366e-04
      2412  4.99537725 0.6666667 0.03571429 2.250227e-03
      2414  0.32415759 0.5098039 0.03921569 8.430220e-01
      2415  7.64339918 0.6463415 0.03048780 1.781293e-04
      2416  7.24890778 0.6153846 0.03589744 1.270697e-03
      2417  6.61608590 0.5734597 0.02843602 3.283230e-02
      2419  5.36417120 0.6153846 0.01538462 6.281185e-02
      2421  7.13261357 0.7070707 0.05050505 3.777967e-05
      2422  9.98475809 0.7154472 0.03252033 1.763015e-06
      2424  9.32784891 0.7080292 0.05839416 1.116894e-06
      2426  9.99493156 0.6942675 0.03821656 1.125453e-06
      2427  7.78116759 0.6987179 0.04487179 6.906563e-07
      2428  4.01195155 0.6197183 0.01408451 4.364036e-02
      2431  6.00845882 0.7127660 0.05319149 3.696329e-05
      2432  7.13605209 0.6307692 0.01538462 3.497994e-02
      2433  3.57126546 0.6307692 0.03076923 3.497994e-02
      2434  6.67889026 0.6153846 0.03076923 6.281185e-02
      2437  4.24191462 0.6417910 0.01492537 2.027500e-02
      2438  8.25316057 0.7300000 0.06000000 4.224909e-06
      2440  5.16212810 0.6330275 0.02752294 5.474577e-03
      2441  3.00866645 0.5502646 0.04232804 1.669574e-01
      2442  4.16069911 0.6666667 0.00000000 3.892417e-03
      2443  1.91373461 0.5000000 0.03846154 1.000000e+00
      2444  3.31728541 0.6533333 0.00000000 7.911789e-03
      2450  2.92336703 0.6842105 0.02631579 1.318969e-03
      2451  1.89292623 0.6288660 0.06185567 1.113716e-02
      2453  3.59733880 0.6339286 0.06250000 4.586392e-03
      2455  2.51243934 0.6274510 0.07843137 1.004189e-02
      2456  2.95773197 0.5057471 0.04597701 9.146214e-01
      2458  6.16893514 0.6411765 0.03529412 2.319277e-04
      2459  3.12233393 0.5438596 0.04093567 2.513491e-01
      2463  3.77797831 0.6585366 0.04878049 4.088913e-03
      2467  4.02425708 0.5894040 0.05298013 2.800411e-02
      2468  4.23081749 0.5486726 0.05309735 3.007656e-01
      2469  2.12829512 0.5321101 0.03669725 5.025529e-01
      2471  4.86550662 0.6516129 0.05161290 1.599237e-04
      2472  4.44424726 0.7454545 0.01818182 2.719197e-04
      2475  2.55961142 0.5625000 0.04687500 1.572992e-01
      2480  4.90503223 0.5714286 0.03726708 6.988521e-02
      2484  6.97566701 0.6258065 0.08387097 1.732917e-03
      2485  3.37867319 0.5441176 0.05882353 4.668543e-01
      2486  3.16842463 0.5802469 0.02469136 1.486140e-01
      2491  5.16212810 0.6330275 0.02752294 5.474577e-03
      2494  4.55198946 0.6363636 0.03636364 4.596261e-04
      2495  1.34523880 0.5673077 0.04807692 1.698105e-01
      2496  3.79767562 0.6303030 0.03636364 8.153061e-04
      2497  0.87259576 0.5322581 0.04301075 3.789229e-01
      2499  2.35965627 0.6000000 0.00000000 5.777957e-02
      2503  1.01853026 0.4382022 0.03370787 1.756385e+00
      2507  0.47957563 0.4683544 0.03797468 1.426255e+00
      2509  2.11895961 0.5343915 0.03703704 3.443471e-01
      2511  3.72116924 0.6228571 0.04000000 1.152045e-03
      2514  2.01162795 0.5123967 0.04958678 7.850629e-01
      2516 -0.80020938 0.4880952 0.02380952 1.172741e+00
      2518 -0.29324749 0.4436090 0.02255639 1.806627e+00
      2519  1.37276420 0.4606742 0.02247191 1.541912e+00
      2520  1.66518080 0.5250000 0.04166667 5.838824e-01
      2521  1.66390716 0.4705882 0.03676471 1.507283e+00
      2525  1.31644349 0.4831461 0.04494382 1.249515e+00
      2526  2.73374910 0.5365854 0.02439024 4.170771e-01
      2528  1.28856599 0.5182482 0.05839416 6.692491e-01
      2530  3.03282157 0.5585106 0.02659574 1.086006e-01
      2531  0.37463531 0.4807692 0.05128205 1.369046e+00
      2535  0.84701769 0.5280899 0.03370787 5.961127e-01
      2541  0.36123749 0.5522388 0.02985075 3.924481e-01
      2542  1.94351614 0.5572519 0.03816794 1.900078e-01
      2543  3.00866645 0.5502646 0.04232804 1.669574e-01
      2554  1.96199700 0.5789474 0.00000000 1.686686e-01
      2555  2.10995993 0.6190476 0.04761905 5.878172e-02
      2557  6.44672611 0.6521739 0.04347826 1.099416e-03
      2559  2.02544221 0.6029412 0.08823529 8.955507e-02
      2560  1.38501707 0.5057471 0.02298851 9.146214e-01
      2562  5.28961625 0.6413793 0.02068966 6.619685e-04
      2563  6.74920035 0.7153285 0.01459854 4.638074e-07
      2567  4.89838960 0.5934959 0.02439024 3.809416e-02
      2571  5.98640539 0.6666667 0.04273504 3.114910e-04
      2572  4.16887860 0.5949367 0.03797468 9.148192e-02
      2573  2.55104947 0.5333333 0.01333333 5.637029e-01
      2575  8.30191432 0.6666667 0.02824859 9.219564e-06
      2576  6.27513214 0.6867470 0.04819277 6.672544e-04
      2579  6.42164439 0.6328125 0.03125000 2.654029e-03
      2584  7.94553731 0.6435644 0.01485149 4.486826e-05
      2585  1.48831878 0.5483871 0.08064516 4.460595e-01
      2588 11.26448891 0.6745562 0.05325444 5.666613e-06
      2589  4.81038669 0.5735294 0.02941176 2.252529e-01
      2590  6.90868439 0.6790123 0.02469136 1.272004e-03
      2592  6.48787418 0.7303371 0.02247191 1.386481e-05
      2595  4.16069911 0.6666667 0.00000000 3.892417e-03
      2596  4.55198946 0.6363636 0.03636364 4.596261e-04
      2599  4.97701917 0.6346154 0.02884615 6.039559e-03
      2600 56.08987166 0.9805825 0.01456311 0.000000e+00
      2606 -0.92107103 0.5396825 0.03174603 5.287333e-01
      2609  6.14634665 0.5945946 0.04054054 1.036380e-01
      2612  2.22064098 0.5675676 0.05405405 2.450420e-01
      2614  3.75738021 0.5769231 0.03846154 1.166645e-01
      2615  3.45472966 0.6730769 0.01923077 4.154176e-04
      2623  4.30914005 0.6489362 0.05319149 3.877252e-03
      2624  1.31037043 0.5000000 0.07142857 1.000000e+00
      2625  2.22452285 0.6923077 0.03846154 5.545667e-03
      2627  4.10328295 0.5576923 0.03846154 2.393165e-01
      2631  4.96925150 0.6666667 0.03225806 1.306490e-03
      2636  3.74426937 0.5480769 0.02884615 3.267996e-01
      2640  5.35567611 0.6250000 0.07692308 1.078745e-02
      2641  2.10446437 0.5818182 0.07272727 2.249159e-01
      2642  2.47022878 0.5588235 0.02941176 3.319755e-01
      2647  1.91373461 0.5000000 0.03846154 1.000000e+00
      2648  1.34523880 0.5673077 0.04807692 1.698105e-01
      2650  4.97701917 0.6346154 0.02884615 6.039559e-03
      2652  5.23617425 0.6538462 0.02884615 1.701872e-03
      2658  1.52750505 0.5657895 0.00000000 2.513491e-01
      2659  1.95779314 0.6031746 0.04761905 1.014538e-01
      2661  6.49026050 0.6434783 0.04347826 2.089089e-03
      2663  1.83247594 0.5882353 0.08823529 1.456101e-01
      2664  0.73355882 0.5172414 0.02298851 7.477302e-01
      2666  4.93827875 0.6275862 0.02068966 2.121439e-03
      2667  5.69677517 0.7153285 0.01459854 4.638074e-07
      2671  5.04574004 0.6016260 0.01626016 2.418522e-02
      2675  5.69408865 0.6666667 0.03418803 3.114910e-04
      2676  3.73717619 0.5822785 0.03797468 1.435730e-01
      2677  2.53481071 0.5200000 0.01333333 7.290345e-01
      2679  7.61690707 0.6779661 0.02259887 2.186559e-06
      2680  6.07653600 0.6867470 0.03614458 6.672544e-04
      2683  6.12603882 0.6250000 0.03125000 4.677735e-03
      2688  7.73628696 0.6485149 0.00990099 2.425902e-05
      2689  1.15098890 0.5483871 0.06451613 4.460595e-01
      2692 10.37644692 0.6686391 0.05325444 1.161909e-05
      2693  3.99272718 0.5588235 0.02941176 3.319755e-01
      2694  5.94752395 0.6666667 0.02469136 2.699796e-03
      2696  6.34938743 0.7303371 0.02247191 1.386481e-05
      2699  3.31728541 0.6533333 0.00000000 7.911789e-03
      2700  3.79767562 0.6303030 0.03636364 8.153061e-04
      2702 56.08987166 0.9805825 0.01456311 0.000000e+00
      2703  5.23617425 0.6538462 0.02884615 1.701872e-03

---

    Code
      sim_table(hol_rom, hol_rom)
    Output
              series_a    series_b overlap            r        r_hol            t
      3      HOL_AAHOH   HOL_BDN2H      60  0.188406859  0.445023059  1.473570629
      7      HOL_AAHOH   HOL_BRBRH      87 -0.092025539  0.243008720 -0.857046488
      11     HOL_AAHOH   HOL_GKZBH      77  0.137326483  0.278197844  1.208635328
      13     HOL_AAHOH   HOL_IRRBH     187  0.493596957  0.393506269  7.740412083
      15     HOL_AAHOH   HOL_KBMBH     173  0.295691657  0.414522592  4.059485995
      18     HOL_AAHOH   HOL_KMBQH     122  0.321154212  0.591621699  3.730301947
      20     HOL_AAHOH   HOL_KORHH      85  0.050560394  0.288676503  0.463987099
      22     HOL_AAHOH   HOL_LATEH     103  0.298520123  0.201482556  3.158942695
      23     HOL_AAHOH   HOL_LKBBH      87  0.024049799  0.327189504  0.223093191
      24     HOL_AAHOH   HOL_LKSBH     118  0.302268769  0.498699727  3.429981790
      25     HOL_AAHOH   HOL_LKSHH     134  0.371330048  0.244677604  4.612151513
      29     HOL_AAHOH   HOL_MBRUH      87  0.065309029  0.459845937  0.606946798
      30     HOL_AAHOH   HOL_MBUFH     124  0.449018896  0.491842675  5.573291986
      32     HOL_AAHOH   HOL_MRBRH     138  0.303797212  0.559263260  3.732253762
      34     HOL_AAHOH   HOL_PALZH     158  0.306343579  0.421020482  4.032345115
      35     HOL_AAHOH   HOL_SQUSH     157  0.347714888  0.364675149  4.631992406
      39     HOL_AAHOH  HOL_TMB11H      87  0.441421672  0.414098997  4.562105380
      45     HOL_AAHOH   HOL_TRPBH      68  0.356284712  0.490183811  3.121132771
      46     HOL_AAHOH   HOL_TRRBH     101  0.158422177  0.533836233  1.604484047
      47     HOL_AAHOH   HOL_TRRSH     187  0.332296592  0.458285337  4.804963625
      49     HOL_AAHOH   HOL_UNLUH     187 -0.031712669  0.064022899 -0.432720785
      105    HOL_BDN2H   HOL_AAHOH      60  0.188406859  0.445023059  1.473570629
      117    HOL_BDN2H   HOL_IRRBH      60  0.581057202  0.596238067  5.483953185
      122    HOL_BDN2H   HOL_KMBQH      54  0.138911744  0.213496197  1.021193475
      125    HOL_BDN2H   HOL_LAGEH      58  0.433764001  0.341440542  3.634572700
      126    HOL_BDN2H   HOL_LATEH     326  0.475777446  0.081137615  9.751630705
      130    HOL_BDN2H   HOL_MANCH     226  0.121782161  0.215989030  1.840431010
      138    HOL_BDN2H   HOL_PALZH     146  0.127156008  0.409393249  1.543691654
      139    HOL_BDN2H   HOL_SQUSH      60  0.218914148  0.092752129  1.723311918
      142    HOL_BDN2H   HOL_TITEH      84  0.283233492  0.338320042  2.690555518
      150    HOL_BDN2H   HOL_TRRBH     276  0.252126581  0.518011876  4.320627392
      151    HOL_BDN2H   HOL_TRRSH      60  0.435542796  0.176853289  3.716492486
      153    HOL_BDN2H   HOL_UNLUH      91  0.064324801  0.242647987  0.611505061
      161    HOL_BENGH   HOL_BERLH      59  0.303932199  0.185960846  2.429614840
      164    HOL_BENGH   HOL_BROIH      69  0.489170203  0.271041933  4.624919424
      173    HOL_BENGH   HOL_KKNAH      69  0.282119113  0.225799744  2.424915353
      175    HOL_BENGH   HOL_KORBH      63  0.665527356  0.315735142  7.021106644
      212    HOL_BERLH   HOL_BENGH      59  0.303932199  0.185960846  2.429614840
      216    HOL_BERLH   HOL_BROIH     220  0.719781537  0.176768041 15.343970174
      218    HOL_BERLH   HOL_ERP1H      93  0.450376684  0.050316658  4.838345011
      225    HOL_BERLH   HOL_KKNAH     228  0.648796646  0.304733827 12.845725876
      227    HOL_BERLH   HOL_KORBH      53  0.606828824  0.179090988  5.505442498
      241    HOL_BERLH   HOL_OB2BH     150  0.491688025  0.148084800  6.892528861
      267    HOL_BICKH   HOL_BRBRH      54  0.470995986  0.250731594  3.887048085
      271    HOL_BICKH   HOL_GKZBH      59  0.038772914  0.445440499  0.295507924
      272    HOL_BICKH   HOL_GUSTH      77  0.391801212  0.397332816  3.712454943
      274    HOL_BICKH   HOL_K9SAH      77 -0.079101900  0.095084116 -0.691761992
      275    HOL_BICKH   HOL_KBMBH      77  0.205125340  0.295696702  1.827093086
      283    HOL_BICKH   HOL_LKBBH      77  0.490403004  0.337521326  4.905628195
      284    HOL_BICKH   HOL_LKSBH      70  0.184627117  0.183442546  1.560454341
      285    HOL_BICKH   HOL_LKSHH      66  0.159042134  0.144177426  1.298769679
      287    HOL_BICKH  HOL_MB253H      77  0.367288301  0.303391543  3.442555185
      291    HOL_BICKH   HOL_MIWAH      53  0.026932105  0.104871658  0.194280644
      296    HOL_BICKH   HOL_TATEH      77  0.133636892  0.326688577  1.175563790
      300    HOL_BICKH  HOL_TMB12H      77  0.325425741  0.335678517  3.000309909
      301    HOL_BICKH  HOL_TMB21H      69  0.308309538  0.249050794  2.672577261
      302    HOL_BICKH  HOL_TMB22H      77  0.335960060  0.179517522  3.109571940
      307    HOL_BICKH   HOL_TRRSH      66  0.099903053  0.211226084  0.809493917
      308    HOL_BICKH   HOL_TWMLH      77  0.330742957  0.319830826  3.055299845
      310    HOL_BICKH   HOL_WEDEH      77  0.334837187  0.220952568  3.097864025
      311    HOL_BICKH   HOL_WEDGH      64  0.327289636 -0.116183942  2.749195457
      312    HOL_BICKH   HOL_WEDWH      77  0.308287116  0.173699858  2.825190294
      313    HOL_BRBRH   HOL_AAHOH      87 -0.092025539  0.243008720 -0.857046488
      318    HOL_BRBRH   HOL_BICKH      54  0.470995986  0.250731594  3.887048085
      323    HOL_BRBRH   HOL_GKZBH     143  0.304436243  0.316285251  3.808558446
      324    HOL_BRBRH   HOL_GUSTH      54  0.556559087  0.201123572  4.876952521
      325    HOL_BRBRH   HOL_IRRBH     102  0.123024561  0.115560935  1.245845442
      326    HOL_BRBRH   HOL_K9SAH      89 -0.032851634  0.195837658 -0.308342079
      327    HOL_BRBRH   HOL_KBMBH     153 -0.047533196  0.223174924 -0.586691758
      332    HOL_BRBRH   HOL_KORHH      85  0.392176452  0.198172039  3.907376443
      335    HOL_BRBRH   HOL_LKBBH     153  0.514217918  0.411207086  7.391865616
      336    HOL_BRBRH   HOL_LKSBH     153  0.557418690  0.327587355  8.277593492
      337    HOL_BRBRH   HOL_LKSHH     153  0.540711818  0.230863880  7.924727054
      339    HOL_BRBRH  HOL_MB253H      54  0.324974883  0.109715802  2.501634983
      341    HOL_BRBRH   HOL_MBRUH     100  0.287621312  0.273093775  2.988058682
      342    HOL_BRBRH   HOL_MBUFH      55  0.378409478  0.394466702  3.004122017
      344    HOL_BRBRH   HOL_MRBRH      73  0.299089892  0.276143408  2.659605495
      346    HOL_BRBRH   HOL_PALZH      58  0.381600162  0.076475951  3.116880179
      347    HOL_BRBRH   HOL_SQUSH      57  0.238618861  0.204771374  1.838776227
      348    HOL_BRBRH   HOL_TATEH      60  0.230664609  0.189656344  1.820871338
      351    HOL_BRBRH  HOL_TMB11H      95  0.094108502  0.296739269  0.916483180
      352    HOL_BRBRH  HOL_TMB12H      54  0.127818031  0.254408087  0.938224974
      353    HOL_BRBRH  HOL_TMB21H      54  0.141560682  0.182896209  1.041061243
      354    HOL_BRBRH  HOL_TMB22H      54  0.621466404  0.184390902  5.774965560
      359    HOL_BRBRH   HOL_TRRSH     153 -0.037596570  0.314223987 -0.463849589
      360    HOL_BRBRH   HOL_TWMLH      98  0.488033063  0.189688375  5.506908557
      361    HOL_BRBRH   HOL_UNLUH      90  0.234093805  0.107941312  2.271553900
      362    HOL_BRBRH   HOL_WEDEH      64  0.274358628  0.258833452  2.264550695
      364    HOL_BRBRH   HOL_WEDWH      64  0.225918357  0.241293227  1.840761985
      368    HOL_BROIH   HOL_BENGH      69  0.489170203  0.271041933  4.624919424
      369    HOL_BROIH   HOL_BERLH     220  0.719781537  0.176768041 15.343970174
      374    HOL_BROIH   HOL_ERP1H      93  0.483247297 -0.112654333  5.294380935
      381    HOL_BROIH   HOL_KKNAH     231  0.729106542  0.309125970 16.156406698
      383    HOL_BROIH   HOL_KORBH      70  0.734831416  0.432936730  8.999587148
      397    HOL_BROIH   HOL_OB2BH     103  0.272484254  0.011041913  2.860184764
      430    HOL_DHROH   HOL_K9SAH      93 -0.026333217  0.435453467 -0.252666963
      431    HOL_DHROH   HOL_KBMBH      85  0.370625080  0.493546818  3.657298386
      435    HOL_DHROH   HOL_KORBH      86  0.079789205  0.255727290  0.737972961
      439    HOL_DHROH   HOL_LKBBH      65  0.557982768  0.539011875  5.379102857
      443    HOL_DHROH  HOL_MB253H     116 -0.084985667  0.528471099 -0.914678896
      444    HOL_DHROH  HOL_MB259H      59  0.288547531  0.451881863  2.295134768
      447    HOL_DHROH   HOL_MIWAH     110  0.568889048  0.443083941  7.221878507
      452    HOL_DHROH   HOL_TATEH     116  0.245609153  0.418843672  2.717092141
      456    HOL_DHROH  HOL_TMB12H     116  0.706576038  0.599445863 10.707725167
      460    HOL_DHROH HOL_TRMB32H      52  0.189234193  0.513346278  1.376268897
      464    HOL_DHROH   HOL_TWMLH     113  0.301798507  0.323127643  3.350146719
      466    HOL_DHROH   HOL_WEDEH     116  0.386904490  0.516880163  4.499511282
      467    HOL_DHROH   HOL_WEDGH      75  0.620845102  0.583970783  6.812711955
      468    HOL_DHROH   HOL_WEDWH     116  0.394374162  0.519431179  4.602200268
      473    HOL_ERP1H   HOL_BERLH      93  0.450376684  0.050316658  4.838345011
      476    HOL_ERP1H   HOL_BROIH      93  0.483247297 -0.112654333  5.294380935
      485    HOL_ERP1H   HOL_KKNAH      93  0.153494282 -0.025617359  1.489921700
      501    HOL_ERP1H   HOL_OB2BH      92  0.527554510  0.214297986  5.923983276
      521    HOL_GKZBH   HOL_AAHOH      77  0.137326483  0.278197844  1.208635328
      526    HOL_GKZBH   HOL_BICKH      59  0.038772914  0.445440499  0.295507924
      527    HOL_GKZBH   HOL_BRBRH     143  0.304436243  0.316285251  3.808558446
      532    HOL_GKZBH   HOL_GUSTH      59  0.056879061  0.468344028  0.433880442
      533    HOL_GKZBH   HOL_IRRBH      92  0.045835787  0.316290805  0.437705578
      534    HOL_GKZBH   HOL_K9SAH      94 -0.013513101 -0.037757006 -0.130327531
      535    HOL_GKZBH   HOL_KBMBH     148  0.004404887  0.305523062  0.053406940
      540    HOL_GKZBH   HOL_KORHH      75  0.015126348  0.539912486  0.130136657
      543    HOL_GKZBH   HOL_LKBBH     148  0.592894958  0.385617958  8.926672777
      544    HOL_GKZBH   HOL_LKSBH     148  0.595772324  0.369116446  8.993743674
      545    HOL_GKZBH   HOL_LKSHH     148  0.280937674  0.170810453  3.549125713
      547    HOL_GKZBH  HOL_MB253H      59  0.093307054  0.171147887  0.713719034
      549    HOL_GKZBH   HOL_MBRUH      90  0.307503904  0.507064623  3.048705508
      552    HOL_GKZBH   HOL_MRBRH      63  0.308367588  0.495787214  2.552478026
      556    HOL_GKZBH   HOL_TATEH      65  0.328003333  0.223500616  2.777698486
      559    HOL_GKZBH  HOL_TMB11H      85  0.000173664  0.340106128  0.001591657
      560    HOL_GKZBH  HOL_TMB12H      59  0.206204548  0.164828147  1.604898066
      561    HOL_GKZBH  HOL_TMB21H      59 -0.063652080  0.237617788 -0.485744818
      562    HOL_GKZBH  HOL_TMB22H      59 -0.109329770  0.077309696 -0.837652001
      567    HOL_GKZBH   HOL_TRRSH     148 -0.188090442  0.259036387 -2.321917665
      568    HOL_GKZBH   HOL_TWMLH     103  0.183764564  0.242532939  1.888084658
      569    HOL_GKZBH   HOL_UNLUH      80  0.086962224  0.054221366  0.775876473
      570    HOL_GKZBH   HOL_WEDEH      69  0.156149106  0.240202586  1.303629490
      572    HOL_GKZBH   HOL_WEDWH      69  0.123656717  0.218464883  1.027586074
      578    HOL_GUSTH   HOL_BICKH      77  0.391801212  0.397332816  3.712454943
      579    HOL_GUSTH   HOL_BRBRH      54  0.556559087  0.201123572  4.876952521
      583    HOL_GUSTH   HOL_GKZBH      59  0.056879061  0.468344028  0.433880442
      586    HOL_GUSTH   HOL_K9SAH      88  0.145345889  0.229675843  1.370246981
      587    HOL_GUSTH   HOL_KBMBH      88  0.245883024  0.369449586  2.366084114
      595    HOL_GUSTH   HOL_LKBBH      88  0.421581798  0.396463781  4.336452319
      596    HOL_GUSTH   HOL_LKSBH      70  0.387944916  0.277987333  3.496336630
      597    HOL_GUSTH   HOL_LKSHH      66  0.228060287  0.205141873  1.888447034
      599    HOL_GUSTH  HOL_MB253H      88  0.195674878  0.552690080  1.861111225
      603    HOL_GUSTH   HOL_MIWAH      64  0.486231851  0.211205939  4.416587185
      608    HOL_GUSTH   HOL_TATEH      88  0.310066749  0.305284742  3.042037561
      612    HOL_GUSTH  HOL_TMB12H      88  0.424427059  0.472487999  4.372123277
      613    HOL_GUSTH  HOL_TMB21H      69  0.125643831  0.308952578  1.044361703
      614    HOL_GUSTH  HOL_TMB22H      82  0.679291680  0.287488012  8.330683272
      619    HOL_GUSTH   HOL_TRRSH      66 -0.185446513  0.338579482 -1.521509137
      620    HOL_GUSTH   HOL_TWMLH      88  0.492230094  0.303859893  5.274440684
      622    HOL_GUSTH   HOL_WEDEH      88  0.181442734  0.147711923  1.720950333
      623    HOL_GUSTH   HOL_WEDGH      75  0.114871224  0.251548967  0.994744452
      624    HOL_GUSTH   HOL_WEDWH      88  0.112537983  0.078855364  1.056395260
      625    HOL_IRRBH   HOL_AAHOH     187  0.493596957  0.393506269  7.740412083
      627    HOL_IRRBH   HOL_BDN2H      60  0.581057202  0.596238067  5.483953185
      631    HOL_IRRBH   HOL_BRBRH     102  0.123024561  0.115560935  1.245845442
      635    HOL_IRRBH   HOL_GKZBH      92  0.045835787  0.316290805  0.437705578
      639    HOL_IRRBH   HOL_KBMBH     188  0.494193558  0.311285485  7.773601527
      642    HOL_IRRBH   HOL_KMBQH     122  0.146320981  0.216230639  1.627042373
      644    HOL_IRRBH   HOL_KORHH      85  0.365580108  0.304804599  3.599773806
      646    HOL_IRRBH   HOL_LATEH     103  0.515759161  0.196970711  6.079967095
      647    HOL_IRRBH   HOL_LKBBH     102 -0.169554109  0.246260872 -1.729032576
      648    HOL_IRRBH   HOL_LKSBH     133  0.321052266  0.381384769  3.894794371
      649    HOL_IRRBH   HOL_LKSHH     149  0.229178936  0.196534990  2.864317891
      653    HOL_IRRBH   HOL_MBRUH     100  0.037921169  0.242702611  0.377582455
      654    HOL_IRRBH   HOL_MBUFH     124  0.494744518  0.407919753  6.313854145
      656    HOL_IRRBH   HOL_MRBRH     138  0.245032881  0.351267297  2.958218315
      658    HOL_IRRBH   HOL_PALZH     158  0.589586869  0.408641950  9.146287992
      659    HOL_IRRBH   HOL_SQUSH     157  0.299853050  0.200795430  3.925807862
      663    HOL_IRRBH  HOL_TMB11H      95  0.738107843  0.490500528 10.606794165
      669    HOL_IRRBH   HOL_TRPBH      68  0.331075012  0.425255566  2.871929864
      670    HOL_IRRBH   HOL_TRRBH     101  0.112710306  0.501053287  1.134331145
      671    HOL_IRRBH   HOL_TRRSH     202  0.397034405  0.303430429  6.133047854
      673    HOL_IRRBH   HOL_UNLUH     190  0.141304936  0.152727979  1.962311295
      682    HOL_K9SAH   HOL_BICKH      77 -0.079101900  0.095084116 -0.691761992
      683    HOL_K9SAH   HOL_BRBRH      89 -0.032851634  0.195837658 -0.308342079
      685    HOL_K9SAH   HOL_DHROH      93 -0.026333217  0.435453467 -0.252666963
      687    HOL_K9SAH   HOL_GKZBH      94 -0.013513101 -0.037757006 -0.130327531
      688    HOL_K9SAH   HOL_GUSTH      88  0.145345889  0.229675843  1.370246981
      691    HOL_K9SAH   HOL_KBMBH     163  0.273394303  0.333400041  3.617563123
      695    HOL_K9SAH   HOL_KORBH      63  0.500830859  0.457236393  4.556141312
      699    HOL_K9SAH   HOL_LKBBH     143  0.287785970  0.242627666  3.580854565
      700    HOL_K9SAH   HOL_LKSBH     105  0.147632386  0.345038961  1.522241086
      701    HOL_K9SAH   HOL_LKSHH     101  0.138410746  0.123241013  1.397559087
      703    HOL_K9SAH  HOL_MB253H     136  0.379300156  0.463258821  4.762990275
      707    HOL_K9SAH   HOL_MIWAH     112  0.243103119  0.350195331  2.640462989
      712    HOL_K9SAH   HOL_TATEH     142  0.253814714  0.368958631  3.115920222
      716    HOL_K9SAH  HOL_TMB12H     136  0.195051113  0.532215394  2.310669995
      717    HOL_K9SAH  HOL_TMB21H      69  0.225576266  0.360786854  1.909362385
      718    HOL_K9SAH  HOL_TMB22H      82  0.285254051  0.510479488  2.678576088
      723    HOL_K9SAH   HOL_TRRSH     101  0.353085800  0.463439523  3.773933482
      724    HOL_K9SAH   HOL_TWMLH     171  0.158939070  0.428712893  2.098993510
      726    HOL_K9SAH   HOL_WEDEH     146  0.216597331  0.403352862  2.671598235
      727    HOL_K9SAH   HOL_WEDGH     105  0.002461062  0.347195026  0.025098086
      728    HOL_K9SAH   HOL_WEDWH     146  0.194764476  0.380558863  2.391063634
      729    HOL_KBMBH   HOL_AAHOH     173  0.295691657  0.414522592  4.059485995
      734    HOL_KBMBH   HOL_BICKH      77  0.205125340  0.295696702  1.827093086
      735    HOL_KBMBH   HOL_BRBRH     153 -0.047533196  0.223174924 -0.586691758
      737    HOL_KBMBH   HOL_DHROH      85  0.370625080  0.493546818  3.657298386
      739    HOL_KBMBH   HOL_GKZBH     148  0.004404887  0.305523062  0.053406940
      740    HOL_KBMBH   HOL_GUSTH      88  0.245883024  0.369449586  2.366084114
      741    HOL_KBMBH   HOL_IRRBH     188  0.494193558  0.311285485  7.773601527
      742    HOL_KBMBH   HOL_K9SAH     163  0.273394303  0.333400041  3.617563123
      746    HOL_KBMBH   HOL_KMBQH     114  0.189622283  0.376163878  2.052959125
      747    HOL_KBMBH   HOL_KORBH      55  0.364831685  0.324685610  2.879422987
      748    HOL_KBMBH   HOL_KORHH      85  0.534915200  0.425992683  5.802515582
      750    HOL_KBMBH   HOL_LATEH      89  0.567261269  0.193522570  6.461612115
      751    HOL_KBMBH   HOL_LKBBH     207  0.048507830  0.563968508  0.697038886
      752    HOL_KBMBH   HOL_LKSBH     200  0.205888404  0.515339850  2.968001365
      753    HOL_KBMBH   HOL_LKSHH     212  0.192053825  0.465966207  2.842660812
      755    HOL_KBMBH  HOL_MB253H     128  0.158392623  0.455974350  1.807815698
      757    HOL_KBMBH   HOL_MBRUH     100  0.534248981  0.593245634  6.288346597
      758    HOL_KBMBH   HOL_MBUFH     124  0.723346282  0.636849856 11.618345264
      759    HOL_KBMBH   HOL_MIWAH     104  0.321364232  0.354941977  3.444185260
      760    HOL_KBMBH   HOL_MRBRH     138  0.604376406  0.574695819  8.879194304
      762    HOL_KBMBH   HOL_PALZH     144  0.683684975  0.487853519 11.202984249
      763    HOL_KBMBH   HOL_SQUSH     143  0.482221485  0.406060391  6.559370513
      764    HOL_KBMBH   HOL_TATEH     134  0.263513287  0.416086104  3.150329454
      767    HOL_KBMBH  HOL_TMB11H      95  0.179775977  0.369039404  1.771860672
      768    HOL_KBMBH  HOL_TMB12H     128  0.342397513  0.599927998  4.106862565
      769    HOL_KBMBH  HOL_TMB21H      69  0.472208117  0.657292845  4.417453099
      770    HOL_KBMBH  HOL_TMB22H      82  0.310896703  0.500502472  2.943962182
      773    HOL_KBMBH   HOL_TRPBH      68  0.410963063  0.372995637  3.689870330
      774    HOL_KBMBH   HOL_TRRBH      87  0.107651532  0.669123266  1.004154697
      775    HOL_KBMBH   HOL_TRRSH     251  0.389238024  0.574039069  6.681299456
      776    HOL_KBMBH   HOL_TWMLH     172  0.015844598  0.232887482  0.207221017
      777    HOL_KBMBH   HOL_UNLUH     176  0.360137445  0.271504589  5.106843594
      778    HOL_KBMBH   HOL_WEDEH     138  0.452358388  0.500901295  5.936873740
      779    HOL_KBMBH   HOL_WEDGH     105  0.186686657  0.322246064  1.937907171
      780    HOL_KBMBH   HOL_WEDWH     138  0.430539452  0.438924058  5.583306851
      799    HOL_KDGBH   HOL_KORBH      83  0.215007343  0.478031417  1.993599753
      816    HOL_KDGBH   HOL_TATEH      55  0.354746879  0.492059867  2.788183335
      817    HOL_KDGBH   HOL_TATTH      63 -0.087559381  0.126638336 -0.692101411
      824    HOL_KDGBH HOL_TRMB32H      83  0.174967773  0.450074872  1.609224207
      836    HOL_KKNAH   HOL_BENGH      69  0.282119113  0.225799744  2.424915353
      837    HOL_KKNAH   HOL_BERLH     228  0.648796646  0.304733827 12.845725876
      840    HOL_KKNAH   HOL_BROIH     231  0.729106542  0.309125970 16.156406698
      842    HOL_KKNAH   HOL_ERP1H      93  0.153494282 -0.025617359  1.489921700
      851    HOL_KKNAH   HOL_KORBH      64  0.345782321  0.440776458  2.924990856
      865    HOL_KKNAH   HOL_OB2BH     111  0.306094959  0.042447049  3.372213963
      885    HOL_KMBQH   HOL_AAHOH     122  0.321154212  0.591621699  3.730301947
      887    HOL_KMBQH   HOL_BDN2H      54  0.138911744  0.213496197  1.021193475
      897    HOL_KMBQH   HOL_IRRBH     122  0.146320981  0.216230639  1.627042373
      899    HOL_KMBQH   HOL_KBMBH     114  0.189622283  0.376163878  2.052959125
      906    HOL_KMBQH   HOL_LATEH      97  0.024111124  0.131747119  0.236308507
      908    HOL_KMBQH   HOL_LKSBH      59  0.054764538  0.377749389  0.417701143
      909    HOL_KMBQH   HOL_LKSHH      75  0.441272425  0.429744097  4.230089507
      914    HOL_KMBQH   HOL_MBUFH      97  0.250720480  0.497686600  2.537601166
      916    HOL_KMBQH   HOL_MRBRH      93 -0.033149179  0.435916706 -0.318130597
      918    HOL_KMBQH   HOL_PALZH     122  0.213031530  0.332566165  2.398401357
      919    HOL_KMBQH   HOL_SQUSH     122  0.112188530  0.250932006  1.241914109
      929    HOL_KMBQH   HOL_TRPBH      68 -0.026148714  0.388887146 -0.214109657
      930    HOL_KMBQH   HOL_TRRBH      95  0.269473726  0.309999844  2.713004881
      931    HOL_KMBQH   HOL_TRRSH     122  0.128799278  0.389133386  1.428692088
      933    HOL_KMBQH   HOL_UNLUH     122  0.217656631  0.180615553  2.453033421
      940    HOL_KORBH   HOL_BENGH      63  0.665527356  0.315735142  7.021106644
      941    HOL_KORBH   HOL_BERLH      53  0.606828824  0.179090988  5.505442498
      944    HOL_KORBH   HOL_BROIH      70  0.734831416  0.432936730  8.999587148
      945    HOL_KORBH   HOL_DHROH      86  0.079789205  0.255727290  0.737972961
      950    HOL_KORBH   HOL_K9SAH      63  0.500830859  0.457236393  4.556141312
      951    HOL_KORBH   HOL_KBMBH      55  0.364831685  0.324685610  2.879422987
      952    HOL_KORBH   HOL_KDGBH      83  0.215007343  0.478031417  1.993599753
      953    HOL_KORBH   HOL_KKNAH      64  0.345782321  0.440776458  2.924990856
      963    HOL_KORBH  HOL_MB253H     105  0.592835617  0.610646450  7.507244970
      964    HOL_KORBH  HOL_MB259H      84  0.490329050  0.413909575  5.125552038
      967    HOL_KORBH   HOL_MIWAH      80  0.101212307  0.284768032  0.904238057
      972    HOL_KORBH   HOL_TATEH     138  0.440587868  0.510714524  5.744563064
      973    HOL_KORBH   HOL_TATTH      85  0.046435228  0.042769777  0.426045466
      976    HOL_KORBH  HOL_TMB12H      97  0.060272067  0.476987801  0.591618811
      980    HOL_KORBH HOL_TRMB32H     133  0.454742390  0.496032610  5.866221945
      984    HOL_KORBH   HOL_TWMLH      83  0.171363922  0.387056412  1.575064993
      986    HOL_KORBH   HOL_WEDEH     124  0.253383305  0.405401632  2.904957292
      988    HOL_KORBH   HOL_WEDWH     124  0.225610729  0.415516720  2.568362760
      989    HOL_KORHH   HOL_AAHOH      85  0.050560394  0.288676503  0.463987099
      995    HOL_KORHH   HOL_BRBRH      85  0.392176452  0.198172039  3.907376443
      999    HOL_KORHH   HOL_GKZBH      75  0.015126348  0.539912486  0.130136657
      1001   HOL_KORHH   HOL_IRRBH      85  0.365580108  0.304804599  3.599773806
      1003   HOL_KORHH   HOL_KBMBH      85  0.534915200  0.425992683  5.802515582
      1011   HOL_KORHH   HOL_LKBBH      85  0.176961734  0.577187570  1.647888495
      1012   HOL_KORHH   HOL_LKSBH      85  0.293937953  0.546311524  2.818494220
      1013   HOL_KORHH   HOL_LKSHH      85  0.270758454  0.313355332  2.577831128
      1017   HOL_KORHH   HOL_MBRUH      85  0.310680627  0.536081723  2.995678023
      1018   HOL_KORHH   HOL_MBUFH      55  0.284118102  0.084468501  2.177572438
      1020   HOL_KORHH   HOL_MRBRH      73  0.403900225  0.487490594  3.746387909
      1022   HOL_KORHH   HOL_PALZH      58  0.436837722  0.200495727  3.666375331
      1023   HOL_KORHH   HOL_SQUSH      57  0.477601912  0.331567296  4.067996388
      1027   HOL_KORHH  HOL_TMB11H      85  0.447164075  0.480030045  4.581941423
      1035   HOL_KORHH   HOL_TRRSH      85  0.642772074  0.480783259  7.690158418
      1037   HOL_KORHH   HOL_UNLUH      85  0.120928149 -0.087497523  1.116518626
      1043   HOL_LAGEH   HOL_BDN2H      58  0.433764001  0.341440542  3.634572700
      1062   HOL_LAGEH   HOL_LATEH      58  0.045105122  0.117701098  0.340883142
      1066   HOL_LAGEH   HOL_MANCH      58  0.147704300  0.265611390  1.127510026
      1078   HOL_LAGEH   HOL_TITEH      58  0.181761277  0.392027733  1.395513050
      1086   HOL_LAGEH   HOL_TRRBH      58  0.422119379  0.394990644  3.515488051
      1093   HOL_LATEH   HOL_AAHOH     103  0.298520123  0.201482556  3.158942695
      1095   HOL_LATEH   HOL_BDN2H     326  0.475777446  0.081137615  9.751630705
      1105   HOL_LATEH   HOL_IRRBH     103  0.515759161  0.196970711  6.079967095
      1107   HOL_LATEH   HOL_KBMBH      89  0.567261269  0.193522570  6.461612115
      1110   HOL_LATEH   HOL_KMBQH      97  0.024111124  0.131747119  0.236308507
      1113   HOL_LATEH   HOL_LAGEH      58  0.045105122  0.117701098  0.340883142
      1117   HOL_LATEH   HOL_LKSHH      50 -0.230459549           NA -1.657842814
      1118   HOL_LATEH   HOL_MANCH     226 -0.059788543 -0.002400243 -0.898435381
      1122   HOL_LATEH   HOL_MBUFH      72  0.171757641  0.133946819  1.469087374
      1124   HOL_LATEH   HOL_MRBRH      68  0.441573630  0.083108235  4.028460944
      1126   HOL_LATEH   HOL_PALZH     189  0.431646461  0.033203004  6.561149486
      1127   HOL_LATEH   HOL_SQUSH     103  0.257036312  0.104705526  2.686190824
      1130   HOL_LATEH   HOL_TITEH      84  0.097782027  0.008943228  0.895126238
      1137   HOL_LATEH   HOL_TRPBH      68  0.259949997 -0.011459399  2.203535398
      1138   HOL_LATEH   HOL_TRRBH     317  0.019928936  0.061802157  0.354334887
      1139   HOL_LATEH   HOL_TRRSH     103  0.239689088  0.032238120  2.493425221
      1141   HOL_LATEH   HOL_UNLUH     134 -0.033085444 -0.025515608 -0.381768966
      1145   HOL_LKBBH   HOL_AAHOH      87  0.024049799  0.327189504  0.223093191
      1150   HOL_LKBBH   HOL_BICKH      77  0.490403004  0.337521326  4.905628195
      1151   HOL_LKBBH   HOL_BRBRH     153  0.514217918  0.411207086  7.391865616
      1153   HOL_LKBBH   HOL_DHROH      65  0.557982768  0.539011875  5.379102857
      1155   HOL_LKBBH   HOL_GKZBH     148  0.592894958  0.385617958  8.926672777
      1156   HOL_LKBBH   HOL_GUSTH      88  0.421581798  0.396463781  4.336452319
      1157   HOL_LKBBH   HOL_IRRBH     102 -0.169554109  0.246260872 -1.729032576
      1158   HOL_LKBBH   HOL_K9SAH     143  0.287785970  0.242627666  3.580854565
      1159   HOL_LKBBH   HOL_KBMBH     207  0.048507830  0.563968508  0.697038886
      1164   HOL_LKBBH   HOL_KORHH      85  0.176961734  0.577187570  1.647888495
      1168   HOL_LKBBH   HOL_LKSBH     169  0.653855370  0.658100556 11.201050942
      1169   HOL_LKBBH   HOL_LKSHH     165  0.342351849  0.538476927  4.666213626
      1171   HOL_LKBBH  HOL_MB253H     108  0.154307891  0.428379162  1.615522662
      1173   HOL_LKBBH   HOL_MBRUH     100  0.649670541  0.682432783  8.503032374
      1174   HOL_LKBBH   HOL_MBUFH      55  0.689133115  0.585865836  6.988449497
      1175   HOL_LKBBH   HOL_MIWAH      84  0.427418323  0.423513508  4.307227640
      1176   HOL_LKBBH   HOL_MRBRH      73  0.686515436  0.643945809  8.011490353
      1178   HOL_LKBBH   HOL_PALZH      58  0.334509555  0.362400744  2.679872913
      1179   HOL_LKBBH   HOL_SQUSH      57  0.351425985  0.415145689  2.809001552
      1180   HOL_LKBBH   HOL_TATEH     114  0.403610102  0.461347418  4.689352372
      1183   HOL_LKBBH  HOL_TMB11H      95 -0.126528737  0.456570740 -1.236680898
      1184   HOL_LKBBH  HOL_TMB12H     108  0.544759440  0.603884425  6.719636026
      1185   HOL_LKBBH  HOL_TMB21H      69  0.356994329  0.436806035  3.151514830
      1186   HOL_LKBBH  HOL_TMB22H      82  0.372160586  0.421610342  3.608661344
      1191   HOL_LKBBH   HOL_TRRSH     165 -0.089227628  0.513661005 -1.147247245
      1192   HOL_LKBBH   HOL_TWMLH     152  0.566824381  0.312159966  8.454634421
      1193   HOL_LKBBH   HOL_UNLUH      90  0.114272999  0.144795007  1.085157762
      1194   HOL_LKBBH   HOL_WEDEH     118  0.347653246  0.485822075  4.010614194
      1195   HOL_LKBBH   HOL_WEDGH      95  0.341031432  0.407961750  3.517276474
      1196   HOL_LKBBH   HOL_WEDWH     118  0.265138039  0.467384322  2.974357247
      1197   HOL_LKSBH   HOL_AAHOH     118  0.302268769  0.498699727  3.429981790
      1202   HOL_LKSBH   HOL_BICKH      70  0.184627117  0.183442546  1.560454341
      1203   HOL_LKSBH   HOL_BRBRH     153  0.557418690  0.327587355  8.277593492
      1207   HOL_LKSBH   HOL_GKZBH     148  0.595772324  0.369116446  8.993743674
      1208   HOL_LKSBH   HOL_GUSTH      70  0.387944916  0.277987333  3.496336630
      1209   HOL_LKSBH   HOL_IRRBH     133  0.321052266  0.381384769  3.894794371
      1210   HOL_LKSBH   HOL_K9SAH     105  0.147632386  0.345038961  1.522241086
      1211   HOL_LKSBH   HOL_KBMBH     200  0.205888404  0.515339850  2.968001365
      1214   HOL_LKSBH   HOL_KMBQH      59  0.054764538  0.377749389  0.417701143
      1216   HOL_LKSBH   HOL_KORHH      85  0.293937953  0.546311524  2.818494220
      1219   HOL_LKSBH   HOL_LKBBH     169  0.653855370  0.658100556 11.201050942
      1221   HOL_LKSBH   HOL_LKSHH     196  0.541084026  0.513610375  8.984672928
      1223   HOL_LKSBH  HOL_MB253H      70 -0.141961669  0.387233649 -1.191287359
      1225   HOL_LKSBH   HOL_MBRUH     100  0.319163518  0.547674147  3.350889564
      1226   HOL_LKSBH   HOL_MBUFH      86  0.162226127  0.397582782  1.515728926
      1228   HOL_LKSBH   HOL_MRBRH     104  0.411365673  0.630874957  4.580407245
      1230   HOL_LKSBH   HOL_PALZH      89  0.114105772  0.315740262  1.077444236
      1231   HOL_LKSBH   HOL_SQUSH      88  0.103289823  0.327399632  0.968604101
      1232   HOL_LKSBH   HOL_TATEH      76  0.395525047  0.378277671  3.729465972
      1235   HOL_LKSBH  HOL_TMB11H      95  0.223933278  0.452640907  2.227686956
      1236   HOL_LKSBH  HOL_TMB12H      70  0.225414032  0.489700927  1.921893219
      1237   HOL_LKSBH  HOL_TMB21H      69  0.223427090  0.528989194  1.890210280
      1238   HOL_LKSBH  HOL_TMB22H      70  0.492548432  0.334379418  4.701235105
      1243   HOL_LKSBH   HOL_TRRSH     196 -0.053779651  0.461660810 -0.752080348
      1244   HOL_LKSBH   HOL_TWMLH     114  0.509604090  0.371210304  6.296035594
      1245   HOL_LKSBH   HOL_UNLUH     121  0.114516712  0.150898944  1.262775114
      1246   HOL_LKSBH   HOL_WEDEH      80  0.264211526  0.426866051  2.434887735
      1247   HOL_LKSBH   HOL_WEDGH      57  0.037667612  0.173995168  0.282078779
      1248   HOL_LKSBH   HOL_WEDWH      80  0.168797282  0.389698539  1.522144639
      1249   HOL_LKSHH   HOL_AAHOH     134  0.371330048  0.244677604  4.612151513
      1254   HOL_LKSHH   HOL_BICKH      66  0.159042134  0.144177426  1.298769679
      1255   HOL_LKSHH   HOL_BRBRH     153  0.540711818  0.230863880  7.924727054
      1259   HOL_LKSHH   HOL_GKZBH     148  0.280937674  0.170810453  3.549125713
      1260   HOL_LKSHH   HOL_GUSTH      66  0.228060287  0.205141873  1.888447034
      1261   HOL_LKSHH   HOL_IRRBH     149  0.229178936  0.196534990  2.864317891
      1262   HOL_LKSHH   HOL_K9SAH     101  0.138410746  0.123241013  1.397559087
      1263   HOL_LKSHH   HOL_KBMBH     212  0.192053825  0.465966207  2.842660812
      1266   HOL_LKSHH   HOL_KMBQH      75  0.441272425  0.429744097  4.230089507
      1268   HOL_LKSHH   HOL_KORHH      85  0.270758454  0.313355332  2.577831128
      1270   HOL_LKSHH   HOL_LATEH      50 -0.230459549           NA -1.657842814
      1271   HOL_LKSHH   HOL_LKBBH     165  0.342351849  0.538476927  4.666213626
      1272   HOL_LKSHH   HOL_LKSBH     196  0.541084026  0.513610375  8.984672928
      1275   HOL_LKSHH  HOL_MB253H      66  0.214533319  0.170299957  1.770854299
      1277   HOL_LKSHH   HOL_MBRUH     100 -0.008618018  0.453316447 -0.085751380
      1278   HOL_LKSHH   HOL_MBUFH     102  0.475212621  0.321238812  5.427872685
      1280   HOL_LKSHH   HOL_MRBRH     120  0.003288783  0.407830073  0.035876586
      1282   HOL_LKSHH   HOL_PALZH     105  0.035599017  0.308005630  0.363270418
      1283   HOL_LKSHH   HOL_SQUSH     104  0.260830951  0.258130680  2.742062947
      1284   HOL_LKSHH   HOL_TATEH      72  0.241429031  0.408594403  2.096329799
      1287   HOL_LKSHH  HOL_TMB11H      95  0.345407296  0.281689900  3.568477514
      1288   HOL_LKSHH  HOL_TMB12H      66  0.402407134  0.466653142  3.543909245
      1289   HOL_LKSHH  HOL_TMB21H      66  0.377395037  0.500255379  3.285619874
      1290   HOL_LKSHH  HOL_TMB22H      66  0.366729580  0.295082417  3.178093877
      1295   HOL_LKSHH   HOL_TRRSH     212  0.088249244  0.415316109  1.286915306
      1296   HOL_LKSHH   HOL_TWMLH     110  0.420838212  0.200631160  4.843464834
      1297   HOL_LKSHH   HOL_UNLUH     137  0.320611330  0.141760093  3.947313870
      1298   HOL_LKSHH   HOL_WEDEH      76  0.218206049  0.284314989  1.936381342
      1299   HOL_LKSHH   HOL_WEDGH      53  0.170916909  0.297401147  1.250905881
      1300   HOL_LKSHH   HOL_WEDWH      76  0.196719235  0.282650191  1.737591326
      1303   HOL_MANCH   HOL_BDN2H     226  0.121782161  0.215989030  1.840431010
      1321   HOL_MANCH   HOL_LAGEH      58  0.147704300  0.265611390  1.127510026
      1322   HOL_MANCH   HOL_LATEH     226 -0.059788543 -0.002400243 -0.898435381
      1334   HOL_MANCH   HOL_PALZH      87  0.316267215  0.430411956  3.091634646
      1338   HOL_MANCH   HOL_TITEH      84  0.070299770  0.175630806  0.642049873
      1346   HOL_MANCH   HOL_TRRBH     217  0.191327279  0.336500430  2.864849627
      1358  HOL_MB253H   HOL_BICKH      77  0.367288301  0.303391543  3.442555185
      1359  HOL_MB253H   HOL_BRBRH      54  0.324974883  0.109715802  2.501634983
      1361  HOL_MB253H   HOL_DHROH     116 -0.084985667  0.528471099 -0.914678896
      1363  HOL_MB253H   HOL_GKZBH      59  0.093307054  0.171147887  0.713719034
      1364  HOL_MB253H   HOL_GUSTH      88  0.195674878  0.552690080  1.861111225
      1366  HOL_MB253H   HOL_K9SAH     136  0.379300156  0.463258821  4.762990275
      1367  HOL_MB253H   HOL_KBMBH     128  0.158392623  0.455974350  1.807815698
      1371  HOL_MB253H   HOL_KORBH     105  0.592835617  0.610646450  7.507244970
      1375  HOL_MB253H   HOL_LKBBH     108  0.154307891  0.428379162  1.615522662
      1376  HOL_MB253H   HOL_LKSBH      70 -0.141961669  0.387233649 -1.191287359
      1377  HOL_MB253H   HOL_LKSHH      66  0.214533319  0.170299957  1.770854299
      1380  HOL_MB253H  HOL_MB259H      78  0.159776650  0.469755979  1.420280485
      1383  HOL_MB253H   HOL_MIWAH     129 -0.322827810  0.332488757 -3.858999383
      1388  HOL_MB253H   HOL_TATEH     178  0.106930926  0.551991160  1.430827155
      1392  HOL_MB253H  HOL_TMB12H     170 -0.233782014  0.649386617 -3.125784694
      1393  HOL_MB253H  HOL_TMB21H      69  0.403444986  0.545565464  3.635932666
      1394  HOL_MB253H  HOL_TMB22H      82  0.136354296  0.416613457  1.238758497
      1396  HOL_MB253H HOL_TRMB32H      71  0.517839579  0.675646409  5.064487993
      1399  HOL_MB253H   HOL_TRRSH      66  0.643374022  0.556914738  6.775564788
      1400  HOL_MB253H   HOL_TWMLH     156 -0.146541730  0.365020421 -1.844340427
      1402  HOL_MB253H   HOL_WEDEH     178  0.459390150  0.530474537  6.880826860
      1403  HOL_MB253H   HOL_WEDGH     105  0.270299737  0.374831539  2.863102772
      1404  HOL_MB253H   HOL_WEDWH     178  0.475733073  0.497914415  7.195646867
      1413  HOL_MB259H   HOL_DHROH      59  0.288547531  0.451881863  2.295134768
      1423  HOL_MB259H   HOL_KORBH      84  0.490329050  0.413909575  5.125552038
      1431  HOL_MB259H  HOL_MB253H      78  0.159776650  0.469755979  1.420280485
      1435  HOL_MB259H   HOL_MIWAH      53  0.590943015  0.509241731  5.282360742
      1440  HOL_MB259H   HOL_TATEH      84  0.183574774  0.397481879  1.701359114
      1441  HOL_MB259H   HOL_TATTH      50  0.263201374           NA  1.909745491
      1444  HOL_MB259H  HOL_TMB12H      70  0.270162719  0.572080219  2.330812081
      1448  HOL_MB259H HOL_TRMB32H      77  0.529496800  0.459110314  5.441448946
      1452  HOL_MB259H   HOL_TWMLH      56  0.024214611  0.517503480  0.179633036
      1454  HOL_MB259H   HOL_WEDEH      84  0.151884006  0.569579263  1.399971159
      1456  HOL_MB259H   HOL_WEDWH      84  0.162768833  0.557212425  1.502937465
      1457   HOL_MBRUH   HOL_AAHOH      87  0.065309029  0.459845937  0.606946798
      1463   HOL_MBRUH   HOL_BRBRH     100  0.287621312  0.273093775  2.988058682
      1467   HOL_MBRUH   HOL_GKZBH      90  0.307503904  0.507064623  3.048705508
      1469   HOL_MBRUH   HOL_IRRBH     100  0.037921169  0.242702611  0.377582455
      1471   HOL_MBRUH   HOL_KBMBH     100  0.534248981  0.593245634  6.288346597
      1476   HOL_MBRUH   HOL_KORHH      85  0.310680627  0.536081723  2.995678023
      1479   HOL_MBRUH   HOL_LKBBH     100  0.649670541  0.682432783  8.503032374
      1480   HOL_MBRUH   HOL_LKSBH     100  0.319163518  0.547674147  3.350889564
      1481   HOL_MBRUH   HOL_LKSHH     100 -0.008618018  0.453316447 -0.085751380
      1486   HOL_MBRUH   HOL_MBUFH      55  0.640299285  0.567773194  6.125586808
      1488   HOL_MBRUH   HOL_MRBRH      73  0.775861707  0.801452796 10.434892136
      1490   HOL_MBRUH   HOL_PALZH      58  0.506117270  0.368504172  4.430444186
      1491   HOL_MBRUH   HOL_SQUSH      57  0.391808284  0.458484738  3.186820992
      1495   HOL_MBRUH  HOL_TMB11H      95  0.124080604  0.528106736  1.212375148
      1503   HOL_MBRUH   HOL_TRRSH     100  0.460348649  0.584573346  5.159641879
      1505   HOL_MBRUH   HOL_UNLUH      90  0.176705007  0.138971604  1.693683748
      1509   HOL_MBUFH   HOL_AAHOH     124  0.449018896  0.491842675  5.573291986
      1515   HOL_MBUFH   HOL_BRBRH      55  0.378409478  0.394466702  3.004122017
      1521   HOL_MBUFH   HOL_IRRBH     124  0.494744518  0.407919753  6.313854145
      1523   HOL_MBUFH   HOL_KBMBH     124  0.723346282  0.636849856 11.618345264
      1526   HOL_MBUFH   HOL_KMBQH      97  0.250720480  0.497686600  2.537601166
      1528   HOL_MBUFH   HOL_KORHH      55  0.284118102  0.084468501  2.177572438
      1530   HOL_MBUFH   HOL_LATEH      72  0.171757641  0.133946819  1.469087374
      1531   HOL_MBUFH   HOL_LKBBH      55  0.689133115  0.585865836  6.988449497
      1532   HOL_MBUFH   HOL_LKSBH      86  0.162226127  0.397582782  1.515728926
      1533   HOL_MBUFH   HOL_LKSHH     102  0.475212621  0.321238812  5.427872685
      1537   HOL_MBUFH   HOL_MBRUH      55  0.640299285  0.567773194  6.125586808
      1540   HOL_MBUFH   HOL_MRBRH     120  0.646291133  0.624179143  9.239008882
      1542   HOL_MBUFH   HOL_PALZH     124  0.608691700  0.714996995  8.508519426
      1543   HOL_MBUFH   HOL_SQUSH     124  0.451006541  0.510205405  5.604245163
      1547   HOL_MBUFH  HOL_TMB11H      55  0.097614000  0.260539250  0.720755553
      1553   HOL_MBUFH   HOL_TRPBH      64  0.616201031  0.552756931  6.210021493
      1554   HOL_MBUFH   HOL_TRRBH      70  0.383379749  0.716668333  3.448054449
      1555   HOL_MBUFH   HOL_TRRSH     124  0.446763833  0.670593303  5.538299791
      1557   HOL_MBUFH   HOL_UNLUH     124  0.305811681  0.240252770  3.562277112
      1566   HOL_MIWAH   HOL_BICKH      53  0.026932105  0.104871658  0.194280644
      1569   HOL_MIWAH   HOL_DHROH     110  0.568889048  0.443083941  7.221878507
      1572   HOL_MIWAH   HOL_GUSTH      64  0.486231851  0.211205939  4.416587185
      1574   HOL_MIWAH   HOL_K9SAH     112  0.243103119  0.350195331  2.640462989
      1575   HOL_MIWAH   HOL_KBMBH     104  0.321364232  0.354941977  3.444185260
      1579   HOL_MIWAH   HOL_KORBH      80  0.101212307  0.284768032  0.904238057
      1583   HOL_MIWAH   HOL_LKBBH      84  0.427418323  0.423513508  4.307227640
      1587   HOL_MIWAH  HOL_MB253H     129 -0.322827810  0.332488757 -3.858999383
      1588   HOL_MIWAH  HOL_MB259H      53  0.590943015  0.509241731  5.282360742
      1596   HOL_MIWAH   HOL_TATEH     129  0.412145116  0.320113481  5.117765865
      1600   HOL_MIWAH  HOL_TMB12H     129  0.708490105  0.429404283 11.358105284
      1602   HOL_MIWAH  HOL_TMB22H      58  0.378996713  0.229551518  3.092034329
      1608   HOL_MIWAH   HOL_TWMLH     129  0.281844726  0.221487629  3.323441277
      1610   HOL_MIWAH   HOL_WEDEH     129  0.070142752  0.495090767  0.795534074
      1611   HOL_MIWAH   HOL_WEDGH      94  0.016502954  0.460010471  0.159170400
      1612   HOL_MIWAH   HOL_WEDWH     129  0.030091643  0.477594560  0.340602321
      1613   HOL_MRBRH   HOL_AAHOH     138  0.303797212  0.559263260  3.732253762
      1619   HOL_MRBRH   HOL_BRBRH      73  0.299089892  0.276143408  2.659605495
      1623   HOL_MRBRH   HOL_GKZBH      63  0.308367588  0.495787214  2.552478026
      1625   HOL_MRBRH   HOL_IRRBH     138  0.245032881  0.351267297  2.958218315
      1627   HOL_MRBRH   HOL_KBMBH     138  0.604376406  0.574695819  8.879194304
      1630   HOL_MRBRH   HOL_KMBQH      93 -0.033149179  0.435916706 -0.318130597
      1632   HOL_MRBRH   HOL_KORHH      73  0.403900225  0.487490594  3.746387909
      1634   HOL_MRBRH   HOL_LATEH      68  0.441573630  0.083108235  4.028460944
      1635   HOL_MRBRH   HOL_LKBBH      73  0.686515436  0.643945809  8.011490353
      1636   HOL_MRBRH   HOL_LKSBH     104  0.411365673  0.630874957  4.580407245
      1637   HOL_MRBRH   HOL_LKSHH     120  0.003288783  0.407830073  0.035876586
      1641   HOL_MRBRH   HOL_MBRUH      73  0.775861707  0.801452796 10.434892136
      1642   HOL_MRBRH   HOL_MBUFH     120  0.646291133  0.624179143  9.239008882
      1646   HOL_MRBRH   HOL_PALZH     123  0.539047700  0.536001850  7.068920215
      1647   HOL_MRBRH   HOL_SQUSH     122  0.406418426  0.443851725  4.892925405
      1651   HOL_MRBRH  HOL_TMB11H      73  0.095326145  0.547150742  0.812569529
      1657   HOL_MRBRH   HOL_TRPBH      60  0.694007691  0.544136181  7.404186431
      1658   HOL_MRBRH   HOL_TRRBH      66  0.153066164  0.733701800  1.248774495
      1659   HOL_MRBRH   HOL_TRRSH     138  0.377208429  0.624626688  4.767277942
      1661   HOL_MRBRH   HOL_UNLUH     138 -0.110182054  0.109825237 -1.297548098
      1669   HOL_OB2BH   HOL_BERLH     150  0.491688025  0.148084800  6.892528861
      1672   HOL_OB2BH   HOL_BROIH     103  0.272484254  0.011041913  2.860184764
      1674   HOL_OB2BH   HOL_ERP1H      92  0.527554510  0.214297986  5.923983276
      1681   HOL_OB2BH   HOL_KKNAH     111  0.306094959  0.042447049  3.372213963
      1717   HOL_PALZH   HOL_AAHOH     158  0.306343579  0.421020482  4.032345115
      1719   HOL_PALZH   HOL_BDN2H     146  0.127156008  0.409393249  1.543691654
      1723   HOL_PALZH   HOL_BRBRH      58  0.381600162  0.076475951  3.116880179
      1729   HOL_PALZH   HOL_IRRBH     158  0.589586869  0.408641950  9.146287992
      1731   HOL_PALZH   HOL_KBMBH     144  0.683684975  0.487853519 11.202984249
      1734   HOL_PALZH   HOL_KMBQH     122  0.213031530  0.332566165  2.398401357
      1736   HOL_PALZH   HOL_KORHH      58  0.436837722  0.200495727  3.666375331
      1738   HOL_PALZH   HOL_LATEH     189  0.431646461  0.033203004  6.561149486
      1739   HOL_PALZH   HOL_LKBBH      58  0.334509555  0.362400744  2.679872913
      1740   HOL_PALZH   HOL_LKSBH      89  0.114105772  0.315740262  1.077444236
      1741   HOL_PALZH   HOL_LKSHH     105  0.035599017  0.308005630  0.363270418
      1742   HOL_PALZH   HOL_MANCH      87  0.316267215  0.430411956  3.091634646
      1745   HOL_PALZH   HOL_MBRUH      58  0.506117270  0.368504172  4.430444186
      1746   HOL_PALZH   HOL_MBUFH     124  0.608691700  0.714996995  8.508519426
      1748   HOL_PALZH   HOL_MRBRH     123  0.539047700  0.536001850  7.068920215
      1751   HOL_PALZH   HOL_SQUSH     157  0.396758872  0.432349683  5.398619953
      1754   HOL_PALZH   HOL_TITEH      70  0.365011577  0.429235533  3.256717692
      1755   HOL_PALZH  HOL_TMB11H      58  0.036518273  0.216776370  0.275890939
      1761   HOL_PALZH   HOL_TRPBH      68  0.372446788  0.529021190  3.284948749
      1762   HOL_PALZH   HOL_TRRBH     187  0.195043502  0.768677386  2.712126203
      1763   HOL_PALZH   HOL_TRRSH     158  0.416785660  0.624806906  5.745084501
      1765   HOL_PALZH   HOL_UNLUH     189  0.256579127  0.216520771  3.639887423
      1769   HOL_SQUSH   HOL_AAHOH     157  0.347714888  0.364675149  4.631992406
      1771   HOL_SQUSH   HOL_BDN2H      60  0.218914148  0.092752129  1.723311918
      1775   HOL_SQUSH   HOL_BRBRH      57  0.238618861  0.204771374  1.838776227
      1781   HOL_SQUSH   HOL_IRRBH     157  0.299853050  0.200795430  3.925807862
      1783   HOL_SQUSH   HOL_KBMBH     143  0.482221485  0.406060391  6.559370513
      1786   HOL_SQUSH   HOL_KMBQH     122  0.112188530  0.250932006  1.241914109
      1788   HOL_SQUSH   HOL_KORHH      57  0.477601912  0.331567296  4.067996388
      1790   HOL_SQUSH   HOL_LATEH     103  0.257036312  0.104705526  2.686190824
      1791   HOL_SQUSH   HOL_LKBBH      57  0.351425985  0.415145689  2.809001552
      1792   HOL_SQUSH   HOL_LKSBH      88  0.103289823  0.327399632  0.968604101
      1793   HOL_SQUSH   HOL_LKSHH     104  0.260830951  0.258130680  2.742062947
      1797   HOL_SQUSH   HOL_MBRUH      57  0.391808284  0.458484738  3.186820992
      1798   HOL_SQUSH   HOL_MBUFH     124  0.451006541  0.510205405  5.604245163
      1800   HOL_SQUSH   HOL_MRBRH     122  0.406418426  0.443851725  4.892925405
      1802   HOL_SQUSH   HOL_PALZH     157  0.396758872  0.432349683  5.398619953
      1807   HOL_SQUSH  HOL_TMB11H      57  0.034766025  0.251901720  0.260322477
      1813   HOL_SQUSH   HOL_TRPBH      68  0.417077201  0.301546782  3.756224803
      1814   HOL_SQUSH   HOL_TRRBH     101  0.131502723  0.444094893  1.326547219
      1815   HOL_SQUSH   HOL_TRRSH     157  0.494324809  0.529997977  7.102584007
      1817   HOL_SQUSH   HOL_UNLUH     157  0.135298979  0.030077818  1.705566702
      1826   HOL_TATEH   HOL_BICKH      77  0.133636892  0.326688577  1.175563790
      1827   HOL_TATEH   HOL_BRBRH      60  0.230664609  0.189656344  1.820871338
      1829   HOL_TATEH   HOL_DHROH     116  0.245609153  0.418843672  2.717092141
      1831   HOL_TATEH   HOL_GKZBH      65  0.328003333  0.223500616  2.777698486
      1832   HOL_TATEH   HOL_GUSTH      88  0.310066749  0.305284742  3.042037561
      1834   HOL_TATEH   HOL_K9SAH     142  0.253814714  0.368958631  3.115920222
      1835   HOL_TATEH   HOL_KBMBH     134  0.263513287  0.416086104  3.150329454
      1836   HOL_TATEH   HOL_KDGBH      55  0.354746879  0.492059867  2.788183335
      1839   HOL_TATEH   HOL_KORBH     138  0.440587868  0.510714524  5.744563064
      1843   HOL_TATEH   HOL_LKBBH     114  0.403610102  0.461347418  4.689352372
      1844   HOL_TATEH   HOL_LKSBH      76  0.395525047  0.378277671  3.729465972
      1845   HOL_TATEH   HOL_LKSHH      72  0.241429031  0.408594403  2.096329799
      1847   HOL_TATEH  HOL_MB253H     178  0.106930926  0.551991160  1.430827155
      1848   HOL_TATEH  HOL_MB259H      84  0.183574774  0.397481879  1.701359114
      1851   HOL_TATEH   HOL_MIWAH     129  0.412145116  0.320113481  5.117765865
      1857   HOL_TATEH   HOL_TATTH      77  0.179829565  0.081321651  1.593698624
      1860   HOL_TATEH  HOL_TMB12H     170  0.619914326  0.703885253 10.270421139
      1861   HOL_TATEH  HOL_TMB21H      69  0.128988583  0.640045352  1.072627749
      1862   HOL_TATEH  HOL_TMB22H      82  0.439051629  0.542447674  4.398032845
      1864   HOL_TATEH HOL_TRMB32H     104  0.131743114  0.419491509  1.348802895
      1867   HOL_TATEH   HOL_TRRSH      72  0.158143461  0.432379215  1.349522681
      1868   HOL_TATEH   HOL_TWMLH     162  0.407060207  0.361545478  5.654704931
      1870   HOL_TATEH   HOL_WEDEH     203  0.167580256  0.488892214  2.415927937
      1871   HOL_TATEH   HOL_WEDGH     105  0.136123890  0.346128904  1.401239729
      1872   HOL_TATEH   HOL_WEDWH     203  0.077051683  0.479001680  1.098375539
      1888   HOL_TATTH   HOL_KDGBH      63 -0.087559381  0.126638336 -0.692101411
      1891   HOL_TATTH   HOL_KORBH      85  0.046435228  0.042769777  0.426045466
      1900   HOL_TATTH  HOL_MB259H      50  0.263201374           NA  1.909745491
      1908   HOL_TATTH   HOL_TATEH      77  0.179829565  0.081321651  1.593698624
      1916   HOL_TATTH HOL_TRMB32H      85  0.199403579  0.115082789  1.865018306
      1922   HOL_TATTH   HOL_WEDEH      63 -0.146651421  0.187191262 -1.167355621
      1924   HOL_TATTH   HOL_WEDWH      63 -0.184679599  0.145794377 -1.479619881
      1927   HOL_TITEH   HOL_BDN2H      84  0.283233492  0.338320042  2.690555518
      1945   HOL_TITEH   HOL_LAGEH      58  0.181761277  0.392027733  1.395513050
      1946   HOL_TITEH   HOL_LATEH      84  0.097782027  0.008943228  0.895126238
      1950   HOL_TITEH   HOL_MANCH      84  0.070299770  0.175630806  0.642049873
      1958   HOL_TITEH   HOL_PALZH      70  0.365011577  0.429235533  3.256717692
      1970   HOL_TITEH   HOL_TRRBH      84  0.492660184  0.478859809  5.157705774
      1977  HOL_TMB11H   HOL_AAHOH      87  0.441421672  0.414098997  4.562105380
      1983  HOL_TMB11H   HOL_BRBRH      95  0.094108502  0.296739269  0.916483180
      1987  HOL_TMB11H   HOL_GKZBH      85  0.000173664  0.340106128  0.001591657
      1989  HOL_TMB11H   HOL_IRRBH      95  0.738107843  0.490500528 10.606794165
      1991  HOL_TMB11H   HOL_KBMBH      95  0.179775977  0.369039404  1.771860672
      1996  HOL_TMB11H   HOL_KORHH      85  0.447164075  0.480030045  4.581941423
      1999  HOL_TMB11H   HOL_LKBBH      95 -0.126528737  0.456570740 -1.236680898
      2000  HOL_TMB11H   HOL_LKSBH      95  0.223933278  0.452640907  2.227686956
      2001  HOL_TMB11H   HOL_LKSHH      95  0.345407296  0.281689900  3.568477514
      2005  HOL_TMB11H   HOL_MBRUH      95  0.124080604  0.528106736  1.212375148
      2006  HOL_TMB11H   HOL_MBUFH      55  0.097614000  0.260539250  0.720755553
      2008  HOL_TMB11H   HOL_MRBRH      73  0.095326145  0.547150742  0.812569529
      2010  HOL_TMB11H   HOL_PALZH      58  0.036518273  0.216776370  0.275890939
      2011  HOL_TMB11H   HOL_SQUSH      57  0.034766025  0.251901720  0.260322477
      2023  HOL_TMB11H   HOL_TRRSH      95  0.292290683  0.528807145  2.963270756
      2025  HOL_TMB11H   HOL_UNLUH      90  0.183344788  0.089926560  1.759497087
      2034  HOL_TMB12H   HOL_BICKH      77  0.325425741  0.335678517  3.000309909
      2035  HOL_TMB12H   HOL_BRBRH      54  0.127818031  0.254408087  0.938224974
      2037  HOL_TMB12H   HOL_DHROH     116  0.706576038  0.599445863 10.707725167
      2039  HOL_TMB12H   HOL_GKZBH      59  0.206204548  0.164828147  1.604898066
      2040  HOL_TMB12H   HOL_GUSTH      88  0.424427059  0.472487999  4.372123277
      2042  HOL_TMB12H   HOL_K9SAH     136  0.195051113  0.532215394  2.310669995
      2043  HOL_TMB12H   HOL_KBMBH     128  0.342397513  0.599927998  4.106862565
      2047  HOL_TMB12H   HOL_KORBH      97  0.060272067  0.476987801  0.591618811
      2051  HOL_TMB12H   HOL_LKBBH     108  0.544759440  0.603884425  6.719636026
      2052  HOL_TMB12H   HOL_LKSBH      70  0.225414032  0.489700927  1.921893219
      2053  HOL_TMB12H   HOL_LKSHH      66  0.402407134  0.466653142  3.543909245
      2055  HOL_TMB12H  HOL_MB253H     170 -0.233782014  0.649386617 -3.125784694
      2056  HOL_TMB12H  HOL_MB259H      70  0.270162719  0.572080219  2.330812081
      2059  HOL_TMB12H   HOL_MIWAH     129  0.708490105  0.429404283 11.358105284
      2064  HOL_TMB12H   HOL_TATEH     170  0.619914326  0.703885253 10.270421139
      2069  HOL_TMB12H  HOL_TMB21H      69  0.588313679  0.715455439  5.999458397
      2070  HOL_TMB12H  HOL_TMB22H      82  0.604236100  0.711063906  6.824910285
      2072  HOL_TMB12H HOL_TRMB32H      63  0.209259651  0.513574696  1.685018256
      2075  HOL_TMB12H   HOL_TRRSH      66  0.527584405  0.665662485  5.007072815
      2076  HOL_TMB12H   HOL_TWMLH     156  0.568477076  0.490006450  8.602759502
      2078  HOL_TMB12H   HOL_WEDEH     170  0.194899198  0.655967645  2.583227404
      2079  HOL_TMB12H   HOL_WEDGH     105  0.202818770  0.466712045  2.112254204
      2080  HOL_TMB12H   HOL_WEDWH     170  0.131540176  0.624961700  1.725011191
      2086  HOL_TMB21H   HOL_BICKH      69  0.308309538  0.249050794  2.672577261
      2087  HOL_TMB21H   HOL_BRBRH      54  0.141560682  0.182896209  1.041061243
      2091  HOL_TMB21H   HOL_GKZBH      59 -0.063652080  0.237617788 -0.485744818
      2092  HOL_TMB21H   HOL_GUSTH      69  0.125643831  0.308952578  1.044361703
      2094  HOL_TMB21H   HOL_K9SAH      69  0.225576266  0.360786854  1.909362385
      2095  HOL_TMB21H   HOL_KBMBH      69  0.472208117  0.657292845  4.417453099
      2103  HOL_TMB21H   HOL_LKBBH      69  0.356994329  0.436806035  3.151514830
      2104  HOL_TMB21H   HOL_LKSBH      69  0.223427090  0.528989194  1.890210280
      2105  HOL_TMB21H   HOL_LKSHH      66  0.377395037  0.500255379  3.285619874
      2107  HOL_TMB21H  HOL_MB253H      69  0.403444986  0.545565464  3.635932666
      2116  HOL_TMB21H   HOL_TATEH      69  0.128988583  0.640045352  1.072627749
      2120  HOL_TMB21H  HOL_TMB12H      69  0.588313679  0.715455439  5.999458397
      2122  HOL_TMB21H  HOL_TMB22H      69  0.243994066  0.343968275  2.074731802
      2127  HOL_TMB21H   HOL_TRRSH      66  0.352614484  0.407635316  3.038003847
      2128  HOL_TMB21H   HOL_TWMLH      69  0.368805637  0.381544691  3.271896507
      2130  HOL_TMB21H   HOL_WEDEH      69  0.539984432  0.506665865  5.290433575
      2131  HOL_TMB21H   HOL_WEDGH      56  0.344013864  0.275313942  2.717115409
      2132  HOL_TMB21H   HOL_WEDWH      69  0.523178137  0.438412294  5.062331889
      2138  HOL_TMB22H   HOL_BICKH      77  0.335960060  0.179517522  3.109571940
      2139  HOL_TMB22H   HOL_BRBRH      54  0.621466404  0.184390902  5.774965560
      2143  HOL_TMB22H   HOL_GKZBH      59 -0.109329770  0.077309696 -0.837652001
      2144  HOL_TMB22H   HOL_GUSTH      82  0.679291680  0.287488012  8.330683272
      2146  HOL_TMB22H   HOL_K9SAH      82  0.285254051  0.510479488  2.678576088
      2147  HOL_TMB22H   HOL_KBMBH      82  0.310896703  0.500502472  2.943962182
      2155  HOL_TMB22H   HOL_LKBBH      82  0.372160586  0.421610342  3.608661344
      2156  HOL_TMB22H   HOL_LKSBH      70  0.492548432  0.334379418  4.701235105
      2157  HOL_TMB22H   HOL_LKSHH      66  0.366729580  0.295082417  3.178093877
      2159  HOL_TMB22H  HOL_MB253H      82  0.136354296  0.416613457  1.238758497
      2163  HOL_TMB22H   HOL_MIWAH      58  0.378996713  0.229551518  3.092034329
      2168  HOL_TMB22H   HOL_TATEH      82  0.439051629  0.542447674  4.398032845
      2172  HOL_TMB22H  HOL_TMB12H      82  0.604236100  0.711063906  6.824910285
      2173  HOL_TMB22H  HOL_TMB21H      69  0.243994066  0.343968275  2.074731802
      2179  HOL_TMB22H   HOL_TRRSH      66 -0.140631520  0.640876355 -1.145188434
      2180  HOL_TMB22H   HOL_TWMLH      82  0.578858208  0.333909100  6.388942361
      2182  HOL_TMB22H   HOL_WEDEH      82  0.401701601  0.611292452  3.947838401
      2183  HOL_TMB22H   HOL_WEDGH      69  0.235451889  0.288916576  1.997750767
      2184  HOL_TMB22H   HOL_WEDWH      82  0.332048025  0.553712120  3.168187313
      2245 HOL_TRMB32H   HOL_DHROH      52  0.189234193  0.513346278  1.376268897
      2252 HOL_TRMB32H   HOL_KDGBH      83  0.174967773  0.450074872  1.609224207
      2255 HOL_TRMB32H   HOL_KORBH     133  0.454742390  0.496032610  5.866221945
      2263 HOL_TRMB32H  HOL_MB253H      71  0.517839579  0.675646409  5.064487993
      2264 HOL_TRMB32H  HOL_MB259H      77  0.529496800  0.459110314  5.441448946
      2272 HOL_TRMB32H   HOL_TATEH     104  0.131743114  0.419491509  1.348802895
      2273 HOL_TRMB32H   HOL_TATTH      85  0.199403579  0.115082789  1.865018306
      2276 HOL_TRMB32H  HOL_TMB12H      63  0.209259651  0.513574696  1.685018256
      2286 HOL_TRMB32H   HOL_WEDEH      90  0.131217727  0.568821850  1.248702376
      2288 HOL_TRMB32H   HOL_WEDWH      90  0.129635676  0.560523192  1.233388233
      2289   HOL_TRPBH   HOL_AAHOH      68  0.356284712  0.490183811  3.121132771
      2301   HOL_TRPBH   HOL_IRRBH      68  0.331075012  0.425255566  2.871929864
      2303   HOL_TRPBH   HOL_KBMBH      68  0.410963063  0.372995637  3.689870330
      2306   HOL_TRPBH   HOL_KMBQH      68 -0.026148714  0.388887146 -0.214109657
      2310   HOL_TRPBH   HOL_LATEH      68  0.259949997 -0.011459399  2.203535398
      2318   HOL_TRPBH   HOL_MBUFH      64  0.616201031  0.552756931  6.210021493
      2320   HOL_TRPBH   HOL_MRBRH      60  0.694007691  0.544136181  7.404186431
      2322   HOL_TRPBH   HOL_PALZH      68  0.372446788  0.529021190  3.284948749
      2323   HOL_TRPBH   HOL_SQUSH      68  0.417077201  0.301546782  3.756224803
      2334   HOL_TRPBH   HOL_TRRBH      68  0.079866946  0.506071379  0.655834172
      2335   HOL_TRPBH   HOL_TRRSH      68  0.233784624  0.462847802  1.968150197
      2337   HOL_TRPBH   HOL_UNLUH      68 -0.287785101  0.044421369 -2.459679277
      2341   HOL_TRRBH   HOL_AAHOH     101  0.158422177  0.533836233  1.604484047
      2343   HOL_TRRBH   HOL_BDN2H     276  0.252126581  0.518011876  4.320627392
      2353   HOL_TRRBH   HOL_IRRBH     101  0.112710306  0.501053287  1.134331145
      2355   HOL_TRRBH   HOL_KBMBH      87  0.107651532  0.669123266  1.004154697
      2358   HOL_TRRBH   HOL_KMBQH      95  0.269473726  0.309999844  2.713004881
      2361   HOL_TRRBH   HOL_LAGEH      58  0.422119379  0.394990644  3.515488051
      2362   HOL_TRRBH   HOL_LATEH     317  0.019928936  0.061802157  0.354334887
      2366   HOL_TRRBH   HOL_MANCH     217  0.191327279  0.336500430  2.864849627
      2370   HOL_TRRBH   HOL_MBUFH      70  0.383379749  0.716668333  3.448054449
      2372   HOL_TRRBH   HOL_MRBRH      66  0.153066164  0.733701800  1.248774495
      2374   HOL_TRRBH   HOL_PALZH     187  0.195043502  0.768677386  2.712126203
      2375   HOL_TRRBH   HOL_SQUSH     101  0.131502723  0.444094893  1.326547219
      2378   HOL_TRRBH   HOL_TITEH      84  0.492660184  0.478859809  5.157705774
      2385   HOL_TRRBH   HOL_TRPBH      68  0.079866946  0.506071379  0.655834172
      2387   HOL_TRRBH   HOL_TRRSH     101  0.147773875  0.638429609  1.494142682
      2389   HOL_TRRBH   HOL_UNLUH     132  0.148901656  0.168033940  1.723470580
      2393   HOL_TRRSH   HOL_AAHOH     187  0.332296592  0.458285337  4.804963625
      2395   HOL_TRRSH   HOL_BDN2H      60  0.435542796  0.176853289  3.716492486
      2398   HOL_TRRSH   HOL_BICKH      66  0.099903053  0.211226084  0.809493917
      2399   HOL_TRRSH   HOL_BRBRH     153 -0.037596570  0.314223987 -0.463849589
      2403   HOL_TRRSH   HOL_GKZBH     148 -0.188090442  0.259036387 -2.321917665
      2404   HOL_TRRSH   HOL_GUSTH      66 -0.185446513  0.338579482 -1.521509137
      2405   HOL_TRRSH   HOL_IRRBH     202  0.397034405  0.303430429  6.133047854
      2406   HOL_TRRSH   HOL_K9SAH     101  0.353085800  0.463439523  3.773933482
      2407   HOL_TRRSH   HOL_KBMBH     251  0.389238024  0.574039069  6.681299456
      2410   HOL_TRRSH   HOL_KMBQH     122  0.128799278  0.389133386  1.428692088
      2412   HOL_TRRSH   HOL_KORHH      85  0.642772074  0.480783259  7.690158418
      2414   HOL_TRRSH   HOL_LATEH     103  0.239689088  0.032238120  2.493425221
      2415   HOL_TRRSH   HOL_LKBBH     165 -0.089227628  0.513661005 -1.147247245
      2416   HOL_TRRSH   HOL_LKSBH     196 -0.053779651  0.461660810 -0.752080348
      2417   HOL_TRRSH   HOL_LKSHH     212  0.088249244  0.415316109  1.286915306
      2419   HOL_TRRSH  HOL_MB253H      66  0.643374022  0.556914738  6.775564788
      2421   HOL_TRRSH   HOL_MBRUH     100  0.460348649  0.584573346  5.159641879
      2422   HOL_TRRSH   HOL_MBUFH     124  0.446763833  0.670593303  5.538299791
      2424   HOL_TRRSH   HOL_MRBRH     138  0.377208429  0.624626688  4.767277942
      2426   HOL_TRRSH   HOL_PALZH     158  0.416785660  0.624806906  5.745084501
      2427   HOL_TRRSH   HOL_SQUSH     157  0.494324809  0.529997977  7.102584007
      2428   HOL_TRRSH   HOL_TATEH      72  0.158143461  0.432379215  1.349522681
      2431   HOL_TRRSH  HOL_TMB11H      95  0.292290683  0.528807145  2.963270756
      2432   HOL_TRRSH  HOL_TMB12H      66  0.527584405  0.665662485  5.007072815
      2433   HOL_TRRSH  HOL_TMB21H      66  0.352614484  0.407635316  3.038003847
      2434   HOL_TRRSH  HOL_TMB22H      66 -0.140631520  0.640876355 -1.145188434
      2437   HOL_TRRSH   HOL_TRPBH      68  0.233784624  0.462847802  1.968150197
      2438   HOL_TRRSH   HOL_TRRBH     101  0.147773875  0.638429609  1.494142682
      2440   HOL_TRRSH   HOL_TWMLH     110 -0.105790202  0.444866315 -1.110714945
      2441   HOL_TRRSH   HOL_UNLUH     190  0.188200834  0.214330284  2.634409102
      2442   HOL_TRRSH   HOL_WEDEH      76  0.402791132  0.435415383  3.811104891
      2443   HOL_TRRSH   HOL_WEDGH      53  0.474964442  0.258843606  3.892043052
      2444   HOL_TRRSH   HOL_WEDWH      76  0.427268723  0.359800846  4.092638732
      2450   HOL_TWMLH   HOL_BICKH      77  0.330742957  0.319830826  3.055299845
      2451   HOL_TWMLH   HOL_BRBRH      98  0.488033063  0.189688375  5.506908557
      2453   HOL_TWMLH   HOL_DHROH     113  0.301798507  0.323127643  3.350146719
      2455   HOL_TWMLH   HOL_GKZBH     103  0.183764564  0.242532939  1.888084658
      2456   HOL_TWMLH   HOL_GUSTH      88  0.492230094  0.303859893  5.274440684
      2458   HOL_TWMLH   HOL_K9SAH     171  0.158939070  0.428712893  2.098993510
      2459   HOL_TWMLH   HOL_KBMBH     172  0.015844598  0.232887482  0.207221017
      2463   HOL_TWMLH   HOL_KORBH      83  0.171363922  0.387056412  1.575064993
      2467   HOL_TWMLH   HOL_LKBBH     152  0.566824381  0.312159966  8.454634421
      2468   HOL_TWMLH   HOL_LKSBH     114  0.509604090  0.371210304  6.296035594
      2469   HOL_TWMLH   HOL_LKSHH     110  0.420838212  0.200631160  4.843464834
      2471   HOL_TWMLH  HOL_MB253H     156 -0.146541730  0.365020421 -1.844340427
      2472   HOL_TWMLH  HOL_MB259H      56  0.024214611  0.517503480  0.179633036
      2475   HOL_TWMLH   HOL_MIWAH     129  0.281844726  0.221487629  3.323441277
      2480   HOL_TWMLH   HOL_TATEH     162  0.407060207  0.361545478  5.654704931
      2484   HOL_TWMLH  HOL_TMB12H     156  0.568477076  0.490006450  8.602759502
      2485   HOL_TWMLH  HOL_TMB21H      69  0.368805637  0.381544691  3.271896507
      2486   HOL_TWMLH  HOL_TMB22H      82  0.578858208  0.333909100  6.388942361
      2491   HOL_TWMLH   HOL_TRRSH     110 -0.105790202  0.444866315 -1.110714945
      2494   HOL_TWMLH   HOL_WEDEH     166  0.197003573  0.334921921  2.581139912
      2495   HOL_TWMLH   HOL_WEDGH     105  0.226324375  0.131401013  2.369549920
      2496   HOL_TWMLH   HOL_WEDWH     166  0.113962643  0.284310730  1.473476302
      2497   HOL_UNLUH   HOL_AAHOH     187 -0.031712669  0.064022899 -0.432720785
      2499   HOL_UNLUH   HOL_BDN2H      91  0.064324801  0.242647987  0.611505061
      2503   HOL_UNLUH   HOL_BRBRH      90  0.234093805  0.107941312  2.271553900
      2507   HOL_UNLUH   HOL_GKZBH      80  0.086962224  0.054221366  0.775876473
      2509   HOL_UNLUH   HOL_IRRBH     190  0.141304936  0.152727979  1.962311295
      2511   HOL_UNLUH   HOL_KBMBH     176  0.360137445  0.271504589  5.106843594
      2514   HOL_UNLUH   HOL_KMBQH     122  0.217656631  0.180615553  2.453033421
      2516   HOL_UNLUH   HOL_KORHH      85  0.120928149 -0.087497523  1.116518626
      2518   HOL_UNLUH   HOL_LATEH     134 -0.033085444 -0.025515608 -0.381768966
      2519   HOL_UNLUH   HOL_LKBBH      90  0.114272999  0.144795007  1.085157762
      2520   HOL_UNLUH   HOL_LKSBH     121  0.114516712  0.150898944  1.262775114
      2521   HOL_UNLUH   HOL_LKSHH     137  0.320611330  0.141760093  3.947313870
      2525   HOL_UNLUH   HOL_MBRUH      90  0.176705007  0.138971604  1.693683748
      2526   HOL_UNLUH   HOL_MBUFH     124  0.305811681  0.240252770  3.562277112
      2528   HOL_UNLUH   HOL_MRBRH     138 -0.110182054  0.109825237 -1.297548098
      2530   HOL_UNLUH   HOL_PALZH     189  0.256579127  0.216520771  3.639887423
      2531   HOL_UNLUH   HOL_SQUSH     157  0.135298979  0.030077818  1.705566702
      2535   HOL_UNLUH  HOL_TMB11H      90  0.183344788  0.089926560  1.759497087
      2541   HOL_UNLUH   HOL_TRPBH      68 -0.287785101  0.044421369 -2.459679277
      2542   HOL_UNLUH   HOL_TRRBH     132  0.148901656  0.168033940  1.723470580
      2543   HOL_UNLUH   HOL_TRRSH     190  0.188200834  0.214330284  2.634409102
      2554   HOL_WEDEH   HOL_BICKH      77  0.334837187  0.220952568  3.097864025
      2555   HOL_WEDEH   HOL_BRBRH      64  0.274358628  0.258833452  2.264550695
      2557   HOL_WEDEH   HOL_DHROH     116  0.386904490  0.516880163  4.499511282
      2559   HOL_WEDEH   HOL_GKZBH      69  0.156149106  0.240202586  1.303629490
      2560   HOL_WEDEH   HOL_GUSTH      88  0.181442734  0.147711923  1.720950333
      2562   HOL_WEDEH   HOL_K9SAH     146  0.216597331  0.403352862  2.671598235
      2563   HOL_WEDEH   HOL_KBMBH     138  0.452358388  0.500901295  5.936873740
      2567   HOL_WEDEH   HOL_KORBH     124  0.253383305  0.405401632  2.904957292
      2571   HOL_WEDEH   HOL_LKBBH     118  0.347653246  0.485822075  4.010614194
      2572   HOL_WEDEH   HOL_LKSBH      80  0.264211526  0.426866051  2.434887735
      2573   HOL_WEDEH   HOL_LKSHH      76  0.218206049  0.284314989  1.936381342
      2575   HOL_WEDEH  HOL_MB253H     178  0.459390150  0.530474537  6.880826860
      2576   HOL_WEDEH  HOL_MB259H      84  0.151884006  0.569579263  1.399971159
      2579   HOL_WEDEH   HOL_MIWAH     129  0.070142752  0.495090767  0.795534074
      2584   HOL_WEDEH   HOL_TATEH     203  0.167580256  0.488892214  2.415927937
      2585   HOL_WEDEH   HOL_TATTH      63 -0.146651421  0.187191262 -1.167355621
      2588   HOL_WEDEH  HOL_TMB12H     170  0.194899198  0.655967645  2.583227404
      2589   HOL_WEDEH  HOL_TMB21H      69  0.539984432  0.506665865  5.290433575
      2590   HOL_WEDEH  HOL_TMB22H      82  0.401701601  0.611292452  3.947838401
      2592   HOL_WEDEH HOL_TRMB32H      90  0.131217727  0.568821850  1.248702376
      2595   HOL_WEDEH   HOL_TRRSH      76  0.402791132  0.435415383  3.811104891
      2596   HOL_WEDEH   HOL_TWMLH     166  0.197003573  0.334921921  2.581139912
      2599   HOL_WEDEH   HOL_WEDGH     105  0.523920912  0.440305026  6.272802818
      2600   HOL_WEDEH   HOL_WEDWH     207  0.978905719  0.968930120 68.766917325
      2606   HOL_WEDGH   HOL_BICKH      64  0.327289636 -0.116183942  2.749195457
      2609   HOL_WEDGH   HOL_DHROH      75  0.620845102  0.583970783  6.812711955
      2612   HOL_WEDGH   HOL_GUSTH      75  0.114871224  0.251548967  0.994744452
      2614   HOL_WEDGH   HOL_K9SAH     105  0.002461062  0.347195026  0.025098086
      2615   HOL_WEDGH   HOL_KBMBH     105  0.186686657  0.322246064  1.937907171
      2623   HOL_WEDGH   HOL_LKBBH      95  0.341031432  0.407961750  3.517276474
      2624   HOL_WEDGH   HOL_LKSBH      57  0.037667612  0.173995168  0.282078779
      2625   HOL_WEDGH   HOL_LKSHH      53  0.170916909  0.297401147  1.250905881
      2627   HOL_WEDGH  HOL_MB253H     105  0.270299737  0.374831539  2.863102772
      2631   HOL_WEDGH   HOL_MIWAH      94  0.016502954  0.460010471  0.159170400
      2636   HOL_WEDGH   HOL_TATEH     105  0.136123890  0.346128904  1.401239729
      2640   HOL_WEDGH  HOL_TMB12H     105  0.202818770  0.466712045  2.112254204
      2641   HOL_WEDGH  HOL_TMB21H      56  0.344013864  0.275313942  2.717115409
      2642   HOL_WEDGH  HOL_TMB22H      69  0.235451889  0.288916576  1.997750767
      2647   HOL_WEDGH   HOL_TRRSH      53  0.474964442  0.258843606  3.892043052
      2648   HOL_WEDGH   HOL_TWMLH     105  0.226324375  0.131401013  2.369549920
      2650   HOL_WEDGH   HOL_WEDEH     105  0.523920912  0.440305026  6.272802818
      2652   HOL_WEDGH   HOL_WEDWH     105  0.534250550  0.458507159  6.445213809
      2658   HOL_WEDWH   HOL_BICKH      77  0.308287116  0.173699858  2.825190294
      2659   HOL_WEDWH   HOL_BRBRH      64  0.225918357  0.241293227  1.840761985
      2661   HOL_WEDWH   HOL_DHROH     116  0.394374162  0.519431179  4.602200268
      2663   HOL_WEDWH   HOL_GKZBH      69  0.123656717  0.218464883  1.027586074
      2664   HOL_WEDWH   HOL_GUSTH      88  0.112537983  0.078855364  1.056395260
      2666   HOL_WEDWH   HOL_K9SAH     146  0.194764476  0.380558863  2.391063634
      2667   HOL_WEDWH   HOL_KBMBH     138  0.430539452  0.438924058  5.583306851
      2671   HOL_WEDWH   HOL_KORBH     124  0.225610729  0.415516720  2.568362760
      2675   HOL_WEDWH   HOL_LKBBH     118  0.265138039  0.467384322  2.974357247
      2676   HOL_WEDWH   HOL_LKSBH      80  0.168797282  0.389698539  1.522144639
      2677   HOL_WEDWH   HOL_LKSHH      76  0.196719235  0.282650191  1.737591326
      2679   HOL_WEDWH  HOL_MB253H     178  0.475733073  0.497914415  7.195646867
      2680   HOL_WEDWH  HOL_MB259H      84  0.162768833  0.557212425  1.502937465
      2683   HOL_WEDWH   HOL_MIWAH     129  0.030091643  0.477594560  0.340602321
      2688   HOL_WEDWH   HOL_TATEH     203  0.077051683  0.479001680  1.098375539
      2689   HOL_WEDWH   HOL_TATTH      63 -0.184679599  0.145794377 -1.479619881
      2692   HOL_WEDWH  HOL_TMB12H     170  0.131540176  0.624961700  1.725011191
      2693   HOL_WEDWH  HOL_TMB21H      69  0.523178137  0.438412294  5.062331889
      2694   HOL_WEDWH  HOL_TMB22H      82  0.332048025  0.553712120  3.168187313
      2696   HOL_WEDWH HOL_TRMB32H      90  0.129635676  0.560523192  1.233388233
      2699   HOL_WEDWH   HOL_TRRSH      76  0.427268723  0.359800846  4.092638732
      2700   HOL_WEDWH   HOL_TWMLH     166  0.113962643  0.284310730  1.473476302
      2702   HOL_WEDWH   HOL_WEDEH     207  0.978905719  0.968930120 68.766917325
      2703   HOL_WEDWH   HOL_WEDGH     105  0.534250550  0.458507159  6.445213809
                 t_hol       sgc       ssgc            p
      3     3.78461454 0.6610169 0.03389831 1.337634e-02
      7     2.30966394 0.5697674 0.04651163 1.956677e-01
      11    2.50828143 0.5657895 0.05263158 2.513491e-01
      13    5.82196912 0.5913978 0.04838710 1.266685e-02
      15    5.95643279 0.6046512 0.04651163 6.051564e-03
      18    8.03865634 0.7520661 0.06611570 2.931915e-08
      20    2.74691328 0.5476190 0.03571429 3.827331e-01
      22    2.06726998 0.5392157 0.03921569 4.282919e-01
      23    3.19224325 0.5581395 0.03488372 2.808875e-01
      24    6.19671953 0.6239316 0.03418803 7.339134e-03
      25    2.89925600 0.5338346 0.03759398 4.351561e-01
      29    4.77429753 0.6162791 0.05813953 3.103252e-02
      30    6.23943859 0.7073171 0.03252033 4.255128e-06
      32    7.86749352 0.6642336 0.05839416 1.207446e-04
      34    5.79740652 0.6369427 0.03184713 5.996479e-04
      35    4.87595238 0.6089744 0.05128205 6.485308e-03
      39    4.19432051 0.6279070 0.04651163 1.767673e-02
      45    4.56882160 0.6417910 0.04477612 2.027500e-02
      46    6.28155102 0.7000000 0.04000000 6.334248e-05
      47    7.01318469 0.6559140 0.05376344 2.111459e-05
      49    0.87259576 0.5322581 0.04301075 3.789229e-01
      105   3.78461454 0.6610169 0.03389831 1.337634e-02
      117   5.65616643 0.6949153 0.01694915 2.750348e-03
      122   1.57587655 0.6226415 0.01886792 7.414990e-02
      125   2.71847842 0.6491228 0.05263158 2.434092e-02
      126   1.46530832 0.4830769 0.03692308 1.458251e+00
      130   3.31077605 0.5377778 0.02666667 2.570743e-01
      138   5.38463941 0.6275862 0.01379310 2.121439e-03
      139   0.70943739 0.5084746 0.05084746 8.964170e-01
      142   3.25559723 0.5542169 0.02409639 3.232122e-01
      150  10.02441978 0.6327273 0.05090909 1.072251e-05
      151   1.36844501 0.5254237 0.03389831 6.961175e-01
      153   2.35965627 0.6000000 0.00000000 5.777957e-02
      161   1.42889764 0.6379310 0.01724138 3.564949e-02
      164   2.30485004 0.5441176 0.08823529 4.668543e-01
      173   1.89724941 0.6911765 0.02941176 1.616222e-03
      175   2.59891146 0.6451613 0.00000000 2.225412e-02
      212   1.42889764 0.6379310 0.01724138 3.564949e-02
      216   2.65170649 0.5388128 0.08219178 2.506576e-01
      218   0.48059910 0.4456522 0.08695652 1.702853e+00
      225   4.80992577 0.6255507 0.06167401 1.548107e-04
      227   1.29998293 0.5192308 0.00000000 7.815113e-01
      241   1.82161324 0.4765101 0.10067114 1.433668e+00
      267   1.86771223 0.4716981 0.05660377 1.319720e+00
      271   3.75623663 0.6034483 0.10344828 1.151002e-01
      272   3.74969864 0.6052632 0.01315789 6.645742e-02
      274   0.82720045 0.6052632 0.01315789 6.645742e-02
      275   2.68068371 0.6315789 0.00000000 2.178146e-02
      283   3.10524264 0.6052632 0.02631579 6.645742e-02
      284   1.53881908 0.5072464 0.04347826 9.041775e-01
      285   1.16559774 0.5384615 0.00000000 5.351435e-01
      287   2.75741594 0.6447368 0.02631579 1.161689e-02
      291   0.75308613 0.5769231 0.00000000 2.672575e-01
      296   2.99345060 0.5921053 0.01315789 1.082937e-01
      300   3.08612890 0.5921053 0.02631579 1.082937e-01
      301   2.10489289 0.5441176 0.02941176 4.668543e-01
      302   1.58034033 0.5921053 0.02631579 1.082937e-01
      307   1.72881554 0.6000000 0.00000000 1.068637e-01
      308   2.92336703 0.6842105 0.02631579 1.318969e-03
      310   1.96199700 0.5789474 0.00000000 1.686686e-01
      311  -0.92107103 0.5396825 0.03174603 5.287333e-01
      312   1.52750505 0.5657895 0.00000000 2.513491e-01
      313   2.30966394 0.5697674 0.04651163 1.956677e-01
      318   1.86771223 0.4716981 0.05660377 1.319720e+00
      323   3.95891351 0.5492958 0.07042254 2.400532e-01
      324   1.48057699 0.4339623 0.07547170 1.663711e+00
      325   1.16340370 0.5148515 0.02970297 7.653131e-01
      326   1.86272118 0.5681818 0.04545455 2.008251e-01
      327   2.81337721 0.5460526 0.04605263 2.561450e-01
      332   1.84196442 0.5833333 0.01190476 1.266305e-01
      335   5.54335130 0.6118421 0.03289474 5.819817e-03
      336   4.26055439 0.6250000 0.04605263 2.054719e-03
      337   2.91566650 0.5723684 0.04605263 7.435291e-02
      339   0.79597722 0.4905660 0.07547170 1.109254e+00
      341   2.81031788 0.5757576 0.03030303 1.316680e-01
      342   3.12518114 0.5740741 0.03703704 2.763029e-01
      344   2.42096130 0.5694444 0.04166667 2.385928e-01
      346   0.57397454 0.4912281 0.01754386 1.105374e+00
      347   1.55150174 0.6250000 0.01785714 6.136883e-02
      348   1.47107898 0.5254237 0.06779661 6.961175e-01
      351   2.99662212 0.6063830 0.03191489 3.912760e-02
      352   1.89697919 0.5660377 0.03773585 3.362888e-01
      353   1.34151163 0.4716981 0.07547170 1.319720e+00
      354   1.35285919 0.4905660 0.09433962 1.109254e+00
      359   4.06726031 0.6118421 0.04605263 5.819817e-03
      360   1.89292623 0.6288660 0.06185567 1.113716e-02
      361   1.01853026 0.4382022 0.03370787 1.756385e+00
      362   2.10995993 0.6190476 0.04761905 5.878172e-02
      364   1.95779314 0.6031746 0.04761905 1.014538e-01
      368   2.30485004 0.5441176 0.08823529 4.668543e-01
      369   2.65170649 0.5388128 0.08219178 2.506576e-01
      374  -1.08153866 0.4130435 0.04347826 1.904707e+00
      381   4.91884435 0.5826087 0.06086957 1.222280e-02
      383   3.96049640 0.5797101 0.07246377 1.854219e-01
      397   0.11097661 0.5098039 0.04901961 8.430220e-01
      430   4.61442952 0.6630435 0.03260870 1.761702e-03
      431   5.16997366 0.6547619 0.04761905 4.556350e-03
      435   2.42439291 0.5647059 0.03529412 2.328234e-01
      439   5.07928700 0.5468750 0.07812500 4.532547e-01
      443   6.64646762 0.6000000 0.05217391 3.197196e-02
      444   3.82436744 0.6896552 0.05172414 3.867869e-03
      447   5.13638087 0.5963303 0.06422018 4.427951e-02
      452   4.92482298 0.5565217 0.03478261 2.254143e-01
      456   7.99626189 0.5565217 0.09565217 2.254143e-01
      460   4.22976500 0.6666667 0.05882353 1.729028e-02
      464   3.59733880 0.6339286 0.06250000 4.586392e-03
      466   6.44672611 0.6521739 0.04347826 1.099416e-03
      467   6.14634665 0.5945946 0.04054054 1.036380e-01
      468   6.49026050 0.6434783 0.04347826 2.089089e-03
      473   0.48059910 0.4456522 0.08695652 1.702853e+00
      476  -1.08153866 0.4130435 0.04347826 1.904707e+00
      485  -0.24445426 0.4673913 0.05434783 1.468385e+00
      501   2.08136273 0.4725275 0.05494505 1.399821e+00
      521   2.50828143 0.5657895 0.05263158 2.513491e-01
      526   3.75623663 0.6034483 0.10344828 1.151002e-01
      527   3.95891351 0.5492958 0.07042254 2.400532e-01
      532   4.00196380 0.5344828 0.12068966 5.994263e-01
      533   3.16297812 0.6593407 0.02197802 2.365577e-03
      534  -0.36241090 0.4946237 0.05376344 1.082589e+00
      535   3.87703068 0.5918367 0.06802721 2.595246e-02
      540   5.48045426 0.7567568 0.01351351 9.989052e-06
      543   5.05001502 0.6054422 0.05442177 1.056287e-02
      544   4.79893676 0.6190476 0.06802721 3.892417e-03
      545   2.09469438 0.5102041 0.06802721 8.045709e-01
      547   1.31148877 0.5344828 0.12068966 5.994263e-01
      549   5.51878806 0.6516854 0.03370787 4.209845e-03
      552   4.45880423 0.6612903 0.06451613 1.108517e-02
      556   1.82002078 0.5312500 0.10937500 6.170751e-01
      559   3.29493506 0.5595238 0.03571429 2.752335e-01
      560   1.26168213 0.5862069 0.12068966 1.891613e-01
      561   1.84687170 0.5689655 0.13793103 2.935106e-01
      562   0.58542752 0.5000000 0.13793103 1.000000e+00
      567   3.24055667 0.5986395 0.06802721 1.676234e-02
      568   2.51243934 0.6274510 0.07843137 1.004189e-02
      569   0.47957563 0.4683544 0.03797468 1.426255e+00
      570   2.02544221 0.6029412 0.08823529 8.955507e-02
      572   1.83247594 0.5882353 0.08823529 1.456101e-01
      578   3.74969864 0.6052632 0.01315789 6.645742e-02
      579   1.48057699 0.4339623 0.07547170 1.663711e+00
      583   4.00196380 0.5344828 0.12068966 5.994263e-01
      586   2.18842902 0.5287356 0.03448276 5.919197e-01
      587   3.68698591 0.5862069 0.02298851 1.077982e-01
      595   4.00484984 0.5517241 0.04597701 3.345943e-01
      596   2.38640296 0.5362319 0.05797101 5.472212e-01
      597   1.67679668 0.4461538 0.01538462 1.614739e+00
      599   6.15012923 0.6781609 0.05747126 8.887985e-04
      603   1.70141854 0.5555556 0.03174603 3.778216e-01
      608   2.97302305 0.5287356 0.03448276 5.919197e-01
      612   4.97162031 0.5287356 0.05747126 5.919197e-01
      613   2.65896942 0.5000000 0.04411765 1.000000e+00
      614   2.68470795 0.5925926 0.03703704 9.558070e-02
      619   2.87865561 0.5384615 0.01538462 5.351435e-01
      620   2.95773197 0.5057471 0.04597701 9.146214e-01
      622   1.38501707 0.5057471 0.02298851 9.146214e-01
      623   2.22064098 0.5675676 0.05405405 2.450420e-01
      624   0.73355882 0.5172414 0.02298851 7.477302e-01
      625   5.82196912 0.5913978 0.04838710 1.266685e-02
      627   5.65616643 0.6949153 0.01694915 2.750348e-03
      631   1.16340370 0.5148515 0.02970297 7.653131e-01
      635   3.16297812 0.6593407 0.02197802 2.365577e-03
      639   4.46732036 0.6042781 0.04278075 4.345023e-03
      642   2.42608350 0.6198347 0.06611570 8.379987e-03
      644   2.91564321 0.6428571 0.02380952 8.828761e-03
      646   2.01908631 0.5490196 0.04901961 3.221020e-01
      647   2.54085805 0.6633663 0.01980198 1.024820e-03
      648   4.72205843 0.6590909 0.03787879 2.565504e-04
      649   2.43025790 0.5405405 0.04054054 3.239398e-01
      653   2.47668430 0.6060606 0.04040404 3.480848e-02
      654   4.93486656 0.6422764 0.04065041 1.600346e-03
      656   4.37525776 0.6569343 0.06569343 2.390279e-04
      658   5.59216119 0.6114650 0.03184713 5.217262e-03
      659   2.55185611 0.5384615 0.05128205 3.366684e-01
      663   5.42803973 0.7127660 0.04255319 3.696329e-05
      669   3.81714110 0.6119403 0.04477612 6.687076e-02
      670   5.76071481 0.6700000 0.06000000 6.738585e-04
      671   4.50347702 0.6169154 0.04477612 9.160235e-04
      673   2.11895961 0.5343915 0.03703704 3.443471e-01
      682   0.82720045 0.6052632 0.01315789 6.645742e-02
      683   1.86272118 0.5681818 0.04545455 2.008251e-01
      685   4.61442952 0.6630435 0.03260870 1.761702e-03
      687  -0.36241090 0.4946237 0.05376344 1.082589e+00
      688   2.18842902 0.5287356 0.03448276 5.919197e-01
      691   4.48709964 0.5740741 0.03086420 5.934644e-02
      695   4.01546036 0.6612903 0.03225806 1.108517e-02
      699   2.96978254 0.5915493 0.04225352 2.911902e-02
      700   3.73088261 0.6057692 0.04807692 3.098405e-02
      701   1.23565226 0.5400000 0.03000000 4.237108e-01
      703   6.05108234 0.6222222 0.03703704 4.508698e-03
      707   3.92118181 0.5945946 0.04504505 4.623607e-02
      712   4.69696814 0.6028369 0.02127660 1.459642e-02
      716   7.27707678 0.6074074 0.06666667 1.256300e-02
      717   3.16643228 0.5441176 0.04411765 4.668543e-01
      718   5.30982767 0.7160494 0.03703704 1.007042e-04
      723   5.20372019 0.6200000 0.01000000 1.639507e-02
      724   6.16893514 0.6411765 0.03529412 2.319277e-04
      726   5.28961625 0.6413793 0.02068966 6.619685e-04
      727   3.75738021 0.5769231 0.03846154 1.166645e-01
      728   4.93827875 0.6275862 0.02068966 2.121439e-03
      729   5.95643279 0.6046512 0.04651163 6.051564e-03
      734   2.68068371 0.6315789 0.00000000 2.178146e-02
      735   2.81337721 0.5460526 0.04605263 2.561450e-01
      737   5.16997366 0.6547619 0.04761905 4.556350e-03
      739   3.87703068 0.5918367 0.06802721 2.595246e-02
      740   3.68698591 0.5862069 0.02298851 1.077982e-01
      741   4.46732036 0.6042781 0.04278075 4.345023e-03
      742   4.48709964 0.5740741 0.03086420 5.934644e-02
      746   4.29650938 0.6017699 0.05309735 3.049061e-02
      747   2.49914563 0.5925926 0.03703704 1.735682e-01
      748   4.28966940 0.6071429 0.02380952 4.953461e-02
      750   1.83983900 0.5340909 0.02272727 5.224313e-01
      751   9.77819860 0.6796117 0.03398058 2.525176e-07
      752   8.46160296 0.6582915 0.03015075 7.971363e-06
      753   7.63163726 0.6303318 0.02843602 1.528725e-04
      755   5.75094395 0.6614173 0.03149606 2.745910e-04
      757   7.29524881 0.6767677 0.05050505 4.354152e-04
      758   9.12366726 0.7235772 0.02439024 7.079026e-07
      759   3.83440260 0.6310680 0.03883495 7.805044e-03
      760   8.18953660 0.6861314 0.05109489 1.317224e-05
      762   6.65972704 0.6293706 0.02797203 1.974140e-03
      763   5.27627051 0.6267606 0.04225352 2.518974e-03
      764   5.25715694 0.6090226 0.01503759 1.191611e-02
      767   3.82917418 0.5851064 0.05319149 9.888691e-02
      768   8.41715072 0.6535433 0.06299213 5.387921e-04
      769   7.13896237 0.6029412 0.02941176 8.955507e-02
      770   5.17090062 0.6419753 0.02469136 1.060184e-02
      773   3.26592239 0.6268657 0.01492537 3.781258e-02
      774   8.30115022 0.7674419 0.04651163 7.038165e-07
      775  11.06237782 0.6720000 0.03200000 5.354511e-08
      776   3.12233393 0.5438596 0.04093567 2.513491e-01
      777   3.72116924 0.6228571 0.04000000 1.152045e-03
      778   6.74920035 0.7153285 0.01459854 4.638074e-07
      779   3.45472966 0.6730769 0.01923077 4.154176e-04
      780   5.69677517 0.7153285 0.01459854 4.638074e-07
      799   4.89818219 0.6341463 0.01219512 1.511993e-02
      816   4.11487352 0.6666667 0.00000000 1.430588e-02
      817   0.99710476 0.5161290 0.06451613 7.994954e-01
      824   4.53607556 0.6219512 0.03658537 2.720035e-02
      836   1.89724941 0.6911765 0.02941176 1.616222e-03
      837   4.80992577 0.6255507 0.06167401 1.548107e-04
      840   4.91884435 0.5826087 0.06086957 1.222280e-02
      842  -0.24445426 0.4673913 0.05434783 1.468385e+00
      851   3.86654627 0.6190476 0.01587302 5.878172e-02
      865   0.44355997 0.4909091 0.04545455 1.151233e+00
      885   8.03865634 0.7520661 0.06611570 2.931915e-08
      887   1.57587655 0.6226415 0.01886792 7.414990e-02
      897   2.42608350 0.6198347 0.06611570 8.379987e-03
      899   4.29650938 0.6017699 0.05309735 3.049061e-02
      906   1.29540364 0.5104167 0.04166667 8.382565e-01
      908   3.08016101 0.5689655 0.08620690 2.935106e-01
      909   4.06637381 0.6216216 0.05405405 3.639761e-02
      914   5.59267905 0.6770833 0.05208333 5.202443e-04
      916   4.62048927 0.6195652 0.07608696 2.181012e-02
      918   3.86295977 0.5537190 0.04958678 2.372779e-01
      919   2.83967873 0.5702479 0.07438017 1.222364e-01
      929   3.42926753 0.5522388 0.04477612 3.924481e-01
      930   3.14443581 0.6276596 0.06382979 1.330829e-02
      931   4.62747357 0.6611570 0.04958678 3.919366e-04
      933   2.01162795 0.5123967 0.04958678 7.850629e-01
      940   2.59891146 0.6451613 0.00000000 2.225412e-02
      941   1.29998293 0.5192308 0.00000000 7.815113e-01
      944   3.96049640 0.5797101 0.07246377 1.854219e-01
      945   2.42439291 0.5647059 0.03529412 2.328234e-01
      950   4.01546036 0.6612903 0.03225806 1.108517e-02
      951   2.49914563 0.5925926 0.03703704 1.735682e-01
      952   4.89818219 0.6341463 0.01219512 1.511993e-02
      953   3.86654627 0.6190476 0.01587302 5.878172e-02
      963   7.82593561 0.7019231 0.02884615 3.814478e-05
      964   4.11736405 0.6867470 0.02409639 6.672544e-04
      967   2.62363077 0.5949367 0.05063291 9.148192e-02
      972   6.92748028 0.6861314 0.00729927 1.317224e-05
      973   0.39000809 0.5595238 0.05952381 2.752335e-01
      976   5.28962289 0.6354167 0.07291667 7.963489e-03
      980   6.53843979 0.7045455 0.02272727 2.600383e-06
      984   3.77797831 0.6585366 0.04878049 4.088913e-03
      986   4.89838960 0.5934959 0.02439024 3.809416e-02
      988   5.04574004 0.6016260 0.01626016 2.418522e-02
      989   2.74691328 0.5476190 0.03571429 3.827331e-01
      995   1.84196442 0.5833333 0.01190476 1.266305e-01
      999   5.48045426 0.7567568 0.01351351 9.989052e-06
      1001  2.91564321 0.6428571 0.02380952 8.828761e-03
      1003  4.28966940 0.6071429 0.02380952 4.953461e-02
      1011  6.43932685 0.7142857 0.00000000 8.568298e-05
      1012  5.94226530 0.6785714 0.01190476 1.063115e-03
      1013  3.00620774 0.5476190 0.02380952 3.827331e-01
      1017  5.78551661 0.6190476 0.02380952 2.909633e-02
      1018  0.61714555 0.5740741 0.03703704 2.763029e-01
      1020  4.70454233 0.6111111 0.05555556 5.934644e-02
      1022  1.53146978 0.5438596 0.01754386 5.078006e-01
      1023  2.60640936 0.5357143 0.01785714 5.929801e-01
      1027  4.98520562 0.6547619 0.01190476 4.556350e-03
      1035  4.99537725 0.6666667 0.03571429 2.250227e-03
      1037 -0.80020938 0.4880952 0.02380952 1.172741e+00
      1043  2.71847842 0.6491228 0.05263158 2.434092e-02
      1062  0.88695956 0.4912281 0.08771930 1.105374e+00
      1066  2.06170989 0.5789474 0.05263158 2.332302e-01
      1078  3.18892993 0.6140351 0.07017544 8.508907e-02
      1086  3.21746721 0.7017544 0.07017544 2.315807e-03
      1093  2.06726998 0.5392157 0.03921569 4.282919e-01
      1095  1.46530832 0.4830769 0.03692308 1.458251e+00
      1105  2.01908631 0.5490196 0.04901961 3.221020e-01
      1107  1.83983900 0.5340909 0.02272727 5.224313e-01
      1110  1.29540364 0.5104167 0.04166667 8.382565e-01
      1113  0.88695956 0.4912281 0.08771930 1.105374e+00
      1117          NA        NA         NA           NA
      1118 -0.03592364 0.4666667 0.02666667 1.682689e+00
      1122  1.13087030 0.4788732 0.01408451 1.278185e+00
      1124  0.67751835 0.5223881 0.02985075 7.139858e-01
      1126  0.45429473 0.4680851 0.02127660 1.618529e+00
      1127  1.05809357 0.4705882 0.05882353 1.447547e+00
      1130  0.08098762 0.5180723 0.03614458 7.419344e-01
      1137 -0.09310271 0.4925373 0.02985075 1.097235e+00
      1138  1.09898027 0.5000000 0.05379747 1.000000e+00
      1139  0.32415759 0.5098039 0.03921569 8.430220e-01
      1141 -0.29324749 0.4436090 0.02255639 1.806627e+00
      1145  3.19224325 0.5581395 0.03488372 2.808875e-01
      1150  3.10524264 0.6052632 0.02631579 6.645742e-02
      1151  5.54335130 0.6118421 0.03289474 5.819817e-03
      1153  5.07928700 0.5468750 0.07812500 4.532547e-01
      1155  5.05001502 0.6054422 0.05442177 1.056287e-02
      1156  4.00484984 0.5517241 0.04597701 3.345943e-01
      1157  2.54085805 0.6633663 0.01980198 1.024820e-03
      1158  2.96978254 0.5915493 0.04225352 2.911902e-02
      1159  9.77819860 0.6796117 0.03398058 2.525176e-07
      1164  6.43932685 0.7142857 0.00000000 8.568298e-05
      1168 11.29525042 0.6785714 0.04166667 3.672575e-06
      1169  8.15865744 0.6402439 0.03048780 3.281542e-04
      1171  4.88096273 0.5514019 0.04672897 2.875960e-01
      1173  9.24243121 0.7272727 0.02020202 6.106436e-06
      1174  5.26298772 0.7592593 0.03703704 1.387885e-04
      1175  4.23349284 0.6144578 0.04819277 3.702204e-02
      1176  7.09213013 0.7361111 0.05555556 6.151089e-05
      1178  2.90975724 0.5614035 0.01754386 3.538369e-01
      1179  3.38421116 0.6785714 0.01785714 7.526315e-03
      1180  5.50308212 0.6283186 0.04424779 6.370212e-03
      1183  4.94894070 0.6914894 0.02127660 2.047226e-04
      1184  7.80026337 0.6448598 0.07476636 2.727553e-03
      1185  3.97464150 0.5441176 0.05882353 4.668543e-01
      1186  4.15868191 0.5925926 0.06172840 9.558070e-02
      1191  7.64339918 0.6463415 0.03048780 1.781293e-04
      1192  4.02425708 0.5894040 0.05298013 2.800411e-02
      1193  1.37276420 0.4606742 0.02247191 1.541912e+00
      1194  5.98640539 0.6666667 0.04273504 3.114910e-04
      1195  4.30914005 0.6489362 0.05319149 3.877252e-03
      1196  5.69408865 0.6666667 0.03418803 3.114910e-04
      1197  6.19671953 0.6239316 0.03418803 7.339134e-03
      1202  1.53881908 0.5072464 0.04347826 9.041775e-01
      1203  4.26055439 0.6250000 0.04605263 2.054719e-03
      1207  4.79893676 0.6190476 0.06802721 3.892417e-03
      1208  2.38640296 0.5362319 0.05797101 5.472212e-01
      1209  4.72205843 0.6590909 0.03787879 2.565504e-04
      1210  3.73088261 0.6057692 0.04807692 3.098405e-02
      1211  8.46160296 0.6582915 0.03015075 7.971363e-06
      1214  3.08016101 0.5689655 0.08620690 2.935106e-01
      1216  5.94226530 0.6785714 0.01190476 1.063115e-03
      1219 11.29525042 0.6785714 0.04166667 3.672575e-06
      1221  8.33749245 0.6358974 0.03589744 1.474004e-04
      1223  3.46342098 0.5652174 0.02898551 2.785987e-01
      1225  6.47992246 0.6262626 0.04040404 1.198470e-02
      1226  3.97127308 0.6588235 0.03529412 3.405348e-03
      1228  8.21194982 0.7378641 0.05825243 1.378326e-06
      1230  3.10380205 0.5454545 0.02272727 3.937686e-01
      1231  3.21327589 0.5517241 0.02298851 3.345943e-01
      1232  3.51528040 0.5600000 0.05333333 2.986976e-01
      1235  4.89530743 0.6382979 0.04255319 7.325016e-03
      1236  4.63151898 0.5362319 0.05797101 5.472212e-01
      1237  5.10230667 0.6029412 0.07352941 8.955507e-02
      1238  2.92577521 0.5797101 0.07246377 1.854219e-01
      1243  7.24890778 0.6153846 0.03589744 1.270697e-03
      1244  4.23081749 0.5486726 0.05309735 3.007656e-01
      1245  1.66518080 0.5250000 0.04166667 5.838824e-01
      1246  4.16887860 0.5949367 0.03797468 9.148192e-02
      1247  1.31037043 0.5000000 0.07142857 1.000000e+00
      1248  3.73717619 0.5822785 0.03797468 1.435730e-01
      1249  2.89925600 0.5338346 0.03759398 4.351561e-01
      1254  1.16559774 0.5384615 0.00000000 5.351435e-01
      1255  2.91566650 0.5723684 0.04605263 7.435291e-02
      1259  2.09469438 0.5102041 0.06802721 8.045709e-01
      1260  1.67679668 0.4461538 0.01538462 1.614739e+00
      1261  2.43025790 0.5405405 0.04054054 3.239398e-01
      1262  1.23565226 0.5400000 0.03000000 4.237108e-01
      1263  7.63163726 0.6303318 0.02843602 1.528725e-04
      1266  4.06637381 0.6216216 0.05405405 3.639761e-02
      1268  3.00620774 0.5476190 0.02380952 3.827331e-01
      1270          NA        NA         NA           NA
      1271  8.15865744 0.6402439 0.03048780 3.281542e-04
      1272  8.33749245 0.6358974 0.03589744 1.474004e-04
      1275  1.38259625 0.5076923 0.01538462 9.012878e-01
      1277  5.03461674 0.5959596 0.05050505 5.618836e-02
      1278  3.39217969 0.5247525 0.02970297 6.188234e-01
      1280  4.85201302 0.5714286 0.05042017 1.191414e-01
      1282  3.28564910 0.5576923 0.01923077 2.393165e-01
      1283  2.69844225 0.5631068 0.02912621 2.002189e-01
      1284  3.74546497 0.6197183 0.02816901 4.364036e-02
      1287  2.83116566 0.5319149 0.04255319 5.360134e-01
      1288  4.22100243 0.6923077 0.01538462 1.929540e-03
      1289  4.62194842 0.7230769 0.03076923 3.218994e-04
      1290  2.47067399 0.5384615 0.03076923 5.351435e-01
      1295  6.61608590 0.5734597 0.02843602 3.283230e-02
      1296  2.12829512 0.5321101 0.03669725 5.025529e-01
      1297  1.66390716 0.4705882 0.03676471 1.507283e+00
      1298  2.55104947 0.5333333 0.01333333 5.637029e-01
      1299  2.22452285 0.6923077 0.03846154 5.545667e-03
      1300  2.53481071 0.5200000 0.01333333 7.290345e-01
      1303  3.31077605 0.5377778 0.02666667 2.570743e-01
      1321  2.06170989 0.5789474 0.05263158 2.332302e-01
      1322 -0.03592364 0.4666667 0.02666667 1.682689e+00
      1334  4.39625415 0.7093023 0.00000000 1.036095e-04
      1338  1.61551600 0.5180723 0.01204819 7.419344e-01
      1346  5.23962227 0.5972222 0.03240741 4.266725e-03
      1358  2.75741594 0.6447368 0.02631579 1.161689e-02
      1359  0.79597722 0.4905660 0.07547170 1.109254e+00
      1361  6.64646762 0.6000000 0.05217391 3.197196e-02
      1363  1.31148877 0.5344828 0.12068966 5.994263e-01
      1364  6.15012923 0.6781609 0.05747126 8.887985e-04
      1366  6.05108234 0.6222222 0.03703704 4.508698e-03
      1367  5.75094395 0.6614173 0.03149606 2.745910e-04
      1371  7.82593561 0.7019231 0.02884615 3.814478e-05
      1375  4.88096273 0.5514019 0.04672897 2.875960e-01
      1376  3.46342098 0.5652174 0.02898551 2.785987e-01
      1377  1.38259625 0.5076923 0.01538462 9.012878e-01
      1380  4.63893840 0.6363636 0.02597403 1.670340e-02
      1383  3.97299259 0.5937500 0.03906250 3.389485e-02
      1388  8.78214379 0.6723164 0.02259887 4.538979e-06
      1392 11.06834015 0.6627219 0.06508876 2.328935e-05
      1393  5.32849920 0.5588235 0.04411765 3.319755e-01
      1394  4.09896682 0.5802469 0.06172840 1.486140e-01
      1396  7.61278339 0.8000000 0.01428571 5.168220e-07
      1399  5.36417120 0.6153846 0.01538462 6.281185e-02
      1400  4.86550662 0.6516129 0.05161290 1.599237e-04
      1402  8.30191432 0.6666667 0.02824859 9.219564e-06
      1403  4.10328295 0.5576923 0.03846154 2.393165e-01
      1404  7.61690707 0.6779661 0.02259887 2.186559e-06
      1413  3.82436744 0.6896552 0.05172414 3.867869e-03
      1423  4.11736405 0.6867470 0.02409639 6.672544e-04
      1431  4.63893840 0.6363636 0.02597403 1.670340e-02
      1435  4.22567273 0.7115385 0.05769231 2.281937e-03
      1440  3.92252853 0.6265060 0.02409639 2.116380e-02
      1441          NA        NA         NA           NA
      1444  5.75165536 0.5507246 0.08695652 3.993957e-01
      1448  4.47557941 0.7105263 0.03947368 2.419328e-04
      1452  4.44424726 0.7454545 0.01818182 2.719197e-04
      1454  6.27513214 0.6867470 0.04819277 6.672544e-04
      1456  6.07653600 0.6867470 0.03614458 6.672544e-04
      1457  4.77429753 0.6162791 0.05813953 3.103252e-02
      1463  2.81031788 0.5757576 0.03030303 1.316680e-01
      1467  5.51878806 0.6516854 0.03370787 4.209845e-03
      1469  2.47668430 0.6060606 0.04040404 3.480848e-02
      1471  7.29524881 0.6767677 0.05050505 4.354152e-04
      1476  5.78551661 0.6190476 0.02380952 2.909633e-02
      1479  9.24243121 0.7272727 0.02020202 6.106436e-06
      1480  6.47992246 0.6262626 0.04040404 1.198470e-02
      1481  5.03461674 0.5959596 0.05050505 5.618836e-02
      1486  5.02129057 0.7037037 0.05555556 2.755077e-03
      1488 11.29181596 0.7638889 0.08333333 7.522468e-06
      1490  2.96638910 0.6315789 0.05263158 4.694473e-02
      1491  3.82604376 0.6964286 0.05357143 3.283461e-03
      1495  5.99741977 0.6382979 0.04255319 7.325016e-03
      1503  7.13261357 0.7070707 0.05050505 3.777967e-05
      1505  1.31644349 0.4831461 0.04494382 1.249515e+00
      1509  6.23943859 0.7073171 0.03252033 4.255128e-06
      1515  3.12518114 0.5740741 0.03703704 2.763029e-01
      1521  4.93486656 0.6422764 0.04065041 1.600346e-03
      1523  9.12366726 0.7235772 0.02439024 7.079026e-07
      1526  5.59267905 0.6770833 0.05208333 5.202443e-04
      1528  0.61714555 0.5740741 0.03703704 2.763029e-01
      1530  1.13087030 0.4788732 0.01408451 1.278185e+00
      1531  5.26298772 0.7592593 0.03703704 1.387885e-04
      1532  3.97127308 0.6588235 0.03529412 3.405348e-03
      1533  3.39217969 0.5247525 0.02970297 6.188234e-01
      1537  5.02129057 0.7037037 0.05555556 2.755077e-03
      1540  8.67846371 0.7647059 0.02521008 7.686149e-09
      1542 11.29607925 0.7479675 0.02439024 3.793935e-08
      1543  6.55239344 0.6829268 0.03252033 4.959798e-05
      1547  1.96460545 0.5925926 0.03703704 1.735682e-01
      1553  5.22283727 0.6984127 0.01587302 1.634360e-03
      1554  8.47387230 0.7246377 0.01449275 1.899946e-04
      1555  9.98475809 0.7154472 0.03252033 1.763015e-06
      1557  2.73374910 0.5365854 0.02439024 4.170771e-01
      1566  0.75308613 0.5769231 0.00000000 2.672575e-01
      1569  5.13638087 0.5963303 0.06422018 4.427951e-02
      1572  1.70141854 0.5555556 0.03174603 3.778216e-01
      1574  3.92118181 0.5945946 0.04504505 4.623607e-02
      1575  3.83440260 0.6310680 0.03883495 7.805044e-03
      1579  2.62363077 0.5949367 0.05063291 9.148192e-02
      1583  4.23349284 0.6144578 0.04819277 3.702204e-02
      1587  3.97299259 0.5937500 0.03906250 3.389485e-02
      1588  4.22567273 0.7115385 0.05769231 2.281937e-03
      1596  3.80786881 0.5781250 0.03125000 7.709987e-02
      1600  5.35829278 0.6015625 0.07812500 2.155627e-02
      1602  1.76493622 0.5789474 0.00000000 2.332302e-01
      1608  2.55961142 0.5625000 0.04687500 1.572992e-01
      1610  6.42164439 0.6328125 0.03125000 2.654029e-03
      1611  4.96925150 0.6666667 0.03225806 1.306490e-03
      1612  6.12603882 0.6250000 0.03125000 4.677735e-03
      1613  7.86749352 0.6642336 0.05839416 1.207446e-04
      1619  2.42096130 0.5694444 0.04166667 2.385928e-01
      1623  4.45880423 0.6612903 0.06451613 1.108517e-02
      1625  4.37525776 0.6569343 0.06569343 2.390279e-04
      1627  8.18953660 0.6861314 0.05109489 1.317224e-05
      1630  4.62048927 0.6195652 0.07608696 2.181012e-02
      1632  4.70454233 0.6111111 0.05555556 5.934644e-02
      1634  0.67751835 0.5223881 0.02985075 7.139858e-01
      1635  7.09213013 0.7361111 0.05555556 6.151089e-05
      1636  8.21194982 0.7378641 0.05825243 1.378326e-06
      1637  4.85201302 0.5714286 0.05042017 1.191414e-01
      1641 11.29181596 0.7638889 0.08333333 7.522468e-06
      1642  8.67846371 0.7647059 0.02521008 7.686149e-09
      1646  6.98401205 0.6803279 0.03278689 6.788685e-05
      1647  5.42590193 0.6363636 0.04132231 2.699796e-03
      1651  5.50798846 0.6666667 0.06944444 4.677735e-03
      1657  4.93925262 0.7457627 0.03389831 1.597009e-04
      1658  8.63849837 0.8307692 0.03076923 9.634097e-08
      1659  9.32784891 0.7080292 0.05839416 1.116894e-06
      1661  1.28856599 0.5182482 0.05839416 6.692491e-01
      1669  1.82161324 0.4765101 0.10067114 1.433668e+00
      1672  0.11097661 0.5098039 0.04901961 8.430220e-01
      1674  2.08136273 0.4725275 0.05494505 1.399821e+00
      1681  0.44355997 0.4909091 0.04545455 1.151233e+00
      1717  5.79740652 0.6369427 0.03184713 5.996479e-04
      1719  5.38463941 0.6275862 0.01379310 2.121439e-03
      1723  0.57397454 0.4912281 0.01754386 1.105374e+00
      1729  5.59216119 0.6114650 0.03184713 5.217262e-03
      1731  6.65972704 0.6293706 0.02797203 1.974140e-03
      1734  3.86295977 0.5537190 0.04958678 2.372779e-01
      1736  1.53146978 0.5438596 0.01754386 5.078006e-01
      1738  0.45429473 0.4680851 0.02127660 1.618529e+00
      1739  2.90975724 0.5614035 0.01754386 3.538369e-01
      1740  3.10380205 0.5454545 0.02272727 3.937686e-01
      1741  3.28564910 0.5576923 0.01923077 2.393165e-01
      1742  4.39625415 0.7093023 0.00000000 1.036095e-04
      1745  2.96638910 0.6315789 0.05263158 4.694473e-02
      1746 11.29607925 0.7479675 0.02439024 3.793935e-08
      1748  6.98401205 0.6803279 0.03278689 6.788685e-05
      1751  5.96947343 0.6217949 0.04487179 2.346726e-03
      1754  3.91895031 0.5797101 0.01449275 1.854219e-01
      1755  1.66171936 0.5087719 0.03508772 8.946258e-01
      1761  5.06451195 0.7313433 0.01492537 1.523221e-04
      1762 16.34543987 0.7526882 0.03225806 5.485390e-12
      1763  9.99493156 0.6942675 0.03821656 1.125453e-06
      1765  3.03282157 0.5585106 0.02659574 1.086006e-01
      1769  4.87595238 0.6089744 0.05128205 6.485308e-03
      1771  0.70943739 0.5084746 0.05084746 8.964170e-01
      1775  1.55150174 0.6250000 0.01785714 6.136883e-02
      1781  2.55185611 0.5384615 0.05128205 3.366684e-01
      1783  5.27627051 0.6267606 0.04225352 2.518974e-03
      1786  2.83967873 0.5702479 0.07438017 1.222364e-01
      1788  2.60640936 0.5357143 0.01785714 5.929801e-01
      1790  1.05809357 0.4705882 0.05882353 1.447547e+00
      1791  3.38421116 0.6785714 0.01785714 7.526315e-03
      1792  3.21327589 0.5517241 0.02298851 3.345943e-01
      1793  2.69844225 0.5631068 0.02912621 2.002189e-01
      1797  3.82604376 0.6964286 0.05357143 3.283461e-03
      1798  6.55239344 0.6829268 0.03252033 4.959798e-05
      1800  5.42590193 0.6363636 0.04132231 2.699796e-03
      1802  5.96947343 0.6217949 0.04487179 2.346726e-03
      1807  1.93040321 0.5535714 0.01785714 4.226781e-01
      1813  2.56937867 0.5970149 0.02985075 1.122405e-01
      1814  4.93168329 0.5800000 0.08000000 1.095986e-01
      1815  7.78116759 0.6987179 0.04487179 6.906563e-07
      1817  0.37463531 0.4807692 0.05128205 1.369046e+00
      1826  2.99345060 0.5921053 0.01315789 1.082937e-01
      1827  1.47107898 0.5254237 0.06779661 6.961175e-01
      1829  4.92482298 0.5565217 0.03478261 2.254143e-01
      1831  1.82002078 0.5312500 0.10937500 6.170751e-01
      1832  2.97302305 0.5287356 0.03448276 5.919197e-01
      1834  4.69696814 0.6028369 0.02127660 1.459642e-02
      1835  5.25715694 0.6090226 0.01503759 1.191611e-02
      1836  4.11487352 0.6666667 0.00000000 1.430588e-02
      1839  6.92748028 0.6861314 0.00729927 1.317224e-05
      1843  5.50308212 0.6283186 0.04424779 6.370212e-03
      1844  3.51528040 0.5600000 0.05333333 2.986976e-01
      1845  3.74546497 0.6197183 0.02816901 4.364036e-02
      1847  8.78214379 0.6723164 0.02259887 4.538979e-06
      1848  3.92252853 0.6265060 0.02409639 2.116380e-02
      1851  3.80786881 0.5781250 0.03125000 7.709987e-02
      1857  0.70660650 0.4605263 0.06578947 1.508703e+00
      1860 12.84417804 0.6627219 0.05325444 2.328935e-05
      1861  6.81861747 0.6470588 0.04411765 1.529337e-02
      1862  5.77533580 0.6543210 0.03703704 5.473204e-03
      1864  4.66715875 0.6213592 0.01941748 1.376558e-02
      1867  4.01195155 0.6197183 0.01408451 4.364036e-02
      1868  4.90503223 0.5714286 0.03726708 6.988521e-02
      1870  7.94553731 0.6435644 0.01485149 4.486826e-05
      1871  3.74426937 0.5480769 0.02884615 3.267996e-01
      1872  7.73628696 0.6485149 0.00990099 2.425902e-05
      1888  0.99710476 0.5161290 0.06451613 7.994954e-01
      1891  0.39000809 0.5595238 0.05952381 2.752335e-01
      1900          NA        NA         NA           NA
      1908  0.70660650 0.4605263 0.06578947 1.508703e+00
      1916  1.05546673 0.5714286 0.08333333 1.904303e-01
      1922  1.48831878 0.5483871 0.08064516 4.460595e-01
      1924  1.15098890 0.5483871 0.06451613 4.460595e-01
      1927  3.25559723 0.5542169 0.02409639 3.232122e-01
      1945  3.18892993 0.6140351 0.07017544 8.508907e-02
      1946  0.08098762 0.5180723 0.03614458 7.419344e-01
      1950  1.61551600 0.5180723 0.01204819 7.419344e-01
      1958  3.91895031 0.5797101 0.01449275 1.854219e-01
      1970  4.93940375 0.6867470 0.02409639 6.672544e-04
      1977  4.19432051 0.6279070 0.04651163 1.767673e-02
      1983  2.99662212 0.6063830 0.03191489 3.912760e-02
      1987  3.29493506 0.5595238 0.03571429 2.752335e-01
      1989  5.42803973 0.7127660 0.04255319 3.696329e-05
      1991  3.82917418 0.5851064 0.05319149 9.888691e-02
      1996  4.98520562 0.6547619 0.01190476 4.556350e-03
      1999  4.94894070 0.6914894 0.02127660 2.047226e-04
      2000  4.89530743 0.6382979 0.04255319 7.325016e-03
      2001  2.83116566 0.5319149 0.04255319 5.360134e-01
      2005  5.99741977 0.6382979 0.04255319 7.325016e-03
      2006  1.96460545 0.5925926 0.03703704 1.735682e-01
      2008  5.50798846 0.6666667 0.06944444 4.677735e-03
      2010  1.66171936 0.5087719 0.03508772 8.946258e-01
      2011  1.93040321 0.5535714 0.01785714 4.226781e-01
      2023  6.00845882 0.7127660 0.05319149 3.696329e-05
      2025  0.84701769 0.5280899 0.03370787 5.961127e-01
      2034  3.08612890 0.5921053 0.02631579 1.082937e-01
      2035  1.89697919 0.5660377 0.03773585 3.362888e-01
      2037  7.99626189 0.5565217 0.09565217 2.254143e-01
      2039  1.26168213 0.5862069 0.12068966 1.891613e-01
      2040  4.97162031 0.5287356 0.05747126 5.919197e-01
      2042  7.27707678 0.6074074 0.06666667 1.256300e-02
      2043  8.41715072 0.6535433 0.06299213 5.387921e-04
      2047  5.28962289 0.6354167 0.07291667 7.963489e-03
      2051  7.80026337 0.6448598 0.07476636 2.727553e-03
      2052  4.63151898 0.5362319 0.05797101 5.472212e-01
      2053  4.22100243 0.6923077 0.01538462 1.929540e-03
      2055 11.06834015 0.6627219 0.06508876 2.328935e-05
      2056  5.75165536 0.5507246 0.08695652 3.993957e-01
      2059  5.35829278 0.6015625 0.07812500 2.155627e-02
      2064 12.84417804 0.6627219 0.05325444 2.328935e-05
      2069  8.38214417 0.7058824 0.04411765 6.850369e-04
      2070  9.04522998 0.7037037 0.04938272 2.457328e-04
      2072  4.67475147 0.6129032 0.08064516 7.540356e-02
      2075  7.13605209 0.6307692 0.01538462 3.497994e-02
      2076  6.97566701 0.6258065 0.08387097 1.732917e-03
      2078 11.26448891 0.6745562 0.05325444 5.666613e-06
      2079  5.35567611 0.6250000 0.07692308 1.078745e-02
      2080 10.37644692 0.6686391 0.05325444 1.161909e-05
      2086  2.10489289 0.5441176 0.02941176 4.668543e-01
      2087  1.34151163 0.4716981 0.07547170 1.319720e+00
      2091  1.84687170 0.5689655 0.13793103 2.935106e-01
      2092  2.65896942 0.5000000 0.04411765 1.000000e+00
      2094  3.16643228 0.5441176 0.04411765 4.668543e-01
      2095  7.13896237 0.6029412 0.02941176 8.955507e-02
      2103  3.97464150 0.5441176 0.05882353 4.668543e-01
      2104  5.10230667 0.6029412 0.07352941 8.955507e-02
      2105  4.62194842 0.7230769 0.03076923 3.218994e-04
      2107  5.32849920 0.5588235 0.04411765 3.319755e-01
      2116  6.81861747 0.6470588 0.04411765 1.529337e-02
      2120  8.38214417 0.7058824 0.04411765 6.850369e-04
      2122  2.99846415 0.5735294 0.05882353 2.252529e-01
      2127  3.57126546 0.6307692 0.03076923 3.497994e-02
      2128  3.37867319 0.5441176 0.05882353 4.668543e-01
      2130  4.81038669 0.5735294 0.02941176 2.252529e-01
      2131  2.10446437 0.5818182 0.07272727 2.249159e-01
      2132  3.99272718 0.5588235 0.02941176 3.319755e-01
      2138  1.58034033 0.5921053 0.02631579 1.082937e-01
      2139  1.35285919 0.4905660 0.09433962 1.109254e+00
      2143  0.58542752 0.5000000 0.13793103 1.000000e+00
      2144  2.68470795 0.5925926 0.03703704 9.558070e-02
      2146  5.30982767 0.7160494 0.03703704 1.007042e-04
      2147  5.17090062 0.6419753 0.02469136 1.060184e-02
      2155  4.15868191 0.5925926 0.06172840 9.558070e-02
      2156  2.92577521 0.5797101 0.07246377 1.854219e-01
      2157  2.47067399 0.5384615 0.03076923 5.351435e-01
      2159  4.09896682 0.5802469 0.06172840 1.486140e-01
      2163  1.76493622 0.5789474 0.00000000 2.332302e-01
      2168  5.77533580 0.6543210 0.03703704 5.473204e-03
      2172  9.04522998 0.7037037 0.04938272 2.457328e-04
      2173  2.99846415 0.5735294 0.05882353 2.252529e-01
      2179  6.67889026 0.6153846 0.03076923 6.281185e-02
      2180  3.16842463 0.5802469 0.02469136 1.486140e-01
      2182  6.90868439 0.6790123 0.02469136 1.272004e-03
      2183  2.47022878 0.5588235 0.02941176 3.319755e-01
      2184  5.94752395 0.6666667 0.02469136 2.699796e-03
      2245  4.22976500 0.6666667 0.05882353 1.729028e-02
      2252  4.53607556 0.6219512 0.03658537 2.720035e-02
      2255  6.53843979 0.7045455 0.02272727 2.600383e-06
      2263  7.61278339 0.8000000 0.01428571 5.168220e-07
      2264  4.47557941 0.7105263 0.03947368 2.419328e-04
      2272  4.66715875 0.6213592 0.01941748 1.376558e-02
      2273  1.05546673 0.5714286 0.08333333 1.904303e-01
      2276  4.67475147 0.6129032 0.08064516 7.540356e-02
      2286  6.48787418 0.7303371 0.02247191 1.386481e-05
      2288  6.34938743 0.7303371 0.02247191 1.386481e-05
      2289  4.56882160 0.6417910 0.04477612 2.027500e-02
      2301  3.81714110 0.6119403 0.04477612 6.687076e-02
      2303  3.26592239 0.6268657 0.01492537 3.781258e-02
      2306  3.42926753 0.5522388 0.04477612 3.924481e-01
      2310 -0.09310271 0.4925373 0.02985075 1.097235e+00
      2318  5.22283727 0.6984127 0.01587302 1.634360e-03
      2320  4.93925262 0.7457627 0.03389831 1.597009e-04
      2322  5.06451195 0.7313433 0.01492537 1.523221e-04
      2323  2.56937867 0.5970149 0.02985075 1.122405e-01
      2334  4.76682129 0.6567164 0.04477612 1.030099e-02
      2335  4.24191462 0.6417910 0.01492537 2.027500e-02
      2337  0.36123749 0.5522388 0.02985075 3.924481e-01
      2341  6.28155102 0.7000000 0.04000000 6.334248e-05
      2343 10.02441978 0.6327273 0.05090909 1.072251e-05
      2353  5.76071481 0.6700000 0.06000000 6.738585e-04
      2355  8.30115022 0.7674419 0.04651163 7.038165e-07
      2358  3.14443581 0.6276596 0.06382979 1.330829e-02
      2361  3.21746721 0.7017544 0.07017544 2.315807e-03
      2362  1.09898027 0.5000000 0.05379747 1.000000e+00
      2366  5.23962227 0.5972222 0.03240741 4.266725e-03
      2370  8.47387230 0.7246377 0.01449275 1.899946e-04
      2372  8.63849837 0.8307692 0.03076923 9.634097e-08
      2374 16.34543987 0.7526882 0.03225806 5.485390e-12
      2375  4.93168329 0.5800000 0.08000000 1.095986e-01
      2378  4.93940375 0.6867470 0.02409639 6.672544e-04
      2385  4.76682129 0.6567164 0.04477612 1.030099e-02
      2387  8.25316057 0.7300000 0.06000000 4.224909e-06
      2389  1.94351614 0.5572519 0.03816794 1.900078e-01
      2393  7.01318469 0.6559140 0.05376344 2.111459e-05
      2395  1.36844501 0.5254237 0.03389831 6.961175e-01
      2398  1.72881554 0.6000000 0.00000000 1.068637e-01
      2399  4.06726031 0.6118421 0.04605263 5.819817e-03
      2403  3.24055667 0.5986395 0.06802721 1.676234e-02
      2404  2.87865561 0.5384615 0.01538462 5.351435e-01
      2405  4.50347702 0.6169154 0.04477612 9.160235e-04
      2406  5.20372019 0.6200000 0.01000000 1.639507e-02
      2407 11.06237782 0.6720000 0.03200000 5.354511e-08
      2410  4.62747357 0.6611570 0.04958678 3.919366e-04
      2412  4.99537725 0.6666667 0.03571429 2.250227e-03
      2414  0.32415759 0.5098039 0.03921569 8.430220e-01
      2415  7.64339918 0.6463415 0.03048780 1.781293e-04
      2416  7.24890778 0.6153846 0.03589744 1.270697e-03
      2417  6.61608590 0.5734597 0.02843602 3.283230e-02
      2419  5.36417120 0.6153846 0.01538462 6.281185e-02
      2421  7.13261357 0.7070707 0.05050505 3.777967e-05
      2422  9.98475809 0.7154472 0.03252033 1.763015e-06
      2424  9.32784891 0.7080292 0.05839416 1.116894e-06
      2426  9.99493156 0.6942675 0.03821656 1.125453e-06
      2427  7.78116759 0.6987179 0.04487179 6.906563e-07
      2428  4.01195155 0.6197183 0.01408451 4.364036e-02
      2431  6.00845882 0.7127660 0.05319149 3.696329e-05
      2432  7.13605209 0.6307692 0.01538462 3.497994e-02
      2433  3.57126546 0.6307692 0.03076923 3.497994e-02
      2434  6.67889026 0.6153846 0.03076923 6.281185e-02
      2437  4.24191462 0.6417910 0.01492537 2.027500e-02
      2438  8.25316057 0.7300000 0.06000000 4.224909e-06
      2440  5.16212810 0.6330275 0.02752294 5.474577e-03
      2441  3.00866645 0.5502646 0.04232804 1.669574e-01
      2442  4.16069911 0.6666667 0.00000000 3.892417e-03
      2443  1.91373461 0.5000000 0.03846154 1.000000e+00
      2444  3.31728541 0.6533333 0.00000000 7.911789e-03
      2450  2.92336703 0.6842105 0.02631579 1.318969e-03
      2451  1.89292623 0.6288660 0.06185567 1.113716e-02
      2453  3.59733880 0.6339286 0.06250000 4.586392e-03
      2455  2.51243934 0.6274510 0.07843137 1.004189e-02
      2456  2.95773197 0.5057471 0.04597701 9.146214e-01
      2458  6.16893514 0.6411765 0.03529412 2.319277e-04
      2459  3.12233393 0.5438596 0.04093567 2.513491e-01
      2463  3.77797831 0.6585366 0.04878049 4.088913e-03
      2467  4.02425708 0.5894040 0.05298013 2.800411e-02
      2468  4.23081749 0.5486726 0.05309735 3.007656e-01
      2469  2.12829512 0.5321101 0.03669725 5.025529e-01
      2471  4.86550662 0.6516129 0.05161290 1.599237e-04
      2472  4.44424726 0.7454545 0.01818182 2.719197e-04
      2475  2.55961142 0.5625000 0.04687500 1.572992e-01
      2480  4.90503223 0.5714286 0.03726708 6.988521e-02
      2484  6.97566701 0.6258065 0.08387097 1.732917e-03
      2485  3.37867319 0.5441176 0.05882353 4.668543e-01
      2486  3.16842463 0.5802469 0.02469136 1.486140e-01
      2491  5.16212810 0.6330275 0.02752294 5.474577e-03
      2494  4.55198946 0.6363636 0.03636364 4.596261e-04
      2495  1.34523880 0.5673077 0.04807692 1.698105e-01
      2496  3.79767562 0.6303030 0.03636364 8.153061e-04
      2497  0.87259576 0.5322581 0.04301075 3.789229e-01
      2499  2.35965627 0.6000000 0.00000000 5.777957e-02
      2503  1.01853026 0.4382022 0.03370787 1.756385e+00
      2507  0.47957563 0.4683544 0.03797468 1.426255e+00
      2509  2.11895961 0.5343915 0.03703704 3.443471e-01
      2511  3.72116924 0.6228571 0.04000000 1.152045e-03
      2514  2.01162795 0.5123967 0.04958678 7.850629e-01
      2516 -0.80020938 0.4880952 0.02380952 1.172741e+00
      2518 -0.29324749 0.4436090 0.02255639 1.806627e+00
      2519  1.37276420 0.4606742 0.02247191 1.541912e+00
      2520  1.66518080 0.5250000 0.04166667 5.838824e-01
      2521  1.66390716 0.4705882 0.03676471 1.507283e+00
      2525  1.31644349 0.4831461 0.04494382 1.249515e+00
      2526  2.73374910 0.5365854 0.02439024 4.170771e-01
      2528  1.28856599 0.5182482 0.05839416 6.692491e-01
      2530  3.03282157 0.5585106 0.02659574 1.086006e-01
      2531  0.37463531 0.4807692 0.05128205 1.369046e+00
      2535  0.84701769 0.5280899 0.03370787 5.961127e-01
      2541  0.36123749 0.5522388 0.02985075 3.924481e-01
      2542  1.94351614 0.5572519 0.03816794 1.900078e-01
      2543  3.00866645 0.5502646 0.04232804 1.669574e-01
      2554  1.96199700 0.5789474 0.00000000 1.686686e-01
      2555  2.10995993 0.6190476 0.04761905 5.878172e-02
      2557  6.44672611 0.6521739 0.04347826 1.099416e-03
      2559  2.02544221 0.6029412 0.08823529 8.955507e-02
      2560  1.38501707 0.5057471 0.02298851 9.146214e-01
      2562  5.28961625 0.6413793 0.02068966 6.619685e-04
      2563  6.74920035 0.7153285 0.01459854 4.638074e-07
      2567  4.89838960 0.5934959 0.02439024 3.809416e-02
      2571  5.98640539 0.6666667 0.04273504 3.114910e-04
      2572  4.16887860 0.5949367 0.03797468 9.148192e-02
      2573  2.55104947 0.5333333 0.01333333 5.637029e-01
      2575  8.30191432 0.6666667 0.02824859 9.219564e-06
      2576  6.27513214 0.6867470 0.04819277 6.672544e-04
      2579  6.42164439 0.6328125 0.03125000 2.654029e-03
      2584  7.94553731 0.6435644 0.01485149 4.486826e-05
      2585  1.48831878 0.5483871 0.08064516 4.460595e-01
      2588 11.26448891 0.6745562 0.05325444 5.666613e-06
      2589  4.81038669 0.5735294 0.02941176 2.252529e-01
      2590  6.90868439 0.6790123 0.02469136 1.272004e-03
      2592  6.48787418 0.7303371 0.02247191 1.386481e-05
      2595  4.16069911 0.6666667 0.00000000 3.892417e-03
      2596  4.55198946 0.6363636 0.03636364 4.596261e-04
      2599  4.97701917 0.6346154 0.02884615 6.039559e-03
      2600 56.08987166 0.9805825 0.01456311 0.000000e+00
      2606 -0.92107103 0.5396825 0.03174603 5.287333e-01
      2609  6.14634665 0.5945946 0.04054054 1.036380e-01
      2612  2.22064098 0.5675676 0.05405405 2.450420e-01
      2614  3.75738021 0.5769231 0.03846154 1.166645e-01
      2615  3.45472966 0.6730769 0.01923077 4.154176e-04
      2623  4.30914005 0.6489362 0.05319149 3.877252e-03
      2624  1.31037043 0.5000000 0.07142857 1.000000e+00
      2625  2.22452285 0.6923077 0.03846154 5.545667e-03
      2627  4.10328295 0.5576923 0.03846154 2.393165e-01
      2631  4.96925150 0.6666667 0.03225806 1.306490e-03
      2636  3.74426937 0.5480769 0.02884615 3.267996e-01
      2640  5.35567611 0.6250000 0.07692308 1.078745e-02
      2641  2.10446437 0.5818182 0.07272727 2.249159e-01
      2642  2.47022878 0.5588235 0.02941176 3.319755e-01
      2647  1.91373461 0.5000000 0.03846154 1.000000e+00
      2648  1.34523880 0.5673077 0.04807692 1.698105e-01
      2650  4.97701917 0.6346154 0.02884615 6.039559e-03
      2652  5.23617425 0.6538462 0.02884615 1.701872e-03
      2658  1.52750505 0.5657895 0.00000000 2.513491e-01
      2659  1.95779314 0.6031746 0.04761905 1.014538e-01
      2661  6.49026050 0.6434783 0.04347826 2.089089e-03
      2663  1.83247594 0.5882353 0.08823529 1.456101e-01
      2664  0.73355882 0.5172414 0.02298851 7.477302e-01
      2666  4.93827875 0.6275862 0.02068966 2.121439e-03
      2667  5.69677517 0.7153285 0.01459854 4.638074e-07
      2671  5.04574004 0.6016260 0.01626016 2.418522e-02
      2675  5.69408865 0.6666667 0.03418803 3.114910e-04
      2676  3.73717619 0.5822785 0.03797468 1.435730e-01
      2677  2.53481071 0.5200000 0.01333333 7.290345e-01
      2679  7.61690707 0.6779661 0.02259887 2.186559e-06
      2680  6.07653600 0.6867470 0.03614458 6.672544e-04
      2683  6.12603882 0.6250000 0.03125000 4.677735e-03
      2688  7.73628696 0.6485149 0.00990099 2.425902e-05
      2689  1.15098890 0.5483871 0.06451613 4.460595e-01
      2692 10.37644692 0.6686391 0.05325444 1.161909e-05
      2693  3.99272718 0.5588235 0.02941176 3.319755e-01
      2694  5.94752395 0.6666667 0.02469136 2.699796e-03
      2696  6.34938743 0.7303371 0.02247191 1.386481e-05
      2699  3.31728541 0.6533333 0.00000000 7.911789e-03
      2700  3.79767562 0.6303030 0.03636364 8.153061e-04
      2702 56.08987166 0.9805825 0.01456311 0.000000e+00
      2703  5.23617425 0.6538462 0.02884615 1.701872e-03

