% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{denim_dsl}
\alias{denim_dsl}
\title{Define transitions using denim's domain-specific language (DSL)}
\usage{
denim_dsl(x)
}
\arguments{
\item{x}{\itemize{
\item an expression written in denim's DSL syntax. Each line should be a transition written in the
format \code{compartment -> out_compartment = expression} where expression can be either a math expression
or one of denim's built-in dwell time distribution function
}}
}
\value{
denim_transition object
}
\description{
This function parses model transitions defined in denim's DSL syntax
}
\examples{
transitions <- denim_dsl({
  S -> I = beta * (I/N) * S * timeStep
  I -> R = d_gamma(rate = 1/4, shape = 3)
})
}
