% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.summary.naivedensityratio}
\alias{print.summary.naivedensityratio}
\title{Print a \code{summary.naivedensityratio} object}
\usage{
\method{print}{summary.naivedensityratio}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{Object of class \code{summary.naivedensityratio}.}

\item{digits}{Number of digits to use when printing the output.}

\item{...}{further arguments on how to format the number of digits.}
}
\value{
\code{invisble} The inputted \code{summary.naivedensityratio} object.
}
\description{
Print a \code{summary.naivedensityratio} object
}
\examples{
set.seed(123)
# Fit model
dr <- naive(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
naive(numerator_small, denominator_small, m=2, kernel="epanechnikov")
}
\seealso{
\code{\link{print}}, \code{\link{summary.naivedensityratio}},
\code{\link{naive}}
}
